/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TokenSequence
implements TokenList {
    private static final Logger LOG = Logger.getInstance(TokenSequence.class);
    private final CharSequence myText;
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int @NotNull [] lexStarts, @NotNull @NotNull IElementType @NotNull [] lexTypes, int lexemeCount, @NotNull CharSequence text) {
        if (text == null) {
            TokenSequence.$$$reportNull$$$0(0);
        }
        if (lexStarts == null) {
            TokenSequence.$$$reportNull$$$0(1);
        }
        if (lexTypes == null) {
            TokenSequence.$$$reportNull$$$0(2);
        }
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        this.myText = text;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text, @NotNull Lexer lexer) {
        if (text == null) {
            TokenSequence.$$$reportNull$$$0(3);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(4);
        }
        TokenSequence sequence = new Builder(text, lexer).performLexing();
        assert (this.lexemeCount == sequence.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence.lexStarts[j] != this.lexStarts[j] || sequence.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    @NotNull
    public static TokenList performLexing(@NotNull CharSequence text, @NotNull Lexer lexer) {
        TokenList existing;
        if (text == null) {
            TokenSequence.$$$reportNull$$$0(5);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(6);
        }
        if (lexer instanceof WrappingLexer && (existing = ((WrappingLexer)lexer).getTokens()) instanceof TokenSequence && Comparing.equal((CharSequence)text, (CharSequence)((TokenSequence)existing).myText)) {
            return new TokenSequence(((TokenSequence)existing).lexStarts, (IElementType[])((TokenSequence)existing).lexTypes.clone(), ((TokenSequence)existing).lexemeCount, text);
        }
        TokenSequence tokenSequence = new Builder(text, lexer).performLexing();
        if (tokenSequence == null) {
            TokenSequence.$$$reportNull$$$0(7);
        }
        return tokenSequence;
    }

    public int getTokenCount() {
        return this.lexemeCount;
    }

    @Nullable
    public IElementType getTokenType(int index) {
        if (index < 0 || index >= this.getTokenCount()) {
            return null;
        }
        return this.lexTypes[index];
    }

    public int getTokenStart(int index) {
        return this.lexStarts[index];
    }

    public int getTokenEnd(int index) {
        return this.lexStarts[index + 1];
    }

    @NotNull
    public CharSequence getTokenizedText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            TokenSequence.$$$reportNull$$$0(8);
        }
        return charSequence;
    }

    @NotNull
    public Lexer asLexer() {
        return new WrappingLexer(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexStarts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexTypes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performLexing";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertMatches";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performLexing";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text, @NotNull Lexer lexer) {
            if (text == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (lexer == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset = 0;
            while ((type = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                    this.reportDescendingOffsets(i, offset, tokenStart);
                }
                this.myLexStarts[i] = offset = tokenStart;
                this.myLexTypes[i] = type;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            return new TokenSequence(this.myLexStarts, this.myLexTypes, i, this.myText);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
            @NonNls StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error(sb.toString());
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc((int[])this.myLexStarts, (int)newSize);
            this.myLexTypes = (IElementType[])ArrayUtil.realloc((Object[])this.myLexTypes, (int)newSize, (ArrayFactory)IElementType.ARRAY_FACTORY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lexer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/impl/TokenSequence$Builder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    static class WrappingLexer
    extends LexerBase {
        @NotNull
        private final TokenList myTokens;
        private int myIndex;

        WrappingLexer(@NotNull TokenList tokens) {
            if (tokens == null) {
                WrappingLexer.$$$reportNull$$$0(0);
            }
            this.myTokens = tokens;
        }

        @NotNull
        public TokenList getTokens() {
            TokenList tokenList = this.myTokens;
            if (tokenList == null) {
                WrappingLexer.$$$reportNull$$$0(1);
            }
            return tokenList;
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                WrappingLexer.$$$reportNull$$$0(2);
            }
            assert (Comparing.equal((CharSequence)buffer, (CharSequence)this.myTokens.getTokenizedText()));
            assert (startOffset == 0);
            assert (endOffset == buffer.length());
            assert (initialState == 0);
            this.myIndex = 0;
        }

        public int getState() {
            return this.myIndex;
        }

        @Nullable
        public IElementType getTokenType() {
            return this.myTokens.getTokenType(this.myIndex);
        }

        public int getTokenStart() {
            return this.myTokens.getTokenStart(this.myIndex);
        }

        public int getTokenEnd() {
            return this.myTokens.getTokenEnd(this.myIndex);
        }

        public void advance() {
            ++this.myIndex;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myTokens.getTokenizedText();
            if (charSequence == null) {
                WrappingLexer.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        public int getBufferEnd() {
            return this.myTokens.getTokenizedText().length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokens";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/impl/TokenSequence$WrappingLexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/impl/TokenSequence$WrappingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokens";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

