/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlexAdapter
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(FlexAdapter.class);
    private final FlexLexer myFlex;
    private IElementType myTokenType;
    private CharSequence myText;
    private int myTokenStart;
    private int myTokenEnd;
    private int myBufferEnd;
    private int myState;
    private boolean myFailed;

    public FlexAdapter(@NotNull FlexLexer flex) {
        if (flex == null) {
            FlexAdapter.$$$reportNull$$$0(0);
        }
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            FlexAdapter.$$$reportNull$$$0(1);
        }
        this.myText = buffer;
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    public int getState() {
        this.locateToken();
        return this.myState;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            FlexAdapter.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        this.locateToken();
        return new FlexAdapterPosition(this.myTokenType, this.myTokenStart, this.myTokenEnd, this.myState, this.myFlex.yystate());
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            FlexAdapter.$$$reportNull$$$0(3);
        }
        FlexAdapterPosition flexAdapterPosition = (FlexAdapterPosition)position;
        this.myFlex.reset(this.myText, flexAdapterPosition.tokenEnd, this.getBufferEnd(), flexAdapterPosition.flexState);
        this.myTokenStart = flexAdapterPosition.tokenStart;
        this.myTokenEnd = flexAdapterPosition.tokenEnd;
        this.myTokenType = flexAdapterPosition.currentToken;
        this.myState = flexAdapterPosition.state;
    }

    protected void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        if (this.myFailed) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
            this.myTokenEnd = this.myFlex.getTokenEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.myFailed = true;
            this.myTokenType = TokenType.BAD_CHARACTER;
            this.myTokenEnd = this.myBufferEnd;
            LOG.warn(this.myFlex.getClass().getName(), e);
        }
    }

    public String toString() {
        return "FlexAdapter for " + this.myFlex.getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/FlexAdapter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/FlexAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlexAdapterPosition
    implements LexerPosition {
        private final IElementType currentToken;
        private final int tokenStart;
        private final int tokenEnd;
        private final int state;
        private final int flexState;

        private FlexAdapterPosition(IElementType currentToken, int tokenStart, int tokenEnd, int state2, int flexState) {
            this.currentToken = currentToken;
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
            this.state = state2;
            this.flexState = flexState;
        }

        public int getOffset() {
            return this.tokenStart;
        }

        public int getState() {
            return this.state;
        }
    }
}

