/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Interner;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Identikit {
    private static final Interner<ByType> ourPlainInterner = Interner.createWeakInterner();
    private static final Interner<ByAnchor> ourAnchorInterner = Interner.createWeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @Nullable
    public abstract Language getFileLanguage();

    public abstract boolean isForPsiFile();

    @NotNull
    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(1);
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType((PsiElement)element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            Identikit.$$$reportNull$$$0(2);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensionList()) {
                PsiElement anchor = provider.getAnchor(element);
                if (anchor == null || !anchor.isPhysical() || provider.restoreElement(anchor) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor, fileLanguage), provider);
                return Pair.create((Object)((ByAnchor)ourAnchorInterner.intern((Object)anchorKit)), (Object)anchor);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class<? extends PsiElement> elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            Identikit.$$$reportNull$$$0(4);
        }
        if (fileLanguage == null) {
            Identikit.$$$reportNull$$$0(5);
        }
        ByType byType = (ByType)ourPlainInterner.intern((Object)new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            Identikit.$$$reportNull$$$0(6);
        }
        return byType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withAnchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypes";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ByType
    extends Identikit {
        private final String myElementClassName;
        private final short myElementTypeId;
        private final String myFileLanguageId;

        private ByType(@NotNull Class<? extends PsiElement> elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
            if (elementClass == null) {
                ByType.$$$reportNull$$$0(0);
            }
            if (fileLanguage == null) {
                ByType.$$$reportNull$$$0(1);
            }
            this.myElementClassName = elementClass.getName();
            this.myElementTypeId = (short)(elementType != null ? (int)elementType.getIndex() : -1);
            this.myFileLanguageId = fileLanguage.getID();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            Language fileLanguage;
            if (file == null) {
                ByType.$$$reportNull$$$0(2);
            }
            if ((fileLanguage = Language.findLanguageByID((String)this.myFileLanguageId)) == null) {
                return null;
            }
            Language actualLanguage = fileLanguage != Language.ANY ? fileLanguage : file.getViewProvider().getBaseLanguage();
            PsiFile actualLanguagePsi = file.getViewProvider().getPsi(actualLanguage);
            if (actualLanguagePsi == null) {
                return null;
            }
            return this.findInside((PsiElement)actualLanguagePsi, startOffset, endOffset);
        }

        public PsiElement findInside(@NotNull PsiElement element, int startOffset, int endOffset) {
            PsiElement anchor;
            if (element == null) {
                ByType.$$$reportNull$$$0(3);
            }
            if ((anchor = AbstractFileViewProvider.findElementAt(element, startOffset)) == null && startOffset == element.getTextLength()) {
                anchor = PsiTreeUtil.getDeepestLast((PsiElement)element);
            }
            if (anchor == null) {
                return null;
            }
            PsiElement result = this.findParent(startOffset, endOffset, anchor);
            if (endOffset == startOffset) {
                while ((result == null || result.getTextRange().getStartOffset() != startOffset) && anchor.getTextRange().getStartOffset() == endOffset && (anchor = PsiTreeUtil.prevLeaf((PsiElement)anchor, (boolean)false)) != null) {
                    result = this.findParent(startOffset, endOffset, anchor);
                }
            }
            return result;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, @NotNull PsiElement anchor) {
            TextRange range;
            if (anchor == null) {
                ByType.$$$reportNull$$$0(4);
            }
            if ((range = anchor.getTextRange()).getStartOffset() != startOffset) {
                return null;
            }
            while (range.getEndOffset() < endOffset) {
                if ((anchor = anchor.getParent()) == null || anchor instanceof PsiDirectory) {
                    return null;
                }
                range = anchor.getTextRange();
            }
            while (range.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor)) {
                    return anchor;
                }
                if ((anchor = anchor.getParent()) == null || anchor instanceof PsiDirectory) break;
                range = anchor.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByType type = (ByType)o;
            return this.myElementTypeId == type.myElementTypeId && Objects.equals(this.myElementClassName, type.myElementClassName) && Objects.equals(this.myFileLanguageId, type.myFileLanguageId);
        }

        public int hashCode() {
            return Objects.hash(this.myElementClassName, this.myElementTypeId, this.myFileLanguageId);
        }

        public String toString() {
            return "Identikit(class='" + this.myElementClassName + '\'' + ", elementType=" + (this.myElementTypeId == -1 ? "-1" : IElementType.find((short)this.myElementTypeId)) + ", fileLanguage='" + this.myFileLanguageId + '\'' + ')';
        }

        @Override
        @Nullable
        public Language getFileLanguage() {
            return Language.findLanguageByID((String)this.myFileLanguageId);
        }

        @Override
        public boolean isForPsiFile() {
            if (this.myElementTypeId < 0) {
                return false;
            }
            IElementType elementType = IElementType.find((short)this.myElementTypeId);
            return elementType instanceof IFileElementType;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                ByType.$$$reportNull$$$0(5);
            }
            IElementType type = PsiUtilCore.getElementType((PsiElement)element);
            return this.myElementClassName.equals(element.getClass().getName()) && type != null && this.myElementTypeId == type.getIndex();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLanguage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findInside";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(@NotNull ByType elementInfo, @NotNull ByType anchorInfo, @NotNull SmartPointerAnchorProvider anchorProvider) {
            if (elementInfo == null) {
                ByAnchor.$$$reportNull$$$0(0);
            }
            if (anchorInfo == null) {
                ByAnchor.$$$reportNull$$$0(1);
            }
            if (anchorProvider == null) {
                ByAnchor.$$$reportNull$$$0(2);
            }
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            PsiElement anchor;
            if (file == null) {
                ByAnchor.$$$reportNull$$$0(3);
            }
            PsiElement element = (anchor = this.myAnchorInfo.findPsiElement(file, startOffset, endOffset)) == null ? null : this.myAnchorProvider.restoreElement(anchor);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @Nullable
        public Language getFileLanguage() {
            return this.myAnchorInfo.getFileLanguage();
        }

        @Override
        public boolean isForPsiFile() {
            return this.myAnchorInfo.isForPsiFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPsiElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

