/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.ElementOrder;
import com.intellij.util.graph.EndpointPair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.MutableNetwork;
import com.intellij.util.graph.Network;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GraphAdapter {
    private GraphAdapter() {
    }

    public static <N> EndpointPair<N> wrapEndpointsPair(com.google.common.graph.EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered((Object)endpoints.source(), (Object)endpoints.target());
        }
        return EndpointPair.unordered((Object)endpoints.nodeU(), (Object)endpoints.nodeV());
    }

    public static <N> com.google.common.graph.EndpointPair<N> unwrapEndpointsPair(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return com.google.common.graph.EndpointPair.ordered((Object)endpoints.source(), (Object)endpoints.target());
        }
        return com.google.common.graph.EndpointPair.unordered((Object)endpoints.nodeU(), (Object)endpoints.nodeV());
    }

    public static <T> ElementOrder<T> wrapOrder(com.google.common.graph.ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return ElementOrder.stable();
            }
            case INSERTION: {
                return ElementOrder.insertion();
            }
            case SORTED: {
                return ElementOrder.sorted((Comparator)order.comparator());
            }
        }
        return ElementOrder.unordered();
    }

    public static <T> com.google.common.graph.ElementOrder<T> unwrapOrder(ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return com.google.common.graph.ElementOrder.stable();
            }
            case INSERTION: {
                return com.google.common.graph.ElementOrder.insertion();
            }
            case SORTED: {
                return com.google.common.graph.ElementOrder.sorted((Comparator)order.comparator());
            }
        }
        return com.google.common.graph.ElementOrder.unordered();
    }

    public static <N, E> MutableNetwork<N, E> wrapNetwork(com.google.common.graph.MutableNetwork<N, E> delegate) {
        return new MyMutableNetworkWrapper(delegate);
    }

    public static <N, E> @NotNull com.google.common.graph.MutableNetwork<N, E> unwrapNetwork(@NotNull Network<N, E> network) {
        if (network == null) {
            GraphAdapter.$$$reportNull$$$0(0);
        }
        com.google.common.graph.MutableNetwork mutableNetwork = ((MyMutableNetworkWrapper)network).getDelegate();
        if (mutableNetwork == null) {
            GraphAdapter.$$$reportNull$$$0(1);
        }
        return mutableNetwork;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "network";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/impl/GraphAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/impl/GraphAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapNetwork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapNetwork";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyMutableNetworkWrapper<N, E>
    implements MutableNetwork<N, E> {
        @NotNull
        private final com.google.common.graph.MutableNetwork<N, E> myDelegate;

        private MyMutableNetworkWrapper(@NotNull com.google.common.graph.MutableNetwork<N, E> delegate) {
            if (delegate == null) {
                MyMutableNetworkWrapper.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @NotNull
        com.google.common.graph.MutableNetwork<N, E> getDelegate() {
            com.google.common.graph.MutableNetwork<N, E> mutableNetwork = this.myDelegate;
            if (mutableNetwork == null) {
                MyMutableNetworkWrapper.$$$reportNull$$$0(1);
            }
            return mutableNetwork;
        }

        public boolean addNode(N n) {
            return this.myDelegate.addNode(n);
        }

        public boolean addEdge(N n, N n1, E e) {
            return this.myDelegate.addEdge(n, n1, e);
        }

        public boolean addEdge(EndpointPair<N> endpoints, E edge) {
            return this.myDelegate.addEdge(GraphAdapter.unwrapEndpointsPair(endpoints), edge);
        }

        public boolean removeNode(N n) {
            return this.myDelegate.removeNode(n);
        }

        public boolean removeEdge(E e) {
            return this.myDelegate.removeEdge(e);
        }

        public Set<N> nodes() {
            return this.myDelegate.nodes();
        }

        public Set<E> edges() {
            return this.myDelegate.edges();
        }

        public Graph<N> asGraph() {
            return new Graph<N>(){

                @NotNull
                public Collection<N> getNodes() {
                    Set set = this.nodes();
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                @NotNull
                public Iterator<N> getIn(N n) {
                    Iterator iterator = this.predecessors(n).iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator;
                }

                @NotNull
                public Iterator<N> getOut(N n) {
                    Iterator iterator = this.successors(n).iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return iterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNodes";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIn";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOut";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        public boolean isDirected() {
            return this.myDelegate.isDirected();
        }

        public boolean allowsParallelEdges() {
            return this.myDelegate.allowsParallelEdges();
        }

        public boolean allowsSelfLoops() {
            return this.myDelegate.allowsSelfLoops();
        }

        public ElementOrder<N> nodeOrder() {
            return GraphAdapter.wrapOrder(this.myDelegate.nodeOrder());
        }

        public ElementOrder<E> edgeOrder() {
            return GraphAdapter.wrapOrder(this.myDelegate.edgeOrder());
        }

        public Set<N> adjacentNodes(N n) {
            return this.myDelegate.adjacentNodes(n);
        }

        public Set<N> predecessors(N n) {
            return this.myDelegate.predecessors(n);
        }

        public Set<N> successors(N n) {
            return this.myDelegate.successors(n);
        }

        public Set<E> incidentEdges(N n) {
            return this.myDelegate.incidentEdges(n);
        }

        public Set<E> inEdges(N n) {
            return this.myDelegate.inEdges(n);
        }

        public Set<E> outEdges(N n) {
            return this.myDelegate.outEdges(n);
        }

        public int degree(N n) {
            return this.myDelegate.degree(n);
        }

        public int inDegree(N n) {
            return this.myDelegate.inDegree(n);
        }

        public int outDegree(N n) {
            return this.myDelegate.outDegree(n);
        }

        public EndpointPair<N> incidentNodes(E e) {
            return GraphAdapter.wrapEndpointsPair(this.myDelegate.incidentNodes(e));
        }

        public Set<E> adjacentEdges(E e) {
            return this.myDelegate.adjacentEdges(e);
        }

        public Set<E> edgesConnecting(N n, N n1) {
            return this.myDelegate.edgesConnecting(n, n1);
        }

        public Optional<E> edgeConnecting(N n, N n1) {
            return this.myDelegate.edgeConnecting(n, n1);
        }

        public E edgeConnectingOrNull(N n, N n1) {
            return (E)this.myDelegate.edgeConnectingOrNull(n, n1);
        }

        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.edgesConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.edgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        @Nullable
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            return (E)this.myDelegate.edgeConnectingOrNull(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        public boolean hasEdgeConnecting(N n, N n1) {
            return this.myDelegate.hasEdgeConnecting(n, n1);
        }

        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.hasEdgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        public boolean equals(@Nullable Object o) {
            return this.myDelegate.equals(o);
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

