/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanelKt;
import com.intellij.openapi.vcs.changes.ui.LegendChunkFormatters;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H&R\u0017\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/LegendChunk;", "", "<init>", "()V", "formatNumbers", "", "Lorg/jetbrains/annotations/Nls;", "fullLabel", "getFullLabel", "()Ljava/lang/String;", "compactLabel", "Lcom/intellij/openapi/util/NlsSafe;", "getCompactLabel", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getFileStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "Added", "Modified", "Deleted", "intellij.platform.vcs.impl"})
public abstract class LegendChunk {
    @NotNull
    public abstract String formatNumbers();

    @NotNull
    public abstract String getFullLabel();

    @NotNull
    public abstract String getCompactLabel();

    @NotNull
    public abstract FileStatus getFileStatus();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/LegendChunk$Added;", "Lcom/intellij/openapi/vcs/changes/ui/LegendChunk;", "calculator", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;", "compactLabel", "", "Lcom/intellij/openapi/util/NlsSafe;", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;Ljava/lang/String;Lcom/intellij/openapi/vcs/FileStatus;)V", "getCompactLabel", "()Ljava/lang/String;", "getFileStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "fullLabel", "Lorg/jetbrains/annotations/Nls;", "getFullLabel", "formatNumbers", "intellij.platform.vcs.impl"})
    public static final class Added
    extends LegendChunk {
        @NotNull
        private final CommitLegendPanel.InfoCalculator calculator;
        @NotNull
        private final String compactLabel;
        @NotNull
        private final FileStatus fileStatus;

        public Added(@NotNull CommitLegendPanel.InfoCalculator calculator, @NotNull String compactLabel, @NotNull FileStatus fileStatus) {
            Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
            Intrinsics.checkNotNullParameter((Object)compactLabel, (String)"compactLabel");
            Intrinsics.checkNotNullParameter((Object)fileStatus, (String)"fileStatus");
            this.calculator = calculator;
            this.compactLabel = compactLabel;
            this.fileStatus = fileStatus;
        }

        public /* synthetic */ Added(CommitLegendPanel.InfoCalculator infoCalculator, String string, FileStatus fileStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "+";
            }
            if ((n & 4) != 0) {
                FileStatus fileStatus2 = FileStatus.ADDED;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"ADDED");
                fileStatus = fileStatus2;
            }
            this(infoCalculator, string, fileStatus);
        }

        @Override
        @NotNull
        public String getCompactLabel() {
            return this.compactLabel;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        @Override
        @NotNull
        public String getFullLabel() {
            String string = VcsBundle.message((String)"commit.legend.new", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String formatNumbers() {
            int n = this.calculator.getIncludedNew();
            int unversioned = this.calculator.getIncludedUnversioned();
            return n > 0 && unversioned > 0 ? CommitLegendPanelKt.access$formatInt(n) + "+" + CommitLegendPanelKt.access$formatInt(unversioned) : (n > 0 ? CommitLegendPanelKt.access$formatInt(n) : (unversioned > 0 ? CommitLegendPanelKt.access$formatInt(unversioned) : ""));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/LegendChunk$Deleted;", "Lcom/intellij/openapi/vcs/changes/ui/LegendChunk;", "calculator", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;", "compactLabel", "", "Lcom/intellij/openapi/util/NlsSafe;", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;Ljava/lang/String;Lcom/intellij/openapi/vcs/FileStatus;)V", "getCompactLabel", "()Ljava/lang/String;", "getFileStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "fullLabel", "Lorg/jetbrains/annotations/Nls;", "getFullLabel", "formatNumbers", "intellij.platform.vcs.impl"})
    public static final class Deleted
    extends LegendChunk {
        @NotNull
        private final CommitLegendPanel.InfoCalculator calculator;
        @NotNull
        private final String compactLabel;
        @NotNull
        private final FileStatus fileStatus;

        public Deleted(@NotNull CommitLegendPanel.InfoCalculator calculator, @NotNull String compactLabel, @NotNull FileStatus fileStatus) {
            Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
            Intrinsics.checkNotNullParameter((Object)compactLabel, (String)"compactLabel");
            Intrinsics.checkNotNullParameter((Object)fileStatus, (String)"fileStatus");
            this.calculator = calculator;
            this.compactLabel = compactLabel;
            this.fileStatus = fileStatus;
        }

        public /* synthetic */ Deleted(CommitLegendPanel.InfoCalculator infoCalculator, String string, FileStatus fileStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "-";
            }
            if ((n & 4) != 0) {
                FileStatus fileStatus2 = FileStatus.DELETED;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"DELETED");
                fileStatus = fileStatus2;
            }
            this(infoCalculator, string, fileStatus);
        }

        @Override
        @NotNull
        public String getCompactLabel() {
            return this.compactLabel;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        @Override
        @NotNull
        public String getFullLabel() {
            String string = VcsBundle.message((String)"commit.legend.deleted", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String formatNumbers() {
            return LegendChunkFormatters.nonZeroOrEmpty(this.calculator.getIncludedDeleted());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/LegendChunk$Modified;", "Lcom/intellij/openapi/vcs/changes/ui/LegendChunk;", "calculator", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;", "compactLabel", "", "Lcom/intellij/openapi/util/NlsSafe;", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;Ljava/lang/String;Lcom/intellij/openapi/vcs/FileStatus;)V", "getCompactLabel", "()Ljava/lang/String;", "getFileStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "fullLabel", "Lorg/jetbrains/annotations/Nls;", "getFullLabel", "formatNumbers", "intellij.platform.vcs.impl"})
    public static final class Modified
    extends LegendChunk {
        @NotNull
        private final CommitLegendPanel.InfoCalculator calculator;
        @NotNull
        private final String compactLabel;
        @NotNull
        private final FileStatus fileStatus;

        public Modified(@NotNull CommitLegendPanel.InfoCalculator calculator, @NotNull String compactLabel, @NotNull FileStatus fileStatus) {
            Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
            Intrinsics.checkNotNullParameter((Object)compactLabel, (String)"compactLabel");
            Intrinsics.checkNotNullParameter((Object)fileStatus, (String)"fileStatus");
            this.calculator = calculator;
            this.compactLabel = compactLabel;
            this.fileStatus = fileStatus;
        }

        public /* synthetic */ Modified(CommitLegendPanel.InfoCalculator infoCalculator, String string, FileStatus fileStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "*";
            }
            if ((n & 4) != 0) {
                FileStatus fileStatus2 = FileStatus.MODIFIED;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"MODIFIED");
                fileStatus = fileStatus2;
            }
            this(infoCalculator, string, fileStatus);
        }

        @Override
        @NotNull
        public String getCompactLabel() {
            return this.compactLabel;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        @Override
        @NotNull
        public String getFullLabel() {
            String string = VcsBundle.message((String)"commit.legend.modified", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String formatNumbers() {
            return LegendChunkFormatters.nonZeroOrEmpty(this.calculator.getIncludedModified());
        }
    }
}

