/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.configurable.ShelfStorageConfigurationDialog;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/configurable/ShelfProjectConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createPresentableShelfLocation", "", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ShelfProjectConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ShelfProjectConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "project.propVCSSupport.Shelf", "Shelf.Project.Settings");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DialogPanel createPanel() {
        VcsConfiguration vcsConfig = VcsConfiguration.getInstance((Project)this.project);
        ShelveChangesManager shelveManager = ShelveChangesManager.getInstance(this.project);
        JLabel shelfLocation = ComponentPanelBuilder.Companion.createCommentComponent(this.createPresentableShelfLocation(), true, -1, false);
        return BuilderKt.panel(arg_0 -> ShelfProjectConfigurable.createPanel$lambda$0(shelveManager, vcsConfig, this, shelfLocation, arg_0));
    }

    @Nls
    private final String createPresentableShelfLocation() {
        String string;
        String string2 = this.project.isDefault() ? VcsBundle.message((String)"settings.default.location", (Object[])new Object[0]) : VcsBundle.message((String)"settings.current.location", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string2);
        String prefix = string2;
        VcsConfiguration vcsConfig = VcsConfiguration.getInstance((Project)this.project);
        if (vcsConfig.USE_CUSTOM_SHELF_PATH) {
            String string3 = vcsConfig.CUSTOM_SHELF_PATH;
            if (string3 == null) {
                string3 = "";
            }
            string = FileUtil.toSystemDependentName((String)string3);
        } else {
            string = Companion.getDefaultShelfPresentationPath(this.project);
        }
        String string4 = string;
        Intrinsics.checkNotNull((Object)string4);
        String shelfPath = string4;
        return prefix + StringUtil.escapeXmlEntities((String)shelfPath);
    }

    private static final Unit createPanel$lambda$0$0$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMnemonic(82);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMnemonic('b');
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$0(ShelfProjectConfigurable this$0, JLabel $shelfLocation, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (new ShelfStorageConfigurationDialog(this$0.project).showAndGet()) {
            $shelfLocation.setText(this$0.createPresentableShelfLocation());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(ShelveChangesManager $shelveManager, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"shelve.remove.successfully.applied.files.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$shelveManager);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$shelveManager){

            public final Boolean invoke() {
                return ((ShelveChangesManager)this.receiver).isRemoveFilesFromShelf();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$shelveManager){

            public final void invoke(boolean p0) {
                ((ShelveChangesManager)this.receiver).setRemoveFilesFromShelf(p0);
            }
        })).applyToComponent(ShelfProjectConfigurable::createPanel$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(VcsConfiguration $vcsConfig, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"vcs.shelf.store.base.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$vcsConfig);
        Object[] objectArray = new Object[]{500L};
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($vcsConfig){

            public Object get() {
                return ((VcsConfiguration)this.receiver).INCLUDE_TEXT_INTO_SHELF;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).INCLUDE_TEXT_INTO_SHELF = (Boolean)value;
            }
        })), (String)VcsBundle.message((String)"settings.shelf.content.larger", (Object[])objectArray), (int)0, null, (int)6, null).applyToComponent(ShelfProjectConfigurable::createPanel$lambda$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(ShelfProjectConfigurable this$0, JLabel $shelfLocation, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"settings.change.shelves.location", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> ShelfProjectConfigurable.createPanel$lambda$0$2$0(this$0, $shelfLocation, arg_0)).enabled(!this$0.project.isDefault());
        $this$row.cell((JComponent)$shelfLocation);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(ShelveChangesManager $shelveManager, VcsConfiguration $vcsConfig, ShelfProjectConfigurable this$0, JLabel $shelfLocation, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ShelfProjectConfigurable.createPanel$lambda$0$0($shelveManager, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ShelfProjectConfigurable.createPanel$lambda$0$1($vcsConfig, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ShelfProjectConfigurable.createPanel$lambda$0$2(this$0, $shelfLocation, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Nls
    @NotNull
    public static final String getDefaultShelfPresentationPath(@NotNull Project project) {
        return Companion.getDefaultShelfPresentationPath(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/configurable/ShelfProjectConfigurable$Companion;", "", "<init>", "()V", "getDefaultShelfPresentationPath", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nls
        @NotNull
        public final String getDefaultShelfPresentationPath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return project.isDefault() ? "<Project>/shelf" : ((Object)ShelveChangesManager.getDefaultShelfPath(project)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

