/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl;", "Lcom/intellij/openapi/vcs/impl/ActiveChangeListTracker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "forcedChangeListId", "", "getActiveChangeListId", "isActiveChangeList", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "runUnderChangeList", "", "changelistId", "task", "Ljava/lang/Runnable;", "doRunUnderChangeList", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nActiveChangeListTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActiveChangeListTracker.kt\ncom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n*S KotlinDebug\n*F\n+ 1 ActiveChangeListTracker.kt\ncom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl\n*L\n32#1:84\n*E\n"})
public class ActiveChangeListTrackerImpl
implements ActiveChangeListTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private String forcedChangeListId;
    @NotNull
    private static final Logger LOG;

    public ActiveChangeListTrackerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String getActiveChangeListId() {
        return this.forcedChangeListId;
    }

    @Override
    public boolean isActiveChangeList(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        String activeListId = this.getActiveChangeListId();
        if (activeListId != null) {
            return Intrinsics.areEqual((Object)changeList.getId(), (Object)activeListId);
        }
        return changeList.isDefault();
    }

    @Override
    public void runUnderChangeList(@NotNull String changelistId, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!this.doRunUnderChangeList(changelistId, task)) {
            task.run();
        }
    }

    private final boolean doRunUnderChangeList(String changelistId, Runnable task) {
        LineStatusTrackerManager lstManager = LineStatusTrackerManager.Companion.getInstanceImpl(this.project);
        if (!lstManager.arePartialChangelistsEnabled()) {
            return false;
        }
        if (this.forcedChangeListId != null) {
            LOG.warn("Conflicting forced changelist request", new Throwable());
            return false;
        }
        Ref.BooleanRef success = new Ref.BooleanRef();
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.project);
        changeListManager.executeUnderDataLock(() -> ActiveChangeListTrackerImpl.doRunUnderChangeList$lambda$0(changeListManager, changelistId, this, success, task));
        return success.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doRunUnderChangeList$lambda$0(ChangeListManagerImpl $changeListManager, String $changelistId, ActiveChangeListTrackerImpl this$0, Ref.BooleanRef $success, Runnable $task) {
        if ($changeListManager.getChangeList($changelistId) != null) {
            this$0.forcedChangeListId = $changelistId;
            try {
                LOG.debug("running operation under changelist: " + $changelistId);
                $success.element = true;
                $task.run();
            }
            finally {
                this$0.forcedChangeListId = null;
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ActiveChangeListTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

