/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.openapi.vcs.changes.ui.PartiallyExcludedFilesStateHolder;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0016\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/commit/PartialCommitInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changeLists", "getChangeLists", "()Ljava/util/Collection;", "setChangeLists", "(Ljava/util/Collection;)V", "stateHolder", "Lcom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder;", "getInclusion", "", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "addInclusion", "", "items", "removeInclusion", "setInclusion", "retainInclusion", "clearInclusion", "dispose", "StateHolder", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class PartialCommitInclusionModel
extends BaseInclusionModel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private Collection<? extends LocalChangeList> changeLists;
    @NotNull
    private final StateHolder stateHolder;

    public PartialCommitInclusionModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.changeLists = CollectionsKt.emptyList();
        this.stateHolder = new StateHolder();
        Disposer.register((Disposable)this, (Disposable)this.stateHolder);
    }

    @NotNull
    public final Collection<LocalChangeList> getChangeLists() {
        return this.changeLists;
    }

    public final void setChangeLists(@NotNull Collection<? extends LocalChangeList> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.changeLists = value;
        this.stateHolder.updateExclusionStates();
    }

    @NotNull
    public Set<Object> getInclusion() {
        return this.stateHolder.getIncludedSet();
    }

    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return PartialChangesUtil.convertExclusionState(this.stateHolder.getExclusionState(item));
    }

    public boolean isInclusionEmpty() {
        return this.getInclusion().isEmpty();
    }

    public void addInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.stateHolder.includeElements(items);
    }

    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.stateHolder.excludeElements(items);
    }

    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.stateHolder.setIncludedElements(items);
    }

    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.stateHolder.retainElements(items);
    }

    public void clearInclusion() {
        if (!((Collection)this.getInclusion()).isEmpty()) {
            this.setInclusion(SetsKt.emptySet());
        }
    }

    public void dispose() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder;", "Lcom/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder;", "", "<init>", "(Lcom/intellij/vcs/commit/PartialCommitInclusionModel;)V", "trackableElements", "Lkotlin/sequences/Sequence;", "getTrackableElements", "()Lkotlin/sequences/Sequence;", "getChangeListId", "", "Lorg/jetbrains/annotations/NonNls;", "element", "findElementFor", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "changeListId", "findTrackerFor", "fireInclusionChanged", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nPartialCommitInclusionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialCommitInclusionModel.kt\ncom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
    private final class StateHolder
    extends PartiallyExcludedFilesStateHolder<Object> {
        public StateHolder() {
            super(PartialCommitInclusionModel.this.project, ChangeListChange.HASHING_STRATEGY);
        }

        @Override
        @NotNull
        protected Sequence<Object> getTrackableElements() {
            return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)PartialCommitInclusionModel.this.getChangeLists()), StateHolder::_get_trackableElements_$lambda$0);
        }

        @Override
        @Nullable
        protected String getChangeListId(@NotNull Object element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ChangeListChange changeListChange = element instanceof ChangeListChange ? (ChangeListChange)element : null;
            return changeListChange != null ? changeListChange.getChangeListId() : null;
        }

        @Override
        @Nullable
        protected Object findElementFor(@NotNull PartialLocalLineStatusTracker tracker, @NotNull String changeListId) {
            Change change;
            Object object;
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                Intrinsics.checkNotNullParameter((Object)changeListId, (String)"changeListId");
                Iterable iterable = PartialCommitInclusionModel.this.getChangeLists();
                for (Object object2 : iterable) {
                    LocalChangeList it = (LocalChangeList)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)changeListId)) continue;
                    v0 = object2;
                    break block4;
                }
                v0 = null;
            }
            if ((object = (LocalChangeList)v0) != null && (object = object.getChanges()) != null) {
                Object v3;
                block5: {
                    Object object2;
                    Iterable iterable = (Iterable)object;
                    object2 = iterable.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        Change it = (Change)e;
                        boolean bl = false;
                        VirtualFile virtualFile = tracker.getVirtualFile();
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)virtualFile, (Object)PartialChangesUtil.getVirtualFile(it))) continue;
                        v3 = e;
                        break block5;
                    }
                    v3 = null;
                }
                change = v3;
            } else {
                change = null;
            }
            return change;
        }

        @Override
        @Nullable
        protected PartialLocalLineStatusTracker findTrackerFor(@NotNull Object element) {
            PartialLocalLineStatusTracker partialLocalLineStatusTracker;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Change change = element instanceof Change ? (Change)element : null;
            if (change != null) {
                Change change2 = change;
                PartialCommitInclusionModel partialCommitInclusionModel = PartialCommitInclusionModel.this;
                Change it = change2;
                boolean bl = false;
                partialLocalLineStatusTracker = PartialChangesUtil.getPartialTracker(partialCommitInclusionModel.project, it);
            } else {
                partialLocalLineStatusTracker = null;
            }
            return partialLocalLineStatusTracker;
        }

        @Override
        protected void fireInclusionChanged() {
            PartialCommitInclusionModel.this.fireInclusionChanged();
        }

        private static final Sequence _get_trackableElements_$lambda$0(LocalChangeList it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Collection collection = it.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
            return CollectionsKt.asSequence((Iterable)collection);
        }
    }
}

