/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.shelf.diff;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.shelf.diff.ShelfDiffChangesProvider;
import com.intellij.vcs.shelf.diff.ShelvedPreviewProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0014J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/shelf/diff/BackendShelveEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "changesProvider", "Lcom/intellij/vcs/shelf/diff/ShelfDiffChangesProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/vcs/shelf/diff/ShelfDiffChangesProvider;)V", "hasContent", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "getEditorTabName", "", "processor", "updateDiffAction", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class BackendShelveEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ShelfDiffChangesProvider changesProvider;

    public BackendShelveEditorDiffPreview(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull ShelfDiffChangesProvider changesProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)changesProvider, (String)"changesProvider");
        super(project);
        this.cs = cs;
        this.changesProvider = changesProvider;
    }

    public boolean hasContent() {
        return this.changesProvider.getAllChanges().isNotEmpty();
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        return (DiffEditorViewer)new ShelvedPreviewProcessor(this.getProject(), this.cs, true, this.changesProvider);
    }

    @NotNull
    protected ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        JBIterable<ChangeViewDiffRequestProcessor.Wrapper> producers = selectedOnly ? this.changesProvider.getSelectedChanges() : this.changesProvider.getAllChanges();
        ListSelection listSelection = ListSelection.create((List)producers.toList(), null).withExplicitSelection(selectedOnly).map(arg_0 -> BackendShelveEditorDiffPreview.collectDiffProducers$lambda$1(arg_0 -> BackendShelveEditorDiffPreview.collectDiffProducers$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
        return listSelection;
    }

    @NotNull
    protected String getEditorTabName(@Nullable DiffEditorViewer processor2) {
        ChangeViewDiffRequestProcessor.Wrapper wrapper2;
        ShelvedPreviewProcessor shelvedPreviewProcessor = processor2 instanceof ShelvedPreviewProcessor ? (ShelvedPreviewProcessor)processor2 : null;
        ChangeViewDiffRequestProcessor.Wrapper wrapper3 = wrapper2 = shelvedPreviewProcessor != null ? shelvedPreviewProcessor.getCurrentChange() : null;
        if (wrapper2 == null) {
            String string = VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object[] objectArray = new Object[]{wrapper2.getPresentableName()};
        String string = VcsBundle.message((String)"shelve.editor.diff.preview.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DiffShelvedChangesActionProvider.updateAvailability(event);
    }

    private static final DiffRequestProducer collectDiffProducers$lambda$0(BackendShelveEditorDiffPreview this$0, ChangeViewDiffRequestProcessor.Wrapper it) {
        return it.createProducer(this$0.getProject());
    }

    private static final DiffRequestProducer collectDiffProducers$lambda$1(Function1 $tmp0, Object p0) {
        return (DiffRequestProducer)$tmp0.invoke(p0);
    }
}

