/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.UISettings;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ToolWindowAnchor {
    @NotNull
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top", "action.text.anchor.top", "action.text.anchor.top.capitalized");
    @NotNull
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left", "action.text.anchor.left", "action.text.anchor.left.capitalized");
    @NotNull
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom", "action.text.anchor.bottom", "action.text.anchor.bottom.capitalized");
    @NotNull
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right", "action.text.anchor.right", "action.text.anchor.right.capitalized");
    @NotNull
    public static final List<ToolWindowAnchor> VALUES = List.of(TOP, LEFT, BOTTOM, RIGHT);
    @NotNull
    private final String myText;
    @NotNull
    private final String bundleKey;
    @NotNull
    private final String capitalizedBundleKey;

    private ToolWindowAnchor(@NotNull String text, @NotNull String bundleKey, @NotNull String capitalizedBundleKey) {
        if (text == null) {
            ToolWindowAnchor.$$$reportNull$$$0(0);
        }
        if (bundleKey == null) {
            ToolWindowAnchor.$$$reportNull$$$0(1);
        }
        if (capitalizedBundleKey == null) {
            ToolWindowAnchor.$$$reportNull$$$0(2);
        }
        this.bundleKey = bundleKey;
        this.capitalizedBundleKey = capitalizedBundleKey;
        this.myText = text;
    }

    @NotNull
    public String toString() {
        String string = this.myText;
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        String string = IdeCoreBundle.message(this.bundleKey, new Object[0]);
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getCapitalizedDisplayName() {
        String string = IdeCoreBundle.message(this.capitalizedBundleKey, new Object[0]);
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    @NotNull
    public static ToolWindowAnchor get(int swingOrientationConstant) {
        ToolWindowAnchor toolWindowAnchor = switch (swingOrientationConstant) {
            case 1 -> TOP;
            case 3 -> BOTTOM;
            case 2 -> LEFT;
            case 4 -> RIGHT;
            default -> throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
        };
        if (toolWindowAnchor == null) {
            ToolWindowAnchor.$$$reportNull$$$0(6);
        }
        return toolWindowAnchor;
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().getLeftHorizontalSplit() || this == RIGHT && !UISettings.getInstance().getRightHorizontalSplit();
    }

    @NotNull
    public static ToolWindowAnchor fromText(@NotNull String anchor) {
        if (anchor == null) {
            ToolWindowAnchor.$$$reportNull$$$0(7);
        }
        ToolWindowAnchor toolWindowAnchor = switch (anchor) {
            case "top" -> TOP;
            case "left" -> LEFT;
            case "bottom" -> BOTTOM;
            case "right" -> RIGHT;
            default -> throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
        };
        if (toolWindowAnchor == null) {
            ToolWindowAnchor.$$$reportNull$$$0(8);
        }
        return toolWindowAnchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalizedBundleKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalizedDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

