/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features;

import com.intellij.ide.actions.searcheverywhere.EssentialContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereEssentialContributorMarker;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.local.ContributorsGlobalSummaryManager;
import com.intellij.internal.statistic.local.EventGlobalStatistics;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereEssentialContributorMlMarker;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.core.features.ContributorsGlobalStatisticsFields;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.ContributorStatistics;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.ContributorsLocalStatisticsFields;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereContributorStatisticianKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fJ,\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J$\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u001f2\u0006\u0010*\u001a\u00020+2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$J\u001e\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereContributorFeaturesProvider;", "", "<init>", "()V", "CONTRIBUTOR_INFO_ID", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getCONTRIBUTOR_INFO_ID", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "CONTRIBUTOR_PRIORITY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getCONTRIBUTOR_PRIORITY", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "CONTRIBUTOR_WEIGHT", "getCONTRIBUTOR_WEIGHT", "CONTRIBUTOR_IS_MOST_POPULAR", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getCONTRIBUTOR_IS_MOST_POPULAR", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "CONTRIBUTOR_POPULARITY_INDEX", "getCONTRIBUTOR_POPULARITY_INDEX", "IS_ESSENTIAL_CONTRIBUTOR", "getIS_ESSENTIAL_CONTRIBUTOR", "ESSENTIAL_CONTRIBUTOR_PREDICTION", "Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "getESSENTIAL_CONTRIBUTOR_PREDICTION", "()Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "LOCAL_STATISTICS", "Lcom/intellij/searchEverywhereMl/ranking/core/features/statistician/ContributorsLocalStatisticsFields;", "GLOBAL_STATISTICS", "Lcom/intellij/searchEverywhereMl/ranking/core/features/ContributorsGlobalStatisticsFields;", "getFeaturesDeclarations", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getFeatures", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "contributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "mixedListInfo", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "sessionStartTime", "", "getEssentialContributorFeatures", "searchState", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlSearchState;", "getStatisticianFeatures", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereContributorFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereContributorFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereContributorFeaturesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n363#2,7:108\n1#3:115\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereContributorFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereContributorFeaturesProvider\n*L\n99#1:108,7\n*E\n"})
public final class SearchEverywhereContributorFeaturesProvider {
    @NotNull
    public static final SearchEverywhereContributorFeaturesProvider INSTANCE = new SearchEverywhereContributorFeaturesProvider();
    @NotNull
    private static final StringEventField CONTRIBUTOR_INFO_ID;
    @NotNull
    private static final IntEventField CONTRIBUTOR_PRIORITY;
    @NotNull
    private static final IntEventField CONTRIBUTOR_WEIGHT;
    @NotNull
    private static final BooleanEventField CONTRIBUTOR_IS_MOST_POPULAR;
    @NotNull
    private static final IntEventField CONTRIBUTOR_POPULARITY_INDEX;
    @NotNull
    private static final BooleanEventField IS_ESSENTIAL_CONTRIBUTOR;
    @NotNull
    private static final FloatEventField ESSENTIAL_CONTRIBUTOR_PREDICTION;
    @NotNull
    private static final ContributorsLocalStatisticsFields LOCAL_STATISTICS;
    @NotNull
    private static final ContributorsGlobalStatisticsFields GLOBAL_STATISTICS;

    private SearchEverywhereContributorFeaturesProvider() {
    }

    @NotNull
    public final StringEventField getCONTRIBUTOR_INFO_ID() {
        return CONTRIBUTOR_INFO_ID;
    }

    @NotNull
    public final IntEventField getCONTRIBUTOR_PRIORITY() {
        return CONTRIBUTOR_PRIORITY;
    }

    @NotNull
    public final IntEventField getCONTRIBUTOR_WEIGHT() {
        return CONTRIBUTOR_WEIGHT;
    }

    @NotNull
    public final BooleanEventField getCONTRIBUTOR_IS_MOST_POPULAR() {
        return CONTRIBUTOR_IS_MOST_POPULAR;
    }

    @NotNull
    public final IntEventField getCONTRIBUTOR_POPULARITY_INDEX() {
        return CONTRIBUTOR_POPULARITY_INDEX;
    }

    @NotNull
    public final BooleanEventField getIS_ESSENTIAL_CONTRIBUTOR() {
        return IS_ESSENTIAL_CONTRIBUTOR;
    }

    @NotNull
    public final FloatEventField getESSENTIAL_CONTRIBUTOR_PREDICTION() {
        return ESSENTIAL_CONTRIBUTOR_PREDICTION;
    }

    @NotNull
    public final List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new PrimitiveEventField[]{CONTRIBUTOR_INFO_ID, CONTRIBUTOR_PRIORITY, CONTRIBUTOR_WEIGHT, CONTRIBUTOR_IS_MOST_POPULAR, CONTRIBUTOR_POPULARITY_INDEX, IS_ESSENTIAL_CONTRIBUTOR, ESSENTIAL_CONTRIBUTOR_PREDICTION};
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)LOCAL_STATISTICS.getFieldsDeclaration()), (Iterable)GLOBAL_STATISTICS.getFieldsDeclaration());
    }

    @NotNull
    public final List<EventPair<?>> getFeatures(@NotNull SearchEverywhereContributor<?> contributor, @NotNull SearchEverywhereMixedListInfo mixedListInfo, long sessionStartTime) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        Intrinsics.checkNotNullParameter((Object)mixedListInfo, (String)"mixedListInfo");
        String string = contributor.getSearchProviderId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchProviderId(...)");
        String contributor_id = string;
        Object[] objectArray = new EventPair[]{CONTRIBUTOR_INFO_ID.with((Object)contributor_id), CONTRIBUTOR_WEIGHT.with((Object)contributor.getSortWeight())};
        ArrayList info = CollectionsKt.arrayListOf((Object[])objectArray);
        Integer n = (Integer)mixedListInfo.getContributorPriorities().get(contributor.getSearchProviderId());
        if (n != null) {
            int priority = ((Number)n).intValue();
            boolean bl = false;
            info.add(CONTRIBUTOR_PRIORITY.with((Object)priority));
        }
        info.addAll((Collection)LOCAL_STATISTICS.getLocalStatistics(contributor_id, sessionStartTime));
        ContributorsGlobalSummaryManager globalSummary = ContributorsGlobalSummaryManager.Companion.getInstance();
        EventGlobalStatistics contributorsStats = globalSummary.getStatistics(contributor_id);
        long maxEventCount = globalSummary.getEventCountRange().getMaxEventCount();
        info.addAll((Collection)GLOBAL_STATISTICS.getEventGlobalStatistics(contributorsStats, maxEventCount));
        return CollectionsKt.plus((Collection)info, (Iterable)this.getStatisticianFeatures(contributor));
    }

    @NotNull
    public final List<EventPair<?>> getEssentialContributorFeatures(@NotNull SearchEverywhereMlSearchState searchState, @NotNull SearchEverywhereContributor<?> contributor) {
        Intrinsics.checkNotNullParameter((Object)searchState, (String)"searchState");
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        SearchEverywhereEssentialContributorMarker marker = SearchEverywhereEssentialContributorMarker.Companion.getInstanceOrNull();
        if (marker == null) {
            return CollectionsKt.listOf((Object)IS_ESSENTIAL_CONTRIBUTOR.with((Object)EssentialContributor.checkEssential(contributor)));
        }
        SearchEverywhereEssentialContributorMlMarker cfr_ignored_0 = (SearchEverywhereEssentialContributorMlMarker)marker;
        float cachedPrediction = ((SearchEverywhereEssentialContributorMlMarker)marker).getContributorEssentialPrediction$intellij_searchEverywhereMl_ranking_core(contributor, searchState);
        Object[] objectArray = new EventPair[]{IS_ESSENTIAL_CONTRIBUTOR.with((Object)((double)cachedPrediction >= 0.4 ? 1 : 0)), ESSENTIAL_CONTRIBUTOR_PREDICTION.with((Object)Float.valueOf(cachedPrediction))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<EventPair<?>> getStatisticianFeatures(SearchEverywhereContributor<?> contributor) {
        int n;
        boolean isMostPopular;
        block4: {
            String string = contributor.getSearchProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchProviderId(...)");
            String contributorId = string;
            ContributorStatistics statistics = SearchEverywhereContributorStatisticianKt.getContributorStatistics();
            Object object = (Pair)CollectionsKt.firstOrNull(statistics.getContributorUsage());
            if (object == null || (object = (String)object.getFirst()) == null) {
                return CollectionsKt.emptyList();
            }
            isMostPopular = ((String)object).equals(contributorId);
            List<Pair<String, Integer>> $this$indexOfFirst$iv = statistics.getContributorUsage();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Pair<String, Integer>> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Pair<String, Integer> item$iv;
                Pair<String, Integer> it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getFirst(), (Object)contributorId)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 == null) {
            return CollectionsKt.emptyList();
        }
        int popularityIndex = n3;
        Object[] objectArray = new EventPair[]{CONTRIBUTOR_IS_MOST_POPULAR.with((Object)isMostPopular), CONTRIBUTOR_POPULARITY_INDEX.with((Object)popularityIndex)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        List list = SearchEverywhereUsageTriggerCollector.ALLOWED_CONTRIBUTOR_ID_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALLOWED_CONTRIBUTOR_ID_LIST");
        CONTRIBUTOR_INFO_ID = EventFields.String((String)"contributor_id", (List)list);
        CONTRIBUTOR_PRIORITY = EventFields.Int((String)"contributor_priority");
        CONTRIBUTOR_WEIGHT = EventFields.Int((String)"contributor_weight");
        CONTRIBUTOR_IS_MOST_POPULAR = EventFields.Boolean((String)"contributor_is_most_popular");
        CONTRIBUTOR_POPULARITY_INDEX = EventFields.Int((String)"contributor_popularity_index");
        IS_ESSENTIAL_CONTRIBUTOR = EventFields.Boolean((String)"contributor_is_essential");
        ESSENTIAL_CONTRIBUTOR_PREDICTION = EventFields.Float$default((String)"contributor_is_essential_prediction", null, (int)2, null);
        LOCAL_STATISTICS = new ContributorsLocalStatisticsFields();
        GLOBAL_STATISTICS = new ContributorsGlobalStatisticsFields();
    }
}

