/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.NamedColor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.ComparableColor;
import com.intellij.util.ui.PresentableColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b'\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u0019B\u0016\b\u0000\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0011\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/ColorMixture;", "Lcom/intellij/util/ui/PresentableColor;", "Lcom/intellij/util/ui/ComparableColor;", "Ljava/util/function/Supplier;", "Ljava/awt/Color;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "args", "", "", "getArgs", "()Ljava/util/List;", "getPresentableName", "colorEquals", "", "other", "colorHashCode", "", "createColor", "supportDynamicColors", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nColorMixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorMixture.kt\ncom/intellij/ui/ColorMixture\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1807#2,3:132\n*S KotlinDebug\n*F\n+ 1 ColorMixture.kt\ncom/intellij/ui/ColorMixture\n*L\n65#1:132,3\n*E\n"})
public abstract class ColorMixture
implements PresentableColor,
ComparableColor,
Supplier<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @ApiStatus.Internal
    @NotNull
    public static final String ENABLE_RUNTIME_COLOR_MIXTURE_WRAPPER_OPTION = "ide.color.mixture.mark.colors";

    public ColorMixture(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract List<Object> getArgs();

    @NotNull
    public String getPresentableName() {
        return this.name + ": (" + CollectionsKt.joinToString$default((Iterable)this.getArgs(), null, null, null, (int)0, null, ColorMixture::getPresentableName$lambda$0, (int)31, null) + ")";
    }

    public boolean colorEquals(@NotNull ComparableColor other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ColorMixture cfr_ignored_0 = (ColorMixture)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((ColorMixture)other).name)) {
            return false;
        }
        if (this.getArgs().size() != ((ColorMixture)other).getArgs().size()) {
            return false;
        }
        int n = ((Collection)this.getArgs()).size();
        for (int i = 0; i < n; ++i) {
            boolean argumentsEqual;
            Object argument1 = this.getArgs().get(i);
            Object argument2 = ((ColorMixture)other).getArgs().get(i);
            boolean bl = argument1 instanceof Color && argument2 instanceof Color ? UIUtil.equalColors((Color)argument1, (Color)argument2) : (argumentsEqual = argument1 instanceof Color || argument2 instanceof Color ? false : Objects.equals(argument1, argument2));
            if (argumentsEqual) continue;
            return false;
        }
        return true;
    }

    public int colorHashCode() {
        int result = this.name.hashCode();
        for (Object argument : this.getArgs()) {
            int argumentHash = argument instanceof Color ? UIUtil.colorHashCode((Color)argument) : argument.hashCode();
            result = 31 * result + argumentHash;
        }
        return result;
    }

    @NotNull
    public final Color createColor(boolean supportDynamicColors) {
        if (supportDynamicColors) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = this.getArgs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(it instanceof JBColor)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                JBColor jBColor = JBColor.lazy(this);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
                return jBColor;
            }
        }
        if (SystemProperties.getBooleanProperty((String)ENABLE_RUNTIME_COLOR_MIXTURE_WRAPPER_OPTION, (boolean)false)) {
            String string = this.getPresentableName();
            Object object = this.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return new NamedColor(string, (Color)object);
        }
        Object object = this.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Color)object;
    }

    private static final CharSequence getPresentableName$lambda$0(Object argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return argument instanceof Color ? (CharSequence)PresentableColor.Companion.toPresentableString((Color)argument) : (CharSequence)argument.toString();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/ColorMixture$Companion;", "", "<init>", "()V", "ENABLE_RUNTIME_COLOR_MIXTURE_WRAPPER_OPTION", "", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

