/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/access/GlobalStrictCredentialManager;", "Lcom/intellij/database/access/DbCredentialManager;", "<init>", "()V", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "getImpl", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "intellij.database.connectivity"})
public final class GlobalStrictCredentialManager
extends DbCredentialManager {
    @NotNull
    public static final GlobalStrictCredentialManager INSTANCE = new GlobalStrictCredentialManager();

    private GlobalStrictCredentialManager() {
    }

    @NotNull
    protected PasswordSafe getPasswordSafe() {
        return PasswordSafe.Companion.getInstance();
    }

    @Nullable
    protected Credentials getImpl(@NotNull CredentialAttributes attributes) {
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Credentials credentials2 = super.getImpl(attributes);
        if (credentials2 != null) {
            Credentials it = credentials2;
            boolean bl = false;
            if (it == CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN()) {
                throw new DbCredentialManager.DbCredentialsException("Unable to unlock keychain");
            }
            if (it == CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                throw new ProcessCanceledException();
            }
            credentials = it;
        } else {
            credentials = null;
        }
        return credentials;
    }
}

