/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.AsyncUtil;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/audit/CancelProgressAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "requestCancelStarted", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "cancelRequest", "Lcom/intellij/database/datagrid/DataRequest$Cancel;", "Companion", "intellij.database.connectivity"})
public final class CancelProgressAuditor
implements DataAuditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseSession session;
    @JvmField
    @NotNull
    public static final Key<Boolean> SHOW_CANCEL_PROGRESS;

    public CancelProgressAuditor(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    public void requestCancelStarted(@NotNull DataRequest.Context context, @Nullable DataRequest.Cancel cancelRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataRequest.Cancel cancel = cancelRequest;
        if (!(cancel != null ? Intrinsics.areEqual((Object)cancel.getUserData(SHOW_CANCEL_PROGRESS), (Object)true) : false)) {
            return;
        }
        AsyncPromise requestCancelFinishedPromise = CancelProgressAuditor.Companion.getRequestCancelFinishedPromise(context, cancelRequest);
        if (!requestCancelFinishedPromise.isDone()) {
            ScheduledFuture<?> cancelNotificationFeature = AppExecutorUtil.getAppScheduledExecutorService().schedule(CancelProgressAuditor.Companion.showTerminationNotification(this.session), 10L, TimeUnit.SECONDS);
            requestCancelFinishedPromise.onProcessed(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$1(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$0(cancelNotificationFeature, arg_0), arg_0));
            ApplicationManager.getApplication().invokeLater(() -> CancelProgressAuditor.requestCancelStarted$lambda$2(requestCancelFinishedPromise, this));
        }
    }

    private static final Unit requestCancelStarted$lambda$2$0(ProgressIndicatorEx $indicator, Void it) {
        $indicator.processFinish();
        return Unit.INSTANCE;
    }

    private static final void requestCancelStarted$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit requestCancelStarted$lambda$0(ScheduledFuture $cancelNotificationFeature, Void it) {
        $cancelNotificationFeature.cancel(true);
        return Unit.INSTANCE;
    }

    private static final void requestCancelStarted$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void requestCancelStarted$lambda$2(AsyncPromise $requestCancelFinishedPromise, CancelProgressAuditor this$0) {
        if (!$requestCancelFinishedPromise.isDone()) {
            LocalDataSource localDataSource = this$0.session.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            Object[] objectArray = new Object[]{this$0.session.getDisplayName(), dataSource.getName()};
            String string = DatabaseBundle.message((String)"cancel.running.statements.progress.indicator.title", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            ProgressIndicatorEx indicator = AsyncUtil.createBackgroundIndicator((Project)this$0.session.getProject(), (String)title, (boolean)false);
            $requestCancelFinishedPromise.onProcessed(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$2$1(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$2$0(indicator, arg_0), arg_0));
        }
    }

    static {
        Key key = Key.create((String)"SHOW_CANCEL_PROGRESS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SHOW_CANCEL_PROGRESS = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R#\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/run/audit/CancelProgressAuditor$Companion;", "", "<init>", "()V", "SHOW_CANCEL_PROGRESS", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRequestCancelFinishedPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "cancelRequest", "Lcom/intellij/database/datagrid/DataRequest$Cancel;", "showTerminationNotification", "Ljava/lang/Runnable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final AsyncPromise<Void> getRequestCancelFinishedPromise(DataRequest.Context context, DataRequest.Cancel cancelRequest) {
            AsyncPromise res = new AsyncPromise();
            context.request.getPromise().onProcessed(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$1(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$0(res, arg_0), arg_0));
            cancelRequest.getPromise().onError(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$3(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$2(res, arg_0), arg_0));
            return res;
        }

        private final Runnable showTerminationNotification(DatabaseSession session) {
            Object[] objectArray = new Object[]{session.getDisplayName(), session.getConnectionPoint().getDataSource().getName()};
            String string = DatabaseBundle.message((String)"deactivate.data.source.notification.title", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String string2 = DatabaseBundle.message((String)"deactivate.data.source.notification.content", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String content = string2;
            return () -> Companion.showTerminationNotification$lambda$0(title, content, session);
        }

        private static final Unit getRequestCancelFinishedPromise$lambda$0(AsyncPromise $res, Void it) {
            $res.setResult((Object)it);
            return Unit.INSTANCE;
        }

        private static final void getRequestCancelFinishedPromise$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit getRequestCancelFinishedPromise$lambda$2(AsyncPromise $res, Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $res.setError(it);
            return Unit.INSTANCE;
        }

        private static final void getRequestCancelFinishedPromise$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void showTerminationNotification$lambda$0(String $title, String $content, DatabaseSession $session) {
            ConnDatabaseNotifications.DATABASE_CANCEL_GROUP().createNotification($title, $content, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter($session){
                final /* synthetic */ DatabaseSession $session;
                {
                    this.$session = $session;
                }

                protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SessionsUtil.deactivateDataSourceAsync(this.$session);
                }
            }).setDisplayId("CancelProgressAuditor.too.long").notify($session.getProject());
            IdeUiService.getInstance().systemNotify($title, $content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

