/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/builtInWebServer/LastResortWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "<init>", "()V", "resolve", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getPathInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.builtInServer.impl"})
public final class LastResortWebServerRootsProvider
extends WebServerRootsProvider {
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        for (VirtualFile baseDirectory : BaseProjectDirectories.Companion.getBaseDirectories(project)) {
            VirtualFile virtualFile = baseDirectory.findFileByRelativePath(path);
            if (virtualFile == null) continue;
            VirtualFile file = virtualFile;
            return new PathInfo(null, file, baseDirectory, null, false, false, 56, null);
        }
        return null;
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile root = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(file);
        return root != null ? new PathInfo(null, file, root, null, false, false, 56, null) : null;
    }
}

