/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002\u0003\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\"\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"cacheSize", "", "RELATIVE_PATH_RESOLVER", "org/jetbrains/builtInWebServer/WebServerPathToFileManagerKt$RELATIVE_PATH_RESOLVER$1", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManagerKt$RELATIVE_PATH_RESOLVER$1;", "EMPTY_PATH_RESOLVER", "org/jetbrains/builtInWebServer/WebServerPathToFileManagerKt$EMPTY_PATH_RESOLVER$1", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManagerKt$EMPTY_PATH_RESOLVER$1;", "defaultPathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getDefaultPathQuery", "()Lorg/jetbrains/builtInWebServer/PathQuery;", "intellij.platform.builtInServer.impl"})
public final class WebServerPathToFileManagerKt {
    private static final long cacheSize = 16384L;
    @NotNull
    private static final RELATIVE_PATH_RESOLVER.1 RELATIVE_PATH_RESOLVER = new FileResolver(){

        public PathInfo resolve(String path, VirtualFile root, String moduleName, boolean isLibrary, PathQuery pathQuery) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
            if (pathQuery.getUseVfs() || !Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance()) || Intrinsics.areEqual((Object)path, (Object)".htaccess") || Intrinsics.areEqual((Object)path, (Object)"config.json")) {
                PathInfo pathInfo;
                VirtualFile virtualFile = root.findFileByRelativePath(path);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    pathInfo = new PathInfo(null, it, root, moduleName, isLibrary, false, 32, null);
                } else {
                    pathInfo = null;
                }
                return pathInfo;
            }
            String[] stringArray = new String[]{path};
            Path file = Paths.get(root.getPath(), stringArray);
            Intrinsics.checkNotNull((Object)file);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? new PathInfo(file, null, root, moduleName, isLibrary, false, 32, null) : null;
        }
    };
    @NotNull
    private static final EMPTY_PATH_RESOLVER.1 EMPTY_PATH_RESOLVER = new FileResolver(){

        public PathInfo resolve(String path, VirtualFile root, String moduleName, boolean isLibrary, PathQuery pathQuery) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
            VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            return new PathInfo(null, file, root, moduleName, isLibrary, false, 32, null);
        }
    };
    @NotNull
    private static final PathQuery defaultPathQuery = new PathQuery();

    @NotNull
    public static final PathQuery getDefaultPathQuery() {
        return defaultPathQuery;
    }

    public static final /* synthetic */ EMPTY_PATH_RESOLVER.1 access$getEMPTY_PATH_RESOLVER$p() {
        return EMPTY_PATH_RESOLVER;
    }

    public static final /* synthetic */ RELATIVE_PATH_RESOLVER.1 access$getRELATIVE_PATH_RESOLVER$p() {
        return RELATIVE_PATH_RESOLVER;
    }
}

