/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.ClientInfo;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0017\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/io/fastCgi/ClientInfo;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "configureBootstrap", "", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "addCloseListener", "it", "Lio/netty/channel/Channel;", "send", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "handleError", "allocateRequestId", "", "channel", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "responseReceived", "id", "buffer", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nFastCgiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastCgiService.kt\norg/jetbrains/io/fastCgi/FastCgiService\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,224:1\n39#2,6:225\n66#2,2:231\n*S KotlinDebug\n*F\n+ 1 FastCgiService.kt\norg/jetbrains/io/fastCgi/FastCgiService\n*L\n31#1:225,6\n39#1:231,2\n*E\n"})
public abstract class FastCgiService
extends SingleConnectionNetService {
    @NotNull
    private final AtomicInteger requestIdCounter;
    @NotNull
    private final ConcurrentIntObjectMap<ClientInfo> requests;

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.requests = concurrentIntObjectMap;
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $this$handler$iv = bootstrap;
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(errorOutputConsumer, this){
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;
            final /* synthetic */ FastCgiService this$0;
            {
                this.$errorOutputConsumer$inlined = consumer;
                this.this$0 = fastCgiService;
            }

            protected void initChannel(Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
            }
        });
    }

    @Override
    protected void addCloseListener(@NotNull Channel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        super.addCloseListener(it);
        ChannelFuture channelFuture = it.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"closeFuture(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(this){
            final /* synthetic */ FastCgiService this$0;
            {
                this.this$0 = fastCgiService;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                FastCgiService.access$getRequestIdCounter$p(this.this$0).set(0);
                if (!FastCgiService.access$getRequests$p(this.this$0).isEmpty()) {
                    Enumeration enumeration = FastCgiService.access$getRequests$p(this.this$0).elements();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"elements(...)");
                    ArrayList<T> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    List waitingClients = arrayList;
                    FastCgiService.access$getRequests$p(this.this$0).clear();
                    for (ClientInfo client : waitingClients) {
                        FastCgiServiceKt.access$sendBadGateway(client.getChannel(), client.getExtraHeaders());
                    }
                }
            }
        });
    }

    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        Intrinsics.checkNotNullParameter((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ByteBuf notEmptyContent = null;
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            Promise<Channel> promise = null;
            OSProcessHandler handler2 = (OSProcessHandler)this.getProcessHandler().getResultIfFullFilled();
            if (handler2 == null) {
                Promise<Channel> promise2 = this.getProcessHandler().get();
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"get(...)");
                promise = promise2;
            } else {
                Channel channel = this.getProcessChannel().get();
                if (channel == null || !channel.isOpen()) {
                    promise = this.connectAgain();
                } else {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
                    return;
                }
            }
            Promise promise3 = promise.onSuccess(arg_0 -> FastCgiService.send$lambda$1(arg_0 -> FastCgiService.send$lambda$0(fastCgiRequest, notEmptyContent, this, arg_0), arg_0)).onError(arg_0 -> FastCgiService.send$lambda$3(arg_0 -> FastCgiService.send$lambda$2(this, fastCgiRequest, notEmptyContent, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise3);
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content) {
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            ClientInfo clientInfo = (ClientInfo)this.requests.remove(fastCgiRequest.getRequestId());
            if (clientInfo != null) {
                ClientInfo it = clientInfo;
                boolean bl = false;
                FastCgiServiceKt.access$sendBadGateway(it.getChannel(), it.getExtraHeaders());
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel, @NotNull PathInfo pathInfo, @NotNull FullHttpRequest request, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)new ClientInfo(channel, pathInfo, request, extraHeaders));
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id, @Nullable ByteBuf buffer) {
        ByteBuf byteBuf;
        ClientInfo client = (ClientInfo)this.requests.remove(id);
        if (client == null || !client.getChannel().isActive()) {
            ByteBuf byteBuf2 = buffer;
            if (byteBuf2 != null) {
                byteBuf2.release();
            }
            return;
        }
        Channel channel = client.getChannel();
        if (buffer == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_GATEWAY");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, null, (int)14, null);
            return;
        }
        String extraSuffix = WebServerPageConnectionService.Companion.getInstance().fileRequested(client.getRequest(), false, () -> ((PathInfo)client.getPathInfo()).getOrResolveVirtualFile());
        if (extraSuffix == null) {
            byteBuf = buffer;
        } else {
            ByteBuf[] byteBufArray = new ByteBuf[]{buffer, Unpooled.copiedBuffer((CharSequence)extraSuffix, (Charset)Charsets.UTF_8)};
            byteBuf = Unpooled.wrappedBuffer((ByteBuf[])byteBufArray);
        }
        ByteBuf bufferWithExtraSuffix = byteBuf;
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, bufferWithExtraSuffix);
        try {
            HttpResponse httpResponse2 = (HttpResponse)httpResponse;
            Intrinsics.checkNotNull((Object)bufferWithExtraSuffix);
            FastCgiServiceKt.access$parseHeaders(httpResponse2, bufferWithExtraSuffix);
            Responses.addServer((HttpResponse)((HttpResponse)httpResponse));
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)bufferWithExtraSuffix.readableBytes());
            }
            httpResponse.headers().add(client.getExtraHeaders());
        }
        catch (Throwable e) {
            bufferWithExtraSuffix.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, null, (int)14, null);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    private static final Unit send$lambda$0(FastCgiRequest $fastCgiRequest, ByteBuf $notEmptyContent, FastCgiService this$0, Object it) {
        Channel channel = this$0.getProcessChannel().get();
        Intrinsics.checkNotNull((Object)channel);
        $fastCgiRequest.writeToServerChannel($notEmptyContent, channel);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit send$lambda$2(FastCgiService this$0, FastCgiRequest $fastCgiRequest, ByteBuf $notEmptyContent, Throwable it) {
        Logger logger = FastCgiServiceKt.getLOG();
        Intrinsics.checkNotNull((Object)it);
        Promises.errorIfNotMessage((Logger)logger, (Throwable)it);
        this$0.handleError($fastCgiRequest, $notEmptyContent);
        return Unit.INSTANCE;
    }

    private static final void send$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    public static final /* synthetic */ ConcurrentIntObjectMap access$getRequests$p(FastCgiService $this) {
        return $this.requests;
    }
}

