/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "sendBadGateway", "", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "parseHeaders", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nFastCgiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastCgiService.kt\norg/jetbrains/io/fastCgi/FastCgiServiceKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,224:1\n13#2:225\n*S KotlinDebug\n*F\n+ 1 FastCgiService.kt\norg/jetbrains/io/fastCgi/FastCgiServiceKt\n*L\n23#1:225\n*E\n"})
public final class FastCgiServiceKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final void sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        try {
            if (channel.isActive()) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_GATEWAY");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, null, null, (HttpHeaders)extraHeaders, (int)6, null);
            }
        }
        catch (Throwable e) {
            NettyUtil.log((Throwable)e, (Logger)LOG);
        }
    }

    private static final void parseHeaders(HttpResponse response, ByteBuf buffer) {
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            String value;
            byte b22;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b22 = buffer.readByte()) >= 0 && (char)b22 != '\n') {
                if ((char)b22 == '\r') continue;
                if (valueExpected && (char)b22 == ':') {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace((ByteBuf)buffer);
                    continue;
                }
                builder.append((char)b22);
            }
            if (((CharSequence)builder).length() == 0) {
                return;
            }
            CharSequence b22 = key;
            if (b22 == null || b22.length() == 0 || StringsKt.startsWith((String)key, (String)"http", (boolean)true) || StringsKt.startsWith((String)key, (String)"X-Accel-", (boolean)true)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)builder.toString(), (String)"toString(...)");
            if (StringsKt.equals((String)key, (String)"status", (boolean)true)) {
                int index = StringsKt.indexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                String string = value.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(string)));
                continue;
            }
            if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2, null)) continue;
            response.headers().add(key, (Object)value);
        }
    }

    public static final /* synthetic */ void access$sendBadGateway(Channel channel, HttpHeaders extraHeaders) {
        FastCgiServiceKt.sendBadGateway(channel, extraHeaders);
    }

    public static final /* synthetic */ void access$parseHeaders(HttpResponse response, ByteBuf buffer) {
        FastCgiServiceKt.parseHeaders(response, buffer);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FastCgiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

