/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinRule;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinUtil;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

@NotNullByDefault
public final class CucumberCompletionContributor
extends CompletionContributor {
    private static final Map<String, String> GROUP_TYPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> PARAMETERS_MAP = new HashMap<String, String>();
    private static final int SCENARIO_KEYWORD_PRIORITY = 70;
    private static final int SCENARIO_OUTLINE_KEYWORD_PRIORITY = 60;
    public static final Pattern POSSIBLE_GROUP_PATTERN;
    public static final Pattern QUESTION_MARK_PATTERN;
    public static final Pattern ARGS_INTO_BRACKETS_PATTERN;
    public static final Pattern PARAMETERS_PATTERN;
    public static final String INTELLIJ_IDEA_RULEZZZ = "IntellijIdeaRulezzz";

    public CucumberCompletionContributor() {
        PsiElementPattern.Capture inTable = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(GherkinElementTypes.TABLE));
        PsiElementPattern.Capture inScenario = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(GherkinElementTypes.SCENARIOS))).andNot((ElementPattern)inTable);
        PsiElementPattern.Capture inStep = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(GherkinElementTypes.STEP))).andNot((ElementPattern)inTable);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiElement(GherkinFile.class))).andNot((ElementPattern)inTable), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PsiFile psiFile = parameters.getOriginalFile();
                if (psiFile instanceof GherkinFile) {
                    GherkinFile file = (GherkinFile)psiFile;
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
                    boolean gherkin6Enabled = module != null && CucumberStepHelper.isGherkin6Supported(module);
                    GherkinKeywordProvider keywordProvider = JsonGherkinKeywordProvider.getKeywordProvider(gherkin6Enabled);
                    String language = GherkinUtil.getFeatureLanguage(file);
                    GherkinKeywordTable gherkinKeywordTable = keywordProvider.getKeywordsTable(language);
                    PsiElement position = parameters.getPosition();
                    PsiElement coveringElement = PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{GherkinStep.class, GherkinFeature.class, PsiFileSystemItem.class});
                    if (coveringElement instanceof PsiFileSystemItem) {
                        CucumberCompletionContributor.addFeatureKeywords(result, gherkinKeywordTable);
                    } else if (coveringElement instanceof GherkinFeature) {
                        if (gherkin6Enabled) {
                            CucumberCompletionContributor.addRuleKeyword(result, gherkinKeywordTable);
                        }
                        CucumberCompletionContributor.addScenarioKeywords(result, psiFile, position, gherkinKeywordTable);
                    } else if (coveringElement instanceof GherkinRule) {
                        CucumberCompletionContributor.addScenarioKeywords(result, psiFile, position, gherkinKeywordTable);
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)inScenario.andNot((ElementPattern)inStep), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                CucumberCompletionContributor.addStepKeywords(result, parameters.getOriginalFile());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)inStep, (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                CucumberCompletionContributor.addStepDefinitions(result, parameters.getOriginalFile());
            }
        });
    }

    private static void addRuleKeyword(CompletionResultSet result, GherkinKeywordTable gherkinKeywordTable) {
        CucumberCompletionContributor.addKeywordsToResult(gherkinKeywordTable.getRuleKeywords(), result, true);
    }

    private static void addScenarioKeywords(CompletionResultSet result, PsiFile originalFile, PsiElement originalPosition, GherkinKeywordTable table) {
        PsiElement prevElement;
        ArrayList<String> keywords = new ArrayList<String>();
        if (!CucumberCompletionContributor.haveBackground(originalFile)) {
            keywords.addAll(table.getBackgroundKeywords());
        }
        if ((prevElement = CucumberCompletionContributor.getPreviousElement(originalPosition)) != null && prevElement.getNode().getElementType() == GherkinTokenTypes.SCENARIO_KEYWORD) {
            for (String scenarioKeyword : table.getScenarioKeywords()) {
                if (!prevElement.getText().startsWith(scenarioKeyword)) continue;
                result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(scenarioKeyword + " " + result.getPrefixMatcher().getPrefix()));
                break;
            }
            boolean haveColon = false;
            String elementText = originalPosition.getText();
            int rulezzIndex = elementText.indexOf(INTELLIJ_IDEA_RULEZZZ);
            if (rulezzIndex >= 0) {
                haveColon = elementText.substring(rulezzIndex + INTELLIJ_IDEA_RULEZZZ.length()).trim().startsWith(":");
            }
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioOutlineKeywords(), result, !haveColon, 60, !haveColon);
        } else {
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioKeywords(), result, true, 70, true);
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioOutlineKeywords(), result, true, 60, true);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)originalPosition, (Class[])new Class[]{GherkinScenarioOutlineImpl.class, GherkinExamplesBlockImpl.class}) != null) {
            keywords.addAll(table.getExampleSectionKeywords());
        }
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, true);
    }

    @Nullable
    private static PsiElement getPreviousElement(PsiElement element) {
        PsiElement prevElement = element.getPrevSibling();
        if (prevElement instanceof PsiWhiteSpace) {
            prevElement = prevElement.getPrevSibling();
        }
        return prevElement;
    }

    private static void addFeatureKeywords(CompletionResultSet result, GherkinKeywordTable gherkinKeywordTable) {
        Collection<String> keywords = gherkinKeywordTable.getFeaturesSectionKeywords();
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, true);
    }

    private static void addKeywordsToResult(Collection<String> keywords, CompletionResultSet result, boolean withColonSuffix) {
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, withColonSuffix, 0, true);
    }

    private static void addKeywordsToResult(Collection<String> keywords, CompletionResultSet result, boolean withColonSuffix, int priority, boolean withSpace) {
        for (String keyword : keywords) {
            LookupElement element = CucumberCompletionContributor.createKeywordLookupElement((String)(withColonSuffix ? keyword + ":" : keyword), withSpace);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority));
        }
    }

    private static LookupElement createKeywordLookupElement(String keyword, boolean withSpace) {
        LookupElementBuilder result = LookupElementBuilder.create((String)keyword);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            result = result.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        }
        if (withSpace) {
            result = TailTypeDecorator.withTail((LookupElement)result, (TailType)TailTypes.spaceType());
        }
        return result;
    }

    private static boolean haveBackground(PsiFile originalFile) {
        GherkinScenario[] scenarios;
        PsiElement scenarioParent = PsiTreeUtil.getChildOfType((PsiElement)originalFile, GherkinFeature.class);
        if (scenarioParent == null) {
            scenarioParent = originalFile;
        }
        if ((scenarios = (GherkinScenario[])PsiTreeUtil.getChildrenOfType((PsiElement)scenarioParent, GherkinScenario.class)) != null) {
            for (GherkinScenario scenario : scenarios) {
                if (!scenario.isBackground()) continue;
                return true;
            }
        }
        return false;
    }

    private static void addStepKeywords(CompletionResultSet result, PsiFile file) {
        if (!(file instanceof GherkinFile)) {
            return;
        }
        GherkinFile gherkinFile = (GherkinFile)file;
        CucumberCompletionContributor.addKeywordsToResult(gherkinFile.getStepKeywords(), result, false);
    }

    private static void addStepDefinitions(CompletionResultSet result, PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        List<AbstractStepDefinition> stepDefinitions = CucumberStepHelper.loadStepsFor(file, module);
        for (AbstractStepDefinition stepDefinition : stepDefinitions) {
            String expression = stepDefinition.getExpression();
            if (expression == null) continue;
            for (String stepCompletion : CucumberCompletionContributor.parseVariationsIntoBrackets(expression)) {
                stepCompletion = StringUtil.trimStart((String)stepCompletion, (String)"^");
                stepCompletion = StringUtil.trimEnd((String)stepCompletion, (String)"$");
                stepCompletion = StringUtil.replace((String)stepCompletion, (String)"\\\"", (String)"\"");
                for (Map.Entry<String, String> group : GROUP_TYPE_MAP.entrySet()) {
                    stepCompletion = StringUtil.replace((String)stepCompletion, (String)group.getKey(), (String)group.getValue());
                }
                for (Map.Entry<String, String> group : PARAMETERS_MAP.entrySet()) {
                    stepCompletion = stepCompletion.replaceAll(group.getKey(), group.getValue());
                }
                ArrayList<TextRange> ranges = new ArrayList<TextRange>();
                Matcher m = QUESTION_MARK_PATTERN.matcher(stepCompletion);
                if (m.find()) {
                    stepCompletion = m.replaceAll("$1");
                }
                m = POSSIBLE_GROUP_PATTERN.matcher(stepCompletion);
                while (m.find()) {
                    stepCompletion = m.replaceAll("$1");
                }
                m = PARAMETERS_PATTERN.matcher(stepCompletion);
                while (m.find()) {
                    ranges.add(new TextRange(m.start(), m.end()));
                }
                PsiElement element = stepDefinition.getNavigationElement();
                LookupElementBuilder lookup = element != null ? LookupElementBuilder.create((Object)element, (String)stepCompletion).bold() : LookupElementBuilder.create((String)stepCompletion);
                result.addElement((LookupElement)lookup.withInsertHandler((InsertHandler)new StepInsertHandler(ranges)));
            }
        }
    }

    private static Set<String> parseVariationsIntoBrackets(String cucumberRegex) {
        ArrayList<Pair> insertions = new ArrayList<Pair>();
        Matcher m = ARGS_INTO_BRACKETS_PATTERN.matcher(cucumberRegex);
        String mainSample = cucumberRegex;
        int k = 0;
        while (m.find()) {
            String values = cucumberRegex.substring(m.start(1), m.end(1));
            if (!values.chars().allMatch(c -> Character.isLetterOrDigit(c) || c == 124)) continue;
            String key = "@key=" + k++ + "@";
            mainSample = mainSample.replace(m.group(), key);
            insertions.add(Pair.create((Object)key, Arrays.asList(values.split("\\|"))));
        }
        int[] sampleCounts = new int[insertions.size()];
        int combinationCount = 1;
        for (int i = 0; i < insertions.size(); ++i) {
            sampleCounts[i] = ((List)((Pair)insertions.get(i)).getSecond()).size();
            combinationCount *= sampleCounts[i];
        }
        ArrayList<int[]> combinations = new ArrayList<int[]>();
        int[] combination = new int[sampleCounts.length];
        for (int i = 0; i < sampleCounts.length; ++i) {
            combination[i] = 1;
        }
        combinations.add(combination);
        for (int j = 0; j < combinationCount; ++j) {
            int[] currentCombination = (int[])combination.clone();
            for (int i = sampleCounts.length - 1; i >= 0; --i) {
                if (currentCombination[i] != sampleCounts[i]) {
                    int n = i;
                    currentCombination[n] = currentCombination[n] + 1;
                    break;
                }
                currentCombination[i] = 1;
            }
            combination = currentCombination;
            combinations.add(currentCombination);
        }
        HashSet<String> result = new HashSet<String>();
        for (int[] c2 : combinations) {
            String stepVar = mainSample;
            for (int i = 0; i < c2.length; ++i) {
                Pair insertion = (Pair)insertions.get(i);
                String key = (String)insertion.getFirst();
                stepVar = stepVar.replace(key, (CharSequence)((List)insertion.getSecond()).get(c2[i] - 1));
            }
            result.add(stepVar);
        }
        return result;
    }

    static {
        GROUP_TYPE_MAP.put("(.*)", "<any>");
        GROUP_TYPE_MAP.put("[^\\s]+", "<word>");
        GROUP_TYPE_MAP.put("(.+)", "<string>");
        GROUP_TYPE_MAP.put("([^\"]*)", "<string>");
        GROUP_TYPE_MAP.put("([^\"]+)", "<string>");
        GROUP_TYPE_MAP.put("(\\d*)", "<number>");
        GROUP_TYPE_MAP.put("(\\d)", "<number>");
        GROUP_TYPE_MAP.put("(-?\\d+)", "<number>");
        GROUP_TYPE_MAP.put("(\\d+)", "<number>");
        GROUP_TYPE_MAP.put("(-?\\d*[.,]?\\d+)", "<float>");
        GROUP_TYPE_MAP.put("(\\.[\\d]+)", "<float>");
        GROUP_TYPE_MAP.put("(\"(?:[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'(?:[^'\\\\]*(?:\\\\.[^'\\\\]*)*)')", "<string>");
        PARAMETERS_MAP.put("\\([^|]*\\|[^|]*(?:\\|[^|]*)*\\)", "<param>");
        PARAMETERS_MAP.put("#\\{[^\\}]*\\}", "<param>");
        POSSIBLE_GROUP_PATTERN = Pattern.compile("\\(([^)]*)\\)");
        QUESTION_MARK_PATTERN = Pattern.compile("([^\\\\])\\?:?");
        ARGS_INTO_BRACKETS_PATTERN = Pattern.compile("\\((?:\\?[!:])?([^)]*\\|[^)]*)\\)");
        PARAMETERS_PATTERN = Pattern.compile("<string>|<number>|<param>|<word>|<float>|<any>|\\{[^}]+}");
    }

    private static final class StepInsertHandler
    implements InsertHandler<LookupElement> {
        private final List<TextRange> ranges;

        private StepInsertHandler(List<TextRange> ranges) {
            this.ranges = ranges;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element;
            GherkinStep step;
            if (!this.ranges.isEmpty() && (step = (GherkinStep)PsiTreeUtil.getParentOfType((PsiElement)(element = context.getFile().findElementAt(context.getStartOffset())), GherkinStep.class)) != null) {
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)step);
                int off = context.getStartOffset() - step.getTextRange().getStartOffset();
                String stepText = step.getText();
                for (TextRange groupRange : this.ranges) {
                    TextRange shiftedRange = groupRange.shiftRight(off);
                    String matchedText = shiftedRange.substring(stepText);
                    builder.replaceRange(shiftedRange, matchedText);
                }
                builder.run(context.getEditor(), false);
            }
        }
    }
}

