/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateAllStepsFix;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

@NotNullByDefault
public final class CucumberStepInspection
extends GherkinInspection {
    public String getShortName() {
        return "CucumberUndefinedStep";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new GherkinElementVisitor(this){

            @Override
            public void visitStep(GherkinStep step) {
                super.visitStep(step);
                PsiElement parent = step.getParent();
                if (parent instanceof GherkinStepsHolder) {
                    CucumberStepReference reference = CucumberUtil.getCucumberStepReference(step);
                    if (reference == null) {
                        return;
                    }
                    ResolveResult[] resolveResults = reference.multiResolve(false);
                    if (resolveResults.length == 0) {
                        LocalQuickFix[] fixes = null;
                        if (!CucumberJvmExtensionPoint.EP_NAME.getExtensionList().isEmpty()) {
                            fixes = new LocalQuickFix[]{new CucumberCreateStepFix(), new CucumberCreateAllStepsFix()};
                        }
                        holder.registerProblem(reference.getElement(), reference.getRangeInElement(), CucumberBundle.message("cucumber.inspection.undefined.step.msg.name", new Object[0]), fixes);
                    } else if (resolveResults.length > 1) {
                        holder.registerProblem(reference.getElement(), reference.getRangeInElement(), CucumberBundle.message("cucumber.inspection.ambiguous.step.msg.name", resolveResults.length), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }
}

