/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForFeatureCommentFix;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForScenarioCommentFix;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForStepCommentFix;
import org.jetbrains.plugins.cucumber.psi.GherkinSuppressionHolder;

public final class GherkinSuppressionUtil {
    private static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("#\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    private GherkinSuppressionUtil() {
    }

    public static SuppressQuickFix @NotNull [] getDefaultSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(0);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new GherkinSuppressForStepCommentFix(toolId), new GherkinSuppressForScenarioCommentFix(toolId), new GherkinSuppressForFeatureCommentFix(toolId)};
        if (suppressQuickFixArray == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    public static boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> GherkinSuppressionUtil.getSuppressedIn(element, toolId) != null);
    }

    @Nullable
    private static PsiComment getSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(4);
        }
        if (toolId == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(5);
        }
        PsiElement suppressionHolder = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GherkinSuppressionHolder.class});
        while (suppressionHolder != null) {
            PsiComment suppressionHolderElement = GherkinSuppressionUtil.getSuppressionComment(toolId, suppressionHolder);
            if (suppressionHolderElement != null) {
                return suppressionHolderElement;
            }
            suppressionHolder = PsiTreeUtil.getParentOfType((PsiElement)suppressionHolder, GherkinSuppressionHolder.class);
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressionComment(@NotNull String toolId, @NotNull PsiElement element) {
        PsiElement comment;
        if (toolId == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GherkinSuppressionUtil.$$$reportNull$$$0(7);
        }
        if ((comment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element)) instanceof PsiComment) {
            PsiComment psiComment = (PsiComment)comment;
            String text = comment.getText();
            Matcher matcher = SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text);
            if (matcher.matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                return psiComment;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSuppressActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedIn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

