/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;

@ApiStatus.Internal
@NotNullByDefault
public class GherkinTableCellImpl
extends GherkinPsiElementBase
implements GherkinTableCell {
    public GherkinTableCellImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitGherkinTableCell(this);
    }

    public String toString() {
        return "GherkinTableCell:" + this.getName();
    }

    @Override
    protected String getPresentableText() {
        return String.format("Step parameter '%s'", this.getName());
    }

    public PsiElement setName(@NonNls String name) throws IncorrectOperationException {
        LeafPsiElement content = (LeafPsiElement)PsiTreeUtil.getChildOfType((PsiElement)this, LeafPsiElement.class);
        if (content != null) {
            PsiElement[] elements = GherkinElementFactory.getTopLevelElements(this.getProject(), name);
            this.getNode().replaceChild((ASTNode)content, elements[0].getNode());
        }
        return this;
    }

    public String getName() {
        return this.getText();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return PsiTreeUtil.getChildOfType((PsiElement)this, LeafPsiElement.class);
    }

    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)this.getContainingFile());
    }

    public PsiReference[] getReferences() {
        return (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getReferencesInner(), (Object[])new Object[]{this}));
    }

    private PsiReference[] getReferencesInner() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
    }
}

