/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinLanguage;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class GherkinFileImpl
extends PsiFileBase
implements GherkinFile {
    public GherkinFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)GherkinLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        GherkinFileType gherkinFileType = GherkinFileType.INSTANCE;
        if (gherkinFileType == null) {
            GherkinFileImpl.$$$reportNull$$$0(0);
        }
        return gherkinFileType;
    }

    public String toString() {
        return "GherkinFile:" + this.getName();
    }

    @Override
    public List<String> getStepKeywords() {
        GherkinKeywordProvider provider = JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)this);
        ArrayList<String> result = new ArrayList<String>();
        String language = this.getLocaleLanguage();
        GherkinKeywordTable table = provider.getKeywordsTable(language);
        result.addAll(table.getStepKeywords());
        return result;
    }

    @Override
    public String getLocaleLanguage() {
        FileASTNode node = this.getNode();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == GherkinTokenTypes.COMMENT) {
                String text = child.getText().substring(1).trim();
                String lang = GherkinLexer.fetchLocationLanguage(text);
                if (lang == null) continue;
                return lang;
            }
            if (child.getElementType() != TokenType.WHITE_SPACE) break;
        }
        return GherkinFileImpl.getDefaultLocale();
    }

    @Override
    public GherkinFeature[] getFeatures() {
        return (GherkinFeature[])this.findChildrenByClass(GherkinFeature.class);
    }

    public static String getDefaultLocale() {
        return "en";
    }

    public PsiElement findElementAt(int offset) {
        PsiElement result = super.findElementAt(offset);
        if (result == null && offset == this.getTextLength()) {
            PsiElement last = this.getLastChild();
            result = last != null ? last.getLastChild() : last;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinFileImpl", "getFileType"));
    }
}

