/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStepParameter;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

@NotNullByDefault
public class GherkinStepParameterRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return GherkinStepParameterRenameHandler.getGherkinStepParameter(dataContext) != null;
    }

    public void invoke(Project project, Editor editor, PsiFile file, DataContext dataContext) {
        GherkinStepParameter stepParameter = GherkinStepParameterRenameHandler.getGherkinStepParameter(dataContext);
        if (stepParameter == null) {
            return;
        }
        PsiReference stepParameterReference = stepParameter.getReference();
        if (stepParameterReference == null) {
            return;
        }
        PsiElement psiElement = stepParameterReference.resolve();
        if (!(psiElement instanceof GherkinTableCell)) {
            return;
        }
        GherkinTableCell tableCell = (GherkinTableCell)psiElement;
        super.invoke(project, new PsiElement[]{tableCell}, dataContext);
    }

    @Nullable
    private static GherkinStepParameter getGherkinStepParameter(@Nullable DataContext context) {
        PsiElement psiElement;
        ASTNode node;
        PsiFile psiFile;
        PsiElement element = null;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        }
        if (element != null && (node = element.getNode()) != null && node.getElementType() == GherkinTokenTypes.STEP_PARAMETER_BRACE && (psiElement = element.getPrevSibling()) instanceof GherkinStepParameter) {
            GherkinStepParameter stepParameter = (GherkinStepParameter)psiElement;
            element = stepParameter;
        }
        return (GherkinStepParameter)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStepParameter.class, (boolean)false);
    }
}

