/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.GridBagConstraints;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public final class GherkinStepRenameDialog
extends RenameDialog {
    private AbstractStepDefinition stepDefinition;
    private int oldParameterCount;

    public GherkinStepRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(1);
        }
        super(project, psiElement, nameSuggestionContext, editor);
    }

    protected RenameProcessor createRenameProcessor(@NotNull String newName) {
        if (newName == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(2);
        }
        return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    protected String getFullName() {
        return CucumberBundle.message("cucumber.step", new Object[0]);
    }

    protected void canRun() throws ConfigurationException {
        if (this.getNewName().isEmpty()) {
            throw new ConfigurationException(CucumberBundle.message("cucumber.refactor.rename.cannot.be.empty", new Object[0]));
        }
        int newParameterCount = CucumberUtil.getCukexHighlightRanges(this.getNewName()).size();
        if (this.oldParameterCount != newParameterCount) {
            int delta = newParameterCount - this.oldParameterCount;
            throw new ConfigurationException(CucumberBundle.message("cucumber.refactor.rename.new.parameter.introduced", delta));
        }
    }

    protected void createNewNameComponent() {
        super.createNewNameComponent();
        Runnable guardRunnable = () -> {
            Editor editor = this.getNameSuggestionsField().getEditor();
            if (editor != null) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(editor.getDocument().getTextLength());
                Document document = editor.getDocument();
                EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(document, new ReadonlyFragmentModificationHandler(this){

                    public void handle(ReadOnlyFragmentModificationException e) {
                    }
                });
                String expr = this.stepDefinition.getExpression();
                if (expr == null) {
                    throw new IllegalStateException("expression in the step definition being renamed must not be null");
                }
                if (CucumberUtil.isCucumberExpression(expr)) {
                    GherkinStepRenameDialog.guardCukexSpecialSymbols(editor);
                } else {
                    GherkinStepRenameDialog.guardRegexSpecialSymbols(editor);
                }
            }
        };
        SwingUtilities.invokeLater(guardRunnable);
    }

    @RequiresEdt
    private static void guardRegexSpecialSymbols(@NotNull Editor editor) {
        if (editor == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String text = editor.getDocument().getText();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)text);
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() != RegExpTT.CHARACTER) {
                editor.getDocument().createGuardedBlock(lexer.getTokenStart(), lexer.getTokenEnd());
            }
            lexer.advance();
        }
    }

    @RequiresEdt
    private static void guardCukexSpecialSymbols(@NotNull Editor editor) {
        if (editor == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String text = editor.getDocument().getText();
        List<TextRange> ranges = CucumberUtil.getCukexHighlightRanges(text);
        for (TextRange range : ranges) {
            editor.getDocument().createGuardedBlock(range.getStartOffset(), range.getEndOffset());
        }
    }

    public String[] getSuggestedNames() {
        CucumberStepReference ref;
        if (this.stepDefinition == null && (ref = CucumberUtil.getCucumberStepReference(this.getPsiElement())) != null) {
            this.stepDefinition = ref.resolveToDefinition();
        }
        if (this.stepDefinition == null) {
            throw new IllegalStateException("step definition must not be null");
        }
        String regexOrCukex = this.stepDefinition.getExpression();
        if (regexOrCukex != null) {
            if (CucumberUtil.isCucumberExpression(regexOrCukex)) {
                this.oldParameterCount = CucumberUtil.getCukexHighlightRanges(regexOrCukex).size();
                return new String[]{regexOrCukex};
            }
            String result = StringUtil.trimStart((String)regexOrCukex, (String)"^");
            result = StringUtil.trimEnd((String)result, (String)"$");
            return new String[]{result};
        }
        return super.getSuggestedNames();
    }

    protected void processNewNameChanged() {
        super.processNewNameChanged();
        this.getPreviewAction().setEnabled(true);
        this.getRefactorAction().setEnabled(true);
    }

    protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
        super.createCheckboxes(panel, gbConstraints);
        this.getCbSearchInComments().setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/GherkinStepRenameDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "guardRegexSpecialSymbols";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "guardCukexSpecialSymbols";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

