/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiElement;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepParameter;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.refactoring.rename.GherkinStepRenameDialog;

@NotNullByDefault
public final class GherkinStepRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        GherkinStep element = GherkinStepRenameHandler.getGherkinStep(dataContext);
        return element != null;
    }

    public void invoke(Project project, Editor editor, PsiFile file, DataContext dataContext) {
        GherkinStep step = GherkinStepRenameHandler.getGherkinStep(dataContext);
        if (step == null) {
            return;
        }
        if (!step.isRenameAllowed(null)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CucumberBundle.message("cucumber.refactor.rename.disabled", new Object[0]), (String)"", null);
            return;
        }
        GherkinStepRenameDialog dialog = new GherkinStepRenameDialog(project, step, null, editor);
        Disposer.register((Disposable)project, (Disposable)dialog.getDisposable());
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)dialog);
    }

    @Nullable
    private static GherkinStep getGherkinStep(@Nullable DataContext context) {
        PsiFile psiFile;
        PsiElement element = null;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        }
        if ((element = PsiTreeUtil.getParentOfType(element, GherkinPsiElement.class, (boolean)false)) instanceof GherkinStepParameter || element instanceof GherkinTableCell) {
            return null;
        }
        return (GherkinStep)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStep.class, (boolean)false);
    }
}

