/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

@NotNullByDefault
public final class GherkinStepRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(PsiElement element) {
        return element instanceof GherkinStep;
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        CucumberStepReference reference = CucumberUtil.getCucumberStepReference(element);
        if (reference != null) {
            List<AbstractStepDefinition> stepDefinitions = reference.resolveToDefinitions().stream().toList();
            if (stepDefinitions.size() != 1) {
                throw new IncorrectOperationException(CucumberBundle.message("cucumber.refactor.rename.step.definition.not.single", stepDefinitions.size()));
            }
            AbstractStepDefinition stepDefinition = stepDefinitions.getFirst();
            PsiElement stepDefinitionElement = stepDefinition.getElement();
            if (stepDefinitionElement == null) {
                throw new IllegalStateException("step definition must have have a backing PSI element");
            }
            boolean isWritable = false;
            for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
                if (!ep.isWritableStepLikeFile((PsiElement)stepDefinitionElement.getContainingFile())) continue;
                isWritable = true;
                break;
            }
            if (!isWritable) {
                String stepDefinitionFilePath = stepDefinitionElement.getContainingFile().getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(CucumberBundle.message("cucumber.refactor.rename.step.definition.file.not.writable", stepDefinitionFilePath));
            }
            String regexp = stepDefinition.getCucumberRegex();
            String expression = stepDefinition.getExpression();
            if (expression != null && regexp != null) {
                List<String> newStaticTexts;
                boolean expressionIsRegex = expression.equals(regexp);
                Object parameterTypeManager = MapParameterTypeManager.DEFAULT;
                for (CucumberJvmExtensionPoint ep : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
                    UsageInfo[] moreSpecificParameterTypeManager = ep.getParameterTypeManager(stepDefinition);
                    if (moreSpecificParameterTypeManager == null) continue;
                    parameterTypeManager = moreSpecificParameterTypeManager;
                    break;
                }
                Pattern oldStepDefPattern = Pattern.compile(expressionIsRegex ? GherkinStepRenameProcessor.prepareRegexAndGetStaticTexts(regexp).getFirst() : GherkinStepRenameProcessor.prepareRegexFromCukex(expression, parameterTypeManager));
                List<String> list = newStaticTexts = expressionIsRegex ? GherkinStepRenameProcessor.prepareRegexAndGetStaticTexts(newName) : GherkinStepRenameProcessor.getStaticTextsFromCukex(newName);
                if (expressionIsRegex) {
                    newStaticTexts.removeFirst();
                }
                for (UsageInfo usage : usages) {
                    PsiElement possibleStep = usage.getElement();
                    if (!(possibleStep instanceof GherkinStep)) continue;
                    GherkinStep gherkinStep = (GherkinStep)possibleStep;
                    String oldStepName = gherkinStep.getName();
                    String newStepName = GherkinStepRenameProcessor.getNewStepName(oldStepName, oldStepDefPattern, newStaticTexts);
                    gherkinStep.setName(newStepName);
                }
                String prefix = expression.startsWith("^") ? "^" : "";
                String suffix = expression.endsWith("$") ? "$" : "";
                stepDefinition.setValue(prefix + newName + suffix);
                if (listener != null) {
                    listener.elementRenamed(stepDefinitionElement);
                }
            }
        }
    }

    public Collection<PsiReference> findReferences(PsiElement element, SearchScope searchScope, boolean searchInCommentsAndStrings) {
        String cucumberRegex;
        PsiElement stepDefElement;
        AbstractStepDefinition abstractStepDef;
        if (!(element instanceof GherkinStep)) {
            throw new IllegalStateException("element must be a GherkinStep, but is: " + String.valueOf(element));
        }
        CucumberStepReference cucumberStepReference = CucumberUtil.getCucumberStepReference(element);
        if (cucumberStepReference != null && (abstractStepDef = cucumberStepReference.resolveToDefinition()) != null && (stepDefElement = abstractStepDef.getElement()) != null && (cucumberRegex = abstractStepDef.getCucumberRegex()) != null) {
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            CucumberUtil.findGherkinReferencesToElement(stepDefElement, cucumberRegex, (Processor<? super PsiReference>)((Processor)reference -> result.add((PsiReference)reference)), searchScope);
            return result;
        }
        return List.of();
    }

    @TestOnly
    public static List<String> prepareRegexAndGetStaticTexts(String regexText) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder preparedRegexp = new StringBuilder();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)regexText);
        IElementType previous = null;
        TokenSet toSkip = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.CHARACTER, RegExpTT.CARET, RegExpTT.DOLLAR, RegExpTT.REDUNDANT_ESCAPE});
        StringBuilder currentStaticText = new StringBuilder();
        boolean insideAddedGroup = false;
        Stack elementsWaitingToClose = new Stack();
        while (lexer.getTokenType() != null) {
            if (!toSkip.contains(lexer.getTokenType())) {
                if (!insideAddedGroup) {
                    insideAddedGroup = true;
                    preparedRegexp.append('(');
                    result.add(currentStaticText.toString());
                    currentStaticText = new StringBuilder();
                }
                if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN || lexer.getTokenType() == RegExpTT.NON_CAPT_GROUP) {
                    elementsWaitingToClose.push((Object)RegExpTT.GROUP_END);
                } else if (lexer.getTokenType() == RegExpTT.CLASS_BEGIN) {
                    elementsWaitingToClose.push((Object)RegExpTT.CLASS_END);
                } else if (!elementsWaitingToClose.isEmpty() && lexer.getTokenType() == elementsWaitingToClose.peek()) {
                    elementsWaitingToClose.pop();
                }
            } else if (elementsWaitingToClose.isEmpty()) {
                if (previous != null && previous != RegExpTT.CHARACTER && insideAddedGroup) {
                    insideAddedGroup = false;
                    preparedRegexp.append(')');
                }
                if (lexer.getTokenType() == RegExpTT.CHARACTER) {
                    currentStaticText.append(lexer.getTokenText());
                }
            }
            preparedRegexp.append(lexer.getTokenText());
            if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN) {
                preparedRegexp.append("?:");
            }
            previous = lexer.getTokenType();
            lexer.advance();
        }
        if (insideAddedGroup) {
            preparedRegexp.append(')');
        }
        result.add(currentStaticText.toString());
        result.addFirst(preparedRegexp.toString());
        return result;
    }

    @TestOnly
    public static String prepareRegexFromCukex(String cukex, ParameterTypeManager parameterTypeManager) {
        String preparedRegex = CucumberUtil.buildRegexpFromCucumberExpression(cukex, parameterTypeManager);
        return preparedRegex.substring(1).substring(0, preparedRegex.length() - 2);
    }

    @TestOnly
    public static List<String> getStaticTextsFromCukex(String cukex) {
        List<TextRange> ranges = CucumberUtil.getCukexRanges(cukex);
        return CucumberUtil.textRangesOutsideToSubstrings(cukex, ranges);
    }

    @TestOnly
    public static String getNewStepName(String oldStepName, Pattern oldStepDefPattern, List<String> newStaticTexts) {
        newStaticTexts = new ArrayList<String>(newStaticTexts);
        Matcher matcher = oldStepDefPattern.matcher(oldStepName);
        if (matcher.find()) {
            ArrayList<@Nullable String> concreteValues = new ArrayList<String>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String concreteValue = matcher.group(i + 1);
                concreteValues.add(concreteValue);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < concreteValues.size(); ++i) {
                String staticText = newStaticTexts.removeFirst();
                sb.append(staticText);
                String concreteValue = (String)concreteValues.get(i);
                if (concreteValue == null) continue;
                sb.append(concreteValue);
            }
            for (String staticText : newStaticTexts) {
                sb.append(staticText);
            }
            return sb.toString();
        }
        return oldStepName;
    }
}

