/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.run;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public final class CucumberRunLineMarkerContributor
extends RunLineMarkerContributor {
    private static final TokenSet RUN_LINE_MARKER_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.FEATURE_KEYWORD, GherkinTokenTypes.SCENARIO_KEYWORD, GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD, GherkinTokenTypes.RULE_KEYWORD, GherkinTokenTypes.EXAMPLE_KEYWORD});

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        if (element == null) {
            CucumberRunLineMarkerContributor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafElement)) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof GherkinFile)) {
            return null;
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)element);
        if (!RUN_LINE_MARKER_ELEMENTS.contains(type)) {
            return null;
        }
        TestStateStorage.Record state = CucumberRunLineMarkerContributor.getTestStateStorage(element);
        return CucumberRunLineMarkerContributor.getInfo(state);
    }

    @Nullable
    private static TestStateStorage.Record getTestStateStorage(@NotNull PsiElement element) {
        if (element == null) {
            CucumberRunLineMarkerContributor.$$$reportNull$$$0(1);
        }
        String url = element.getContainingFile().getVirtualFile().getUrl() + ":" + CucumberUtil.getLineNumber(element);
        return TestStateStorage.getInstance((Project)element.getProject()).getState(url);
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(@Nullable TestStateStorage.Record state) {
        return new RunLineMarkerContributor.Info(CucumberRunLineMarkerContributor.getTestStateIcon((TestStateStorage.Record)state, (boolean)true), ExecutorAction.getActions((int)0), RUN_TEST_TOOLTIP_PROVIDER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/cucumber/run/CucumberRunLineMarkerContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestStateStorage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

