/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public abstract class AbstractStepDefinition {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("(#\\{.+?})");
    private static final String CUCUMBER_START_PREFIX = "\\A";
    private static final String CUCUMBER_END_SUFFIX = "\\z";
    private static final int TIME_TO_CHECK_STEP_BY_REGEX_MILLIS = 300;
    private final SmartPsiElementPointer<PsiElement> elementPointer;
    @Nullable
    private volatile String regexText;
    @Nullable
    private volatile Pattern regexPattern;

    public AbstractStepDefinition(PsiElement element) {
        this.elementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    public abstract List<String> getVariableNames();

    public boolean matches(String stepName) {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            return false;
        }
        CharSequence stepChars = StringUtil.newBombedCharSequence((CharSequence)stepName, (long)300L);
        try {
            return pattern.matcher(stepChars).find();
        }
        catch (ProcessCanceledException ignore) {
            return false;
        }
    }

    @Nullable
    public PsiElement getElement() {
        return this.elementPointer.getElement();
    }

    @Nullable
    public PsiElement getNavigationElement() {
        return this.getElement();
    }

    @Nullable
    public Pattern getPattern() {
        try {
            String cucumberRegex = this.getCucumberRegex();
            if (cucumberRegex == null) {
                return null;
            }
            if (this.regexText == null || !cucumberRegex.equals(this.regexText)) {
                StringBuilder patternText = new StringBuilder(ESCAPE_PATTERN.matcher(cucumberRegex).replaceAll("(.*)"));
                if (patternText.toString().startsWith(CUCUMBER_START_PREFIX)) {
                    patternText.replace(0, CUCUMBER_START_PREFIX.length(), "^");
                }
                if (patternText.toString().endsWith(CUCUMBER_END_SUFFIX)) {
                    patternText.replace(patternText.length() - CUCUMBER_END_SUFFIX.length(), patternText.length(), "$");
                }
                this.regexPattern = Pattern.compile(patternText.toString(), this.isCaseSensitive() ? 0 : 2);
                this.regexText = cucumberRegex;
            }
            return this.regexPattern;
        }
        catch (PatternSyntaxException ignored) {
            return null;
        }
    }

    @Nullable
    public String getCucumberRegex() {
        return this.getExpression();
    }

    @Contract(value="null -> null")
    @Nullable
    protected abstract String getCucumberRegexFromElement(@Nullable PsiElement var1);

    protected boolean isCaseSensitive() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStepDefinition that = (AbstractStepDefinition)o;
        return this.elementPointer.equals(that.elementPointer);
    }

    public int hashCode() {
        return this.elementPointer.hashCode();
    }

    public void setValue(String newValue) {
    }

    public boolean supportsStep(PsiElement step) {
        return true;
    }

    public boolean supportsRename(@Nullable String newName) {
        return true;
    }

    @Nullable
    public String getExpression() {
        return this.getCucumberRegexFromElement(this.getElement());
    }
}

