/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

@NotNullByDefault
public class CucumberStepReference
implements PsiPolyVariantReference {
    private final PsiElement step;
    private final TextRange range;

    public CucumberStepReference(PsiElement step, TextRange range) {
        this.step = step;
        this.range = range;
    }

    public PsiElement getElement() {
        return this.step;
    }

    public TextRange getRangeInElement() {
        return this.range;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] result = this.multiResolve(true);
        return result.length == 1 ? result[0].getElement() : null;
    }

    public String getCanonicalText() {
        return this.step.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.step;
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        return this.step;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] resolvedResults;
        for (ResolveResult rr : resolvedResults = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(rr.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Project project = this.getElement().getProject();
        return ResolveCache.getInstance((Project)project).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)MyResolver.INSTANCE, false, incompleteCode);
    }

    private ResolveResult[] multiResolveInner() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.step);
        if (module == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        List extensionPoints = CucumberJvmExtensionPoint.EP_NAME.getExtensionList();
        HashSet<String> stepVariants = new HashSet<String>();
        for (CucumberJvmExtensionPoint ep : extensionPoints) {
            String stepName = ep.getStepName(this.step);
            if (stepName == null) continue;
            stepVariants.add(stepName);
        }
        if (stepVariants.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        List<AbstractStepDefinition> stepDefinitions = CucumberStepHelper.loadStepsFor(this.step.getContainingFile(), module);
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        block1: for (AbstractStepDefinition stepDefinition : stepDefinitions) {
            if (!stepDefinition.supportsStep(this.step)) continue;
            for (String stepVariant : stepVariants) {
                PsiElement element = stepDefinition.getElement();
                if (!stepDefinition.matches(stepVariant) || element == null || resolvedElements.contains(element)) continue;
                resolvedElements.add(element);
                continue block1;
            }
        }
        return (ResolveResult[])resolvedElements.stream().map(PsiElementResolveResult::new).toArray(ResolveResult[]::new);
    }

    @Nullable
    public AbstractStepDefinition resolveToDefinition() {
        Collection<AbstractStepDefinition> definitions = this.resolveToDefinitions();
        return definitions.isEmpty() ? null : definitions.iterator().next();
    }

    public Collection<AbstractStepDefinition> resolveToDefinitions() {
        return CucumberStepHelper.findStepDefinitions(this.step.getContainingFile(), (GherkinStep)this.step);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<CucumberStepReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        public ResolveResult[] resolve(CucumberStepReference ref, boolean incompleteCode) {
            return ref.multiResolveInner();
        }
    }
}

