/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BasicElementActionFun;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0002H$\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015H\u0014J\u001c\u0010\u0017\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015H\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015H$R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/actions/BasicElementAction;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "expandGroupItems", "", "getExpandGroupItems", "()Z", "cast", "node", "(Lcom/intellij/database/model/basic/BasicNode;)Lcom/intellij/database/model/basic/BasicNode;", "check", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "actionPerformed", "doIt", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
public abstract class BasicElementAction<N extends BasicNode>
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean visible = false;
        boolean enabled = false;
        try {
            MultiMap selection = new MultiMap();
            boolean ok2 = true;
            JBIterable<BasicNode> nodes = BasicElementActionFun.iterateActionNodes(e, this.getExpandGroupItems());
            for (BasicNode node : nodes) {
                Intrinsics.checkNotNull((Object)node);
                N obj = this.cast(node);
                if (obj == null) {
                    ok2 = false;
                    break;
                }
                selection.putValue((Object)obj.getModel(), obj);
            }
            visible = ok2 && !selection.isEmpty() && this.check(selection);
            enabled = visible && this.enabled(selection);
        }
        finally {
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(enabled);
        }
    }

    protected boolean getExpandGroupItems() {
        return true;
    }

    @Nullable
    protected abstract N cast(@NotNull BasicNode var1);

    protected boolean check(@NotNull MultiMap<BasicModel, N> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        return true;
    }

    protected boolean enabled(@NotNull MultiMap<BasicModel, N> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        MultiMap selection = new MultiMap();
        JBIterable<BasicNode> nodes = BasicElementActionFun.iterateActionNodes(e, this.getExpandGroupItems());
        for (BasicNode node : nodes) {
            Intrinsics.checkNotNull((Object)node);
            N obj = this.cast(node);
            if (obj == null) continue;
            BasicModel model = obj.getModel();
            selection.putValue((Object)model, obj);
        }
        if (selection.isEmpty()) {
            return;
        }
        this.doIt(e, project2, selection);
    }

    protected abstract void doIt(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull MultiMap<BasicModel, N> var3);
}

