/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.notifications;

import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.ExternalFeedbackSurveyConfig;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ClockKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/notifications/DataGripUxFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/ExternalFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "firstDayOfFeedbackCollection", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "updateStateAfterNotificationShowed", "", "updateStateAfterRespondActionInvoked", "getUrlToSurvey", "getRespondNotificationActionLabel", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "checkIsFeedbackCollectionStarted", "intellij.database.impl"})
public final class DataGripUxFeedbackSurveyConfig
implements ExternalFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 5, 31);
    @NotNull
    private final LocalDate firstDayOfFeedbackCollection = new LocalDate(2025, 5, 12);
    private final boolean requireIdeEAP;

    public DataGripUxFeedbackSurveyConfig() {
        this.surveyId = "data_grip_ux_survey_config_may_2025";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isDataGrip();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PlatformUtils.isDataGrip() && this.checkIsFeedbackCollectionStarted();
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public void updateStateAfterRespondActionInvoked(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String getUrlToSurvey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DatabaseBundle.message((String)"feedback.survey.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getRespondNotificationActionLabel() {
        String string = DatabaseBundle.message((String)"feedback.survey.url.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DatabaseBundle.message((String)"feedback.survey.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"feedback.survey.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, string2);
    }

    private final boolean checkIsFeedbackCollectionStarted() {
        return ClockKt.todayIn((Clock)((Clock)Clock.System.INSTANCE), (TimeZone)TimeZone.Companion.currentSystemDefault()).compareTo(this.firstDayOfFeedbackCollection) >= 0;
    }
}

