/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementUsageBase;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DbElementUsage
extends DbElementUsageBase<DbElement> {
    private final DbElement myNavigateTo;

    public DbElementUsage(@NotNull String text, @NotNull DbElement element) {
        if (text == null) {
            DbElementUsage.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DbElementUsage.$$$reportNull$$$0(1);
        }
        super(text, element);
        this.myNavigateTo = element;
    }

    private DbElementUsage(@NotNull String text, @NotNull DbElement element, @NotNull DbElement navigateTo2, TextChunk @NotNull [] chunks) {
        if (text == null) {
            DbElementUsage.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DbElementUsage.$$$reportNull$$$0(3);
        }
        if (navigateTo2 == null) {
            DbElementUsage.$$$reportNull$$$0(4);
        }
        if (chunks == null) {
            DbElementUsage.$$$reportNull$$$0(5);
        }
        super(text, element, chunks);
        this.myNavigateTo = navigateTo2;
    }

    public static DbElementUsage create(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        DbElement navigateTo2;
        String text;
        if (o == null) {
            DbElementUsage.$$$reportNull$$$0(6);
        }
        if (resolveTo == null) {
            DbElementUsage.$$$reportNull$$$0(7);
        }
        TextAttributes emptyAttrs = new TextAttributes();
        TextAttributes boldAttrs = new TextAttributes(null, null, null, null, 1);
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)DbSqlUtilCore.getSqlDialect((DbElement)o), (Project)o.getProject(), null);
        Lexer lexer = highlighter.getHighlightingLexer();
        String definition = DatabaseDefinitionHelper.generateDefinition((DbElement)o, (StringBuilder)new StringBuilder()).toString();
        lexer.start((CharSequence)definition);
        EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        String name = resolveTo.getName();
        while (lexer.getTokenType() != null) {
            IElementType type = lexer.getTokenType();
            TextAttributesKey[] keys = highlighter.getTokenHighlights(type);
            TextAttributes attributes = name.equalsIgnoreCase(lexer.getTokenText()) ? boldAttrs : (keys.length > 0 ? scheme.getAttributes(keys[0]) : emptyAttrs);
            chunks.add(new TextChunk(attributes, lexer.getTokenText()));
            lexer.advance();
        }
        if (StringUtil.isNotEmpty((String)definition)) {
            text = definition;
        } else {
            text = DbPresentationCore.getPresentableName((DasObject)o, (boolean)true);
            chunks.add(new TextChunk(emptyAttrs, text));
        }
        if (o instanceof DbForeignKey) {
            DasTypedObject keyColumn = (DasTypedObject)Iterables.getFirst((Iterable)((DbForeignKey)o).getRefColumns().resolveObjects(), null);
            DbElement dbElement = navigateTo2 = keyColumn instanceof DbElement ? (DbElement)keyColumn : o.getParent();
            if (navigateTo2 == null) {
                throw new AssertionError((Object)"Unable to find element to navigate");
            }
        } else {
            navigateTo2 = o;
        }
        chunks.add(new TextChunk(SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), " (" + QNameUtil.getQualifiedName((DbElement)o.getParent()) + ")"));
        return new DbElementUsage(text, o, navigateTo2, chunks.toArray(TextChunk.EMPTY_ARRAY));
    }

    @Override
    protected DbElement getNavigateElement() {
        return this.myNavigateTo;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myNavigateTo.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateTo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbElementUsage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

