/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProviderUi;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisherUi;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleDataRequestUi;
import com.intellij.database.util.AsyncTaskKt;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.Consumer;
import com.intellij.util.net.ssl.CertificateManager;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 I2\u00020\u0001:\u0001IB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J=\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u000b\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0016J \u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010#\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0017H\u0016J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J0\u0010-\u001a\u00020\u00052\u0006\u0010#\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0016\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u000102\u0018\u00010101H\u0016J\u0012\u00103\u001a\u00020\u001f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J%\u00107\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u00108\u001a\u00070\u001f\u00a2\u0006\u0002\b92\u0006\u0010:\u001a\u00020;H\u0016J-\u00107\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u001d2\u000b\u00108\u001a\u00070\u001f\u00a2\u0006\u0002\b92\u0006\u0010=\u001a\u00020>H\u0016J3\u0010?\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u001d2\u000b\u00108\u001a\u00070\u001f\u00a2\u0006\u0002\b92\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0016J-\u0010?\u001a\u00020\u00172\u000b\u00108\u001a\u00070\u001f\u00a2\u0006\u0002\b92\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020CH\u0016J\u0014\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u0019H\u0016J?\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010G\u001a\u0002052\r\u0010\u001e\u001a\t\u0018\u00010\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010H\u00a8\u0006J"}, d2={"Lcom/intellij/database/view/DatabaseUiServiceImpl;", "Lcom/intellij/database/view/DatabaseUiService;", "<init>", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "fix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "editor", "Lcom/intellij/database/view/ui/DatabaseConfigEditor;", "reportError", "Lcom/intellij/database/datagrid/DataRequest$CoupledWithEditor$ErrorNavigator;", "request", "Lcom/intellij/database/run/ConsoleDataRequest;", "errorInfo", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "reportWarning", "info", "Lcom/intellij/database/console/JdbcEngineUtils$EngineWarningExceptionInfo;", "updateConsoleUI", "scrollToQuery", "", "askSshCredentials", "Lkotlin/Pair;", "Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;", "Lcom/intellij/ssh/ui/unified/SshUiData;", "source", "Lcom/intellij/database/dataSource/LocalDataSource;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "error", "navigateToSource", "element", "Lcom/intellij/database/psi/DbElement;", "requestFocus", "selectInDatabaseView", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "Lcom/intellij/psi/PsiElement;", "reloadIfNeeded", "file", "Lcom/intellij/database/vfs/DatabaseElementSourceVirtualFileImpl;", "updateQuickDocAsync", "prefix", "", "provider", "Lcom/intellij/util/Consumer;", "", "askChangePassword", "newOneTimeInstance", "Lcom/intellij/database/access/DatabaseCredentials;", "credentials", "confirmAndRunSync", "actionName", "Lorg/jetbrains/annotations/Nls;", "sync", "Ljava/lang/Runnable;", "dataSource", "recommendation", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "askIfAbort", "tasks", "", "Lcom/intellij/database/introspection/IntrospectionTask;", "Lcom/intellij/database/model/basic/BasicElement;", "getIdeStoreParams", "askSslCredentials", "Lcom/intellij/credentialStore/OneTimeString;", "dc", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.impl"})
public final class DatabaseUiServiceImpl
extends DatabaseUiService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void applyFix(@NotNull Project project, @NotNull ErrorInfo.Fix fix, @Nullable DatabaseConfigEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        DataSourceUiUtil.applyFix(project, fix, editor2);
    }

    @NotNull
    public DataRequest.CoupledWithEditor.ErrorNavigator reportError(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
        DataRequest.CoupledWithEditor.ErrorNavigator errorNavigator = new ConsoleDataRequestUi(request).reportError(errorInfo);
        Intrinsics.checkNotNullExpressionValue((Object)errorNavigator, (String)"reportError(...)");
        return errorNavigator;
    }

    public void reportWarning(@NotNull ConsoleDataRequest request, @NotNull JdbcEngineUtils.EngineWarningExceptionInfo info2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        new ConsoleDataRequestUi(request).reportWarning(info2);
    }

    public void updateConsoleUI(@Nullable ConsoleDataRequest request, boolean scrollToQuery) {
        new ConsoleDataRequestUi(request).updateConsoleUI(scrollToQuery);
    }

    @Nullable
    public Pair<DataSourceSshTunnelConfiguration, SshUiData> askSshCredentials(@NotNull Project project, @NotNull LocalDataSource source, @NotNull String message, boolean error) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return DatabaseSshTunnelEstablisherUi.askSshCredentials(project, source, message, error);
    }

    public void navigateToSource(@NotNull DbElement element, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DbNavigationUtils.navigateToSource(element, requestFocus);
    }

    @NotNull
    public Promise<Void> selectInDatabaseView(@NotNull PsiElement element, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Promise<Void> promise = DatabaseView.select(element, requestFocus);
        Intrinsics.checkNotNullExpressionValue(promise, (String)"select(...)");
        return promise;
    }

    public void reloadIfNeeded(@NotNull Project project, @Nullable DatabaseElementSourceVirtualFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DatabaseEditorHelper.reloadIfNeeded(project, file);
    }

    public void updateQuickDocAsync(@NotNull PsiElement element, @NotNull CharSequence prefix, @NotNull Consumer<Consumer<Object>> provider) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        QuickDocUtil.updateQuickDocAsync((PsiElement)element, (CharSequence)prefix, provider);
    }

    @NotNull
    public String askChangePassword(@Nullable Project project) {
        String string = DatabaseCredentialsAuthProviderUi.askChangePassword(project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"askChangePassword(...)");
        return string;
    }

    @NotNull
    public DatabaseCredentials newOneTimeInstance(@NotNull DatabaseCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        DatabaseCredentials databaseCredentials = DatabaseCredentialsUi.newOneTimeInstance(credentials);
        Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"newOneTimeInstance(...)");
        return databaseCredentials;
    }

    public boolean confirmAndRunSync(@NotNull Project project, @NotNull String actionName, @NotNull Runnable sync) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
        String string = DatabaseBundle.message((String)"button.abort.increase.introspection.level.AbortAndIntrospect", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String whatToDoText = string;
        return DatabaseUiServiceImpl.Companion.confirmTextAndRunSync(project, actionName, whatToDoText, sync);
    }

    public boolean confirmAndRunSync(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String actionName, @NotNull LevelAnalyzer.Recommendation recommendation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)recommendation, (String)"recommendation");
        Object[] objectArray = new Object[]{recommendation.getTitle()};
        String string = DatabaseBundle.message((String)"button.abort.increase.introspection.level.AbortAndWhatIsRecommended", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String whatToDoText = string;
        return DatabaseUiServiceImpl.Companion.confirmTextAndRunSync(project, actionName, whatToDoText, () -> DatabaseUiServiceImpl.confirmAndRunSync$lambda$0(project, dataSource, recommendation));
    }

    public boolean askIfAbort(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String actionName, @NotNull List<? extends IntrospectionTask> tasks) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        return this.confirmAndRunSync(project, actionName, () -> DatabaseUiServiceImpl.askIfAbort$lambda$0(project, dataSource, tasks));
    }

    public boolean askIfAbort(@NotNull String actionName, @NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.confirmAndRunSync(project, actionName, () -> DatabaseUiServiceImpl.askIfAbort$lambda$1(project, dataSource, element));
    }

    @NotNull
    public Pair<String, String> getIdeStoreParams() {
        return new Pair((Object)CertificateManager.DEFAULT_PATH, (Object)"changeit");
    }

    @Nullable
    public Object askSslCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials dc, @Nullable String message, boolean error, @NotNull Continuation<? super OneTimeString> $completion) {
        if (project.isDefault()) {
            throw new CancellationException("default project");
        }
        OneTimeString c1 = dc.getSslPassphrase((DasDataSource)dataSource);
        String string = DatabaseBundle.message((String)"progress.title.re.ask.credentials", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return AsyncTaskKt.traceableFrame((String)string, (Function1)((Function1)new Function1<Continuation<? super OneTimeString>, Object>(dc, dataSource, c1, project, error, message, null){
            int label;
            final /* synthetic */ DatabaseCredentials $dc;
            final /* synthetic */ LocalDataSource $dataSource;
            final /* synthetic */ OneTimeString $c1;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $error;
            final /* synthetic */ String $message;
            {
                this.$dc = $dc;
                this.$dataSource = $dataSource;
                this.$c1 = $c1;
                this.$project = $project;
                this.$error = $error;
                this.$message = $message;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(this.$dc, this.$dataSource, this.$c1, this.$project, this.$error, this.$message, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ DatabaseCredentials $dc;
                            final /* synthetic */ LocalDataSource $dataSource;
                            final /* synthetic */ OneTimeString $c1;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ boolean $error;
                            final /* synthetic */ String $message;
                            {
                                this.$dc = $dc;
                                this.$dataSource = $dataSource;
                                this.$c1 = $c1;
                                this.$project = $project;
                                this.$error = $error;
                                this.$message = $message;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        OneTimeString c2 = this.$dc.getSslPassphrase((DasDataSource)this.$dataSource);
                                        if (Intrinsics.areEqual((Object)this.$c1, (Object)c2)) {
                                            boolean ok2;
                                            DataSourceSshSslPanel.SslPassphraseComponent component = new DataSourceSshSslPanel.SslPassphraseComponent(this.$dc, this.$dataSource);
                                            component.reset(this.$dataSource.getSslCfg(), c2 == null);
                                            Icon icon = (this.$error ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon();
                                            JComponent jComponent = component;
                                            Object[] objectArray = new Object[]{this.$dataSource.getName()};
                                            String string = DatabaseBundle.message((String)"dialog.title.connecting.to", (Object[])objectArray);
                                            String string2 = this.$message;
                                            if (string2 == null) {
                                                string2 = "";
                                            }
                                            DialogBuilder dialogBuilder = DatabaseCredentialsUi.prepareDialog(this.$project, icon, jComponent, string, string2);
                                            Intrinsics.checkNotNullExpressionValue((Object)dialogBuilder, (String)"prepareDialog(...)");
                                            DialogBuilder builder = dialogBuilder;
                                            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
                                            boolean bl = ok2 = builder.show() == 0;
                                            if (!ok2) {
                                                throw new ProcessCanceledException();
                                            }
                                            DataSourceSslConfiguration cfg = this.$dataSource.getSslCfg();
                                            if (cfg != null) {
                                                component.save(this.$dataSource, cfg, true);
                                            }
                                        }
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)c2);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(this.$dc, this.$dataSource, null){
                                            int label;
                                            final /* synthetic */ DatabaseCredentials $dc;
                                            final /* synthetic */ LocalDataSource $dataSource;
                                            {
                                                this.$dc = $dc;
                                                this.$dataSource = $dataSource;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        return this.$dc.getSslPassphrase((DasDataSource)this.$dataSource);
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super OneTimeString> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        OneTimeString c2 = (OneTimeString)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super OneTimeString> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super OneTimeString> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final void confirmAndRunSync$lambda$0(Project $project, LocalDataSource $dataSource, LevelAnalyzer.Recommendation $recommendation) {
        RunIntrospection.runAsyncIntrospection((Project)$project, (LocalDataSource)$dataSource, (List)$recommendation.tasks);
    }

    private static final void askIfAbort$lambda$0(Project $project, LocalDataSource $dataSource, List $tasks) {
        RunIntrospection.runAsyncIntrospection((Project)$project, (LocalDataSource)$dataSource, (List)$tasks);
    }

    private static final void askIfAbort$lambda$1(Project $project, LocalDataSource $dataSource, BasicElement $element) {
        RefreshActionsLogic.refreshToComplete($project, $dataSource, SetsKt.setOf((Object)$element));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/DatabaseUiServiceImpl$Companion;", "", "<init>", "()V", "confirmTextAndRunSync", "", "project", "Lcom/intellij/openapi/project/Project;", "actionName", "", "Lorg/jetbrains/annotations/Nls;", "whatToDoText", "sync", "Ljava/lang/Runnable;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean confirmTextAndRunSync(Project project, String actionName, String whatToDoText, Runnable sync) {
            Object[] objectArray = new Object[]{StringUtil.trimEnd((String)actionName, (String)"\u2026")};
            String string = DatabaseBundle.message((String)"dialog.title.low.introspection.level", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String string2 = DatabaseBundle.message((String)"notification.content.results.might.be.wrong.due.to.low.level", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String questionText = string2;
            MessageDialogBuilder.YesNoCancel yesNoCancel = (MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(title, questionText).yesText(whatToDoText);
            String string3 = DatabaseBundle.message((String)"button.force.continue", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            int result2 = ((MessageDialogBuilder.YesNoCancel)yesNoCancel.noText(string3)).show(project);
            if (result2 == 1) {
                return false;
            }
            if (result2 == 0) {
                sync.run();
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

