/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.structure.DbTreeNodeDecoration;
import com.intellij.database.explorer.structure.DvDsGroup;
import com.intellij.database.explorer.structure.DvErsatzFamilyNode;
import com.intellij.database.explorer.structure.DvHostNode;
import com.intellij.database.explorer.structure.DvTreeFilesLayer;
import com.intellij.database.explorer.structure.DvTreeImplantingLayer;
import com.intellij.database.explorer.structure.DvTreeLayoutLayer;
import com.intellij.database.explorer.structure.DvTreeStructure;
import com.intellij.database.explorer.structure.DvViewOptions;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.AsyncCachedValue;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbActiveConnectionInfoProvider;
import com.intellij.database.view.DbActiveConnectionInfoProviders;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DbNodeDescriptorHelper;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbNodeDescriptor {
    public static final SimpleTextAttributes INACTIVE_LINK_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.derive(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.getStyle() | 0x200, null, null, null);
    public static final SimpleTextAttributes ACTIVE_LINK_ATTRS = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400, UIUtil.getLabelForeground(), null, null);
    public static final Logger ourLogger = Logger.getInstance(DbNodeDescriptor.class);
    static final int nodeNameLimit = 80;
    static final String spaceDelimiter = "\u2002";

    public static void updatePresentation(@NotNull PresentationData presentation, @NotNull BasicNode node, @NotNull Project project, @NotNull DvViewOptions viewOptions, @NotNull DvTreeStructure treeStructure, @Nullable BasicNode componentUnderMouse, boolean showCount, boolean appendNamespaceChooserLink) {
        BasicElement element;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(3);
        }
        if (treeStructure == null) {
            DbNodeDescriptor.$$$reportNull$$$0(4);
        }
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        MiniContext mc = new MiniContext();
        @Nullable BasicModel model = node.getModel();
        @NotNull Dbms dbms = model != null ? model.getDbms() : Dbms.UNKNOWN;
        boolean supportsMultilevelIntrospection = DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)dbms);
        @Nullable RawDataSource dataSource = DbNodeDescriptorHelper.getDataSourceForTopNode(node);
        Icon nodeIcon = DbNodeDescriptorHelper.getNodeIcon(project, node);
        presentation.setIcon(nodeIcon);
        DbTreeNodeDecoration decoration = treeStructure.decorationOf(node);
        if (decoration == null) {
            decoration = DbTreeNodeDecoration.PLAIN;
        }
        String nodeText = DbNodeDescriptorHelper.getNodePrimaryText(node, treeStructure);
        DbNodeDescriptor.setNodePrimaryText(presentation, project, viewOptions, node, nodeText, decoration, dataSource);
        DbNodeDescriptorHelper.decorateNode(presentation, node, decoration, viewOptions);
        if (node instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)node;
            DbNodeDescriptor.updatePresentationForDataSource(presentation, dsn, project, mc, viewOptions, componentUnderMouse, appendNamespaceChooserLink);
            if (viewOptions.getWithIntrospectionLevels() && supportsMultilevelIntrospection) {
                DbNodeDescriptorHelper.addLevelIcon(presentation, dsn);
            }
        } else if (node instanceof BasicMultiLevelIntrospectableArea) {
            BasicMultiLevelIntrospectableArea area = (BasicMultiLevelIntrospectableArea)node;
            if (viewOptions.getWithIntrospectionLevels() && supportsMultilevelIntrospection) {
                DbNodeDescriptorHelper.addLevelIcon(presentation, area, dataSource);
            }
        } else if (node instanceof BasicMultiLevelObject) {
            BasicMultiLevelObject mlObject = (BasicMultiLevelObject)node;
            if (viewOptions.getWithDetailLevels() && supportsMultilevelIntrospection && mlObject.getMaxDetailsLevel().level > Level.L1.level) {
                DbNodeDescriptorHelper.addDetailsLevelIcon(presentation, mlObject.getEffectiveDetailsLevel());
            }
        } else if (node instanceof DvTreeLayoutLayer.EmptyScopeLeaf) {
            DvTreeLayoutLayer.EmptyScopeLeaf leaf = (DvTreeLayoutLayer.EmptyScopeLeaf)node;
            DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, mc, componentUnderMouse);
        } else if (node instanceof DvTreeImplantingLayer.ImplantedNode) {
            DvTreeImplantingLayer.ImplantedNode implantedNode = (DvTreeImplantingLayer.ImplantedNode)node;
            implantedNode.updatePresentation(project, presentation, treeStructure, viewOptions);
        }
        if (node instanceof BasicNamespaceOwner && appendNamespaceChooserLink) {
            boolean activate = node == componentUnderMouse;
            DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, (BasicNamespaceOwner)node, project, mc, activate);
        }
        if (node instanceof DvTreeFilesLayer.QueryFile) {
            DvTreeFilesLayer.QueryFile queryFile = (DvTreeFilesLayer.QueryFile)node;
            presentation.addText(queryFile.getDisplayPath(), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        }
        if (showCount && !mc.countShown) {
            DbNodeDescriptor.showCount(presentation, node, treeStructure, mc, viewOptions);
        }
        if (node instanceof BasicElement) {
            element = (BasicElement)node;
            LinkedDataSourceHelper helper = LinkedDataSourceHelper.of((Dbms)dbms);
            if (helper != null && element.getKind() == helper.getLinkedDataSourceKind() && DbNodeDescriptor.updateLinkObjectPresentation(presentation, element, treeStructure)) {
                return;
            }
        }
        if (node instanceof BasicElement) {
            element = (BasicElement)node;
            DescriptionService descriptionService = ModelFacade.forDbms((Dbms)dbms).getDescriptionService();
            DbNodeDescriptor.updatePresentationAdditions(presentation, element, project, descriptionService, viewOptions);
        }
    }

    private static boolean updateLinkObjectPresentation(@NotNull PresentationData presentation, @NotNull BasicElement element, @NotNull DvTreeStructure treeStructure) {
        RawDataSource ds;
        LocalDataSource dsLocal;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(5);
        }
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(6);
        }
        if (treeStructure == null) {
            DbNodeDescriptor.$$$reportNull$$$0(7);
        }
        if ((dsLocal = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)(ds = treeStructure.getContext().modelRegistry.getDataSource(element)))) == null) {
            return false;
        }
        ObjectPath path = ObjectPaths.of((DasObject)element);
        String linkedId = (String)dsLocal.getLinkedDataSourceIds().get(path);
        Project project = treeStructure.getContext().project;
        DbDataSource dsLinked = DbPsiFacade.getInstance((Project)project).findDataSource(linkedId);
        if (dsLinked == null) {
            return false;
        }
        presentation.addText(DbPresentation.arrow() + " " + dsLinked.getName(), DbPresentation.BOLD_INFO_ATTRS);
        return true;
    }

    private static void updatePresentationAdditions(@NotNull PresentationData presentation, @NotNull BasicElement element, @NotNull Project project, @NotNull DescriptionService descriptionService, @NotNull DvViewOptions viewOptions) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(8);
        }
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(10);
        }
        if (descriptionService == null) {
            DbNodeDescriptor.$$$reportNull$$$0(11);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(12);
        }
        DbNodeDescriptor.updatePresentationAdditions(project, presentation, element, descriptionService, viewOptions);
    }

    public static void updatePresentationAdditions(@NotNull Project project, @NotNull PresentationData presentation, @NotNull BasicElement element, @NotNull DescriptionService descriptionService, @NotNull DvViewOptions viewOptions) {
        boolean commentsMode;
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(13);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(14);
        }
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(15);
        }
        if (descriptionService == null) {
            DbNodeDescriptor.$$$reportNull$$$0(16);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(17);
        }
        boolean detailsMode = !(commentsMode = viewOptions.getWithCommentsNotDetails());
        String comment = DbNodeDescriptor.adjustCommentString(element.getComment());
        boolean hasComment = StringUtil.isNotEmpty((String)comment);
        if (detailsMode) {
            descriptionService.updatePresentation(project, (DasObject)element, viewOptions, presentation);
        } else {
            DbNodeDescriptor.addSpaceDelimiter(presentation);
            presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        if (hasComment) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
        }
    }

    public static void updatePresentationForDataSource(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull Project project, @NotNull MiniContext mc, @NotNull DvViewOptions viewOptions, @Nullable BasicNode componentUnderMouse, boolean appendNamespaceChooserLink) {
        boolean activate;
        LocalDataSource localDs;
        DbActiveConnectionInfoProvider.ConnectionInfo info2;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(18);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(19);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(20);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(21);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(22);
        }
        if (project.isDisposed()) {
            return;
        }
        RawDataSource rawDataSource = dsn.dataSource;
        if (rawDataSource instanceof LocalDataSource && (info2 = DbActiveConnectionInfoProviders.getActiveConnectionInfo(localDs = (LocalDataSource)rawDataSource, project)) != null) {
            DbNodeDescriptor.addTooltip(presentation, false, info2.tooltip);
        }
        boolean commentsMode = viewOptions.getWithCommentsNotDetails();
        String comment = DbNodeDescriptor.adjustCommentString(dsn.dataSource.getComment());
        boolean bl = activate = dsn == componentUnderMouse;
        if (appendNamespaceChooserLink) {
            DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, dsn, mc, activate);
        }
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    private static void setNodePrimaryText(@NotNull PresentationData presentation, @NotNull Project project, @NotNull DvViewOptions viewOptions, @NotNull BasicNode node, @NotNull @Nls String nodeText, @NotNull DbTreeNodeDecoration decoration, @Nullable RawDataSource dataSource) {
        String theText;
        BasicMinorObject minorObj;
        BasicModel model;
        Dbms dbms;
        DescriptionService service;
        String schemaName;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(23);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(24);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(25);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(26);
        }
        if (nodeText == null) {
            DbNodeDescriptor.$$$reportNull$$$0(27);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(28);
        }
        if (node instanceof BasicMinorObject && (schemaName = (service = ModelFacade.forDbms((Dbms)(dbms = (model = (minorObj = (BasicMinorObject)node).getModel()) != null ? model.getDbms() : Dbms.UNKNOWN)).getDescriptionService()).getMinorObjectSchemaName(minorObj)) != null) {
            String schemaString = "(" + schemaName + ".)\u2009";
            presentation.addText(schemaString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        String string = theText = StringUtil.isEmpty((String)nodeText) ? DbPresentation.UNNAMED : nodeText;
        if (theText.length() > 80) {
            theText = StringUtil.shortenTextWithEllipsis((String)theText, (int)80, (int)10, (boolean)true);
        }
        presentation.setPresentableText(theText);
        SimpleTextAttributes style = DbNodeDescriptor.handleStatuses(project, presentation, node, dataSource, decoration, viewOptions);
        boolean decorateForestBold = viewOptions.getDecorateForestBold();
        if (node instanceof DvFolder || node instanceof DvDsGroup) {
            if (decorateForestBold) {
                style = new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
        } else if (node instanceof DataSourceNode) {
            if (decorateForestBold) {
                SimpleTextAttributes bold = new SimpleTextAttributes(1, style.getFgColor());
                style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)bold);
            }
        } else if (node instanceof DasObject) {
            style = DbNodeDescriptor.handleModified(project, (DasObject)node, style);
        }
        presentation.addText(theText, style);
        DbNodeDescriptor.addSpaceDelimiter(presentation);
    }

    public static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull DvTreeLayoutLayer.EmptyScopeLeaf leaf, @NotNull MiniContext mc, @Nullable BasicNode componentUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(29);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(30);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(31);
        }
        ObjectKind leafKind = leaf.getLeafKind();
        DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, leafKind, mc, componentUnderMouse);
    }

    private static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull Object leaf, @NotNull ObjectKind leafKind, @NotNull MiniContext mc, @Nullable BasicNode componentUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(32);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(33);
        }
        if (leafKind == null) {
            DbNodeDescriptor.$$$reportNull$$$0(34);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(35);
        }
        presentation.clear();
        presentation.addText(DatabaseBundle.message((String)"label.no.schemas.selected", (Object[])new Object[]{leafKind.getPluralPresentableName()}), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        presentation.addText("  ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        boolean activate = leaf == componentUnderMouse;
        DbNodeDescriptor.appendNamespaceChooserLinkWithoutCounters(presentation, mc, activate);
    }

    private static SimpleTextAttributes handleModified(Project project, DasObject element, SimpleTextAttributes style) {
        BasicSourceAware sa = (BasicSourceAware)ObjectUtils.tryCast((Object)element, BasicSourceAware.class);
        DbDataSource dataSource = sa == null ? null : ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource((BasicElement)sa);
        VirtualFile file = dataSource == null ? null : DbSrcUtils.findDbSrcFile((DbDataSource)dataSource, (DasObject)sa, (boolean)false);
        FileStatus status = file == null ? null : DbSrcChangesTracker.getFileStatuses().getStatus(file).getStatus();
        return status == null ? style : style.derive(-1, status.getColor(), null, null);
    }

    @NotNull
    public static String adjustCommentString(@Nullable String comment) {
        String string = comment == null ? "" : StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull BasicNamespaceOwner namespaceOwner, @NotNull Project project, @NotNull MiniContext mc, boolean activate) {
        Couple<Integer> counters;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(37);
        }
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(38);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(39);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(40);
        }
        if ((counters = DbNodeDescriptor.countNamespaces(namespaceOwner, project)) == null) {
            return;
        }
        DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, counters, mc, activate);
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull MiniContext mc, boolean activate) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(41);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(42);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(43);
        }
        BasicRoot root = dsn.getModelRoot();
        LocalDataSource ds = dsn.getLocalDataSource();
        if (root == null || ds == null) {
            return;
        }
        Couple<Integer> counters = DbNodeDescriptor.countNamespaces((BasicNamespaceOwner)root, ds);
        DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, counters, mc, activate);
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull Couple<Integer> counters, @NotNull MiniContext mc, boolean activate) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(44);
        }
        if (counters == null) {
            DbNodeDescriptor.$$$reportNull$$$0(45);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(46);
        }
        int enabled = (Integer)counters.first;
        int total = (Integer)counters.second;
        String text = enabled == 0 && total == 0 ? "  ...  " : (enabled != total ? " " + DatabaseBundle.message((String)"namespace.fraction", (Object[])new Object[]{enabled, total}) + " " : " " + enabled + " ");
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, text);
        mc.countShown = true;
    }

    private static void appendNamespaceChooserLinkWithoutCounters(PresentationData presentation, @NotNull MiniContext mc, boolean activate) {
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(47);
        }
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, "  ...  ");
        mc.countShown = true;
    }

    private static void appendNamespaceChooserLink(PresentationData presentation, boolean activate, @NlsContexts.Label String text) {
        presentation.addText(text, activate ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS);
    }

    @Nullable
    private static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull Project project) {
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(48);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(49);
        }
        BasicModelRegistry registry = BasicModelRegistry.instance();
        BasicModel model = namespaceOwner.getModel();
        if (model == null) {
            return null;
        }
        LocalDataSource ds = registry.getLocalDataSource(model);
        if (ds == null) {
            return null;
        }
        return DbNodeDescriptor.countNamespaces(namespaceOwner, ds);
    }

    @NotNull
    private static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull LocalDataSource dataSource) {
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(50);
        }
        if (dataSource == null) {
            DbNodeDescriptor.$$$reportNull$$$0(51);
        }
        TreePattern scope2 = dataSource.getIntrospectionScope();
        Couple couple = TreePatternUtils.countNamespaces((BasicNamespaceOwner)namespaceOwner, (TreePattern)scope2);
        if (couple == null) {
            DbNodeDescriptor.$$$reportNull$$$0(52);
        }
        return couple;
    }

    public static void addSpaceDelimiter(PresentationData presentation) {
        String lastFragmentText;
        PresentableNodeDescriptor.ColoredFragment lastFragment;
        char c2 = '\u0000';
        List fragments = presentation.getColoredText();
        int fragmentsCnt = fragments.size();
        PresentableNodeDescriptor.ColoredFragment coloredFragment = lastFragment = fragmentsCnt > 0 ? (PresentableNodeDescriptor.ColoredFragment)fragments.get(fragmentsCnt - 1) : null;
        if (lastFragment != null && (lastFragment.getAttributes().getStyle() & 0x200) == 0 && !(lastFragmentText = lastFragment.getText()).isEmpty()) {
            c2 = lastFragmentText.charAt(lastFragmentText.length() - 1);
        }
        if (Character.isWhitespace(c2) || c2 == spaceDelimiter.charAt(0)) {
            return;
        }
        presentation.addText(spaceDelimiter, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static SimpleTextAttributes handleStatuses(@NotNull Project project, @NotNull PresentationData presentation, @NotNull BasicNode node, @Nullable RawDataSource dataSource, @NotNull DbTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(53);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(54);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(55);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(56);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(57);
        }
        if (node instanceof BasicElement) {
            BasicElement element = (BasicElement)node;
            return DbNodeDescriptor.handleStatusesOfElement(element, dataSource, decoration, viewOptions);
        }
        if (node instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)node;
            return DbNodeDescriptor.handleStatusesOfDataSource(project, presentation, dsn, decoration);
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    private static SimpleTextAttributes handleStatusesOfDataSource(@NotNull Project project, @NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull DbTreeNodeDecoration decoration) {
        boolean hasModel;
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(58);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(59);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(60);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(61);
        }
        boolean hasErrors = false;
        boolean hasWarnings = false;
        LocalDataSource lds = dsn.getLocalDataSource();
        BasicModel model = dsn.getModel();
        boolean bl = hasModel = model != null && model.getRoot().hasChildren();
        if (hasModel) {
            Set<DataSourceProblem> problems = DataSourceProblemCache.getDataSourceProblems(project, dsn.dataSource);
            for (DataSourceProblem problem : problems) {
                switch (problem.getLevel()) {
                    case WARNING: {
                        hasWarnings = true;
                        break;
                    }
                    case ERROR: {
                        hasErrors = true;
                    }
                }
            }
        }
        boolean connected = lds != null && DbImplUtil.isConnected((Project)project, (LocalDataSource)lds);
        int connectionCount = connected ? DbImplUtil.getActiveConnectionCount((LocalDataSource)lds) : -1;
        int usageCount = DbImplUtilCore.countUsagesAsLinkedDataSource((Project)project, (String)dsn.dataSource.getUniqueId());
        SimpleTextAttributes style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (decoration.isDimmed) {
            style = SimpleTextAttributes.GRAY_ATTRIBUTES;
        }
        if (lds != null && !connected && DbNodeDescriptor.checkMissedDriverFiles(project, lds)) {
            hasWarnings = true;
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message((String)"tooltip.database.driver.files.not.found.open.properties.to.download", (Object[])new Object[0]));
        }
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (connectionCount >= 0) {
            String message = DatabaseBundle.message((String)"tooltip.choice.connection.connections", (Object[])new Object[]{connectionCount, connectionCount == 1 ? 0 : 1});
            DbNodeDescriptor.addTooltip(presentation, false, message);
        }
        if (usageCount > 0) {
            DbNodeDescriptor.addTooltip(presentation, false, DbImplUtilCore.usageAsLinkedDSMessage((int)usageCount));
        }
        return style;
    }

    private static boolean checkMissedDriverFiles(@NotNull Project project, @NotNull LocalDataSource ds) {
        DatabaseDriver driver;
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(62);
        }
        if (ds == null) {
            DbNodeDescriptor.$$$reportNull$$$0(63);
        }
        if ((driver = ds.getDatabaseDriver()) == null) {
            return true;
        }
        try {
            DatabaseDriverClasspathManager driverClasspathManager = DatabaseDriverClasspathManager.Companion.getInstance(project);
            return !driverClasspathManager.hasDriverFiles(driver, DatabaseArtifactContext.Companion.getInstance(project, ds));
        }
        catch (Throwable e) {
            ourLogger.error("Failed to check the driver files existence for data source (%s): exception %s: %s".formatted(ds.getName(), e.getClass().getSimpleName(), e.getMessage()), e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static SimpleTextAttributes handleStatusesOfElement(@NotNull BasicElement element, @Nullable RawDataSource dataSource, @NotNull DbTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(64);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(65);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(66);
        }
        invalid = element instanceof BasicSourceAware != false && (sa = (BasicSourceAware)element).isInvalid() != false;
        style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (!(element instanceof BasicNamespace)) ** GOTO lbl-1000
        namespace = (BasicNamespace)element;
        if (viewOptions.getShowAllNamespaces() && !DbNodeDescriptorHelper.isInIntrospectionScope(namespace, dataSource)) {
            style = DbPresentation.INFO_ATTRS;
        } else if (decoration.isDimmed) {
            style = SimpleTextAttributes.GRAY_ATTRIBUTES;
        } else if (DbPresentation.isUnnamed((DasObject)element)) {
            style = DbPresentation.INFO_ATTRS;
        }
        if (invalid) {
            waved = new SimpleTextAttributes(8, null, (Color)JBColor.RED);
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        return style;
    }

    private static void showCount(@NotNull PresentationData presentation, @NotNull BasicNode node, @NotNull DvTreeStructure treeStructure, @NotNull MiniContext mc, @NotNull DvViewOptions viewOptions) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(67);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(68);
        }
        if (treeStructure == null) {
            DbNodeDescriptor.$$$reportNull$$$0(69);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(70);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(71);
        }
        int n = DbNodeDescriptorHelper.countShowChildrenNum(node, treeStructure, viewOptions);
        DbNodeDescriptor.showCount(presentation, mc, n);
    }

    public static void showCount(@NotNull PresentationData presentation, @Nullable MiniContext mc, int count) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(72);
        }
        if (count > 0) {
            @NlsSafe String countStr = Integer.toString(count);
            DbNodeDescriptor.showCount(presentation, countStr);
            if (mc != null) {
                mc.countShown = true;
            }
        }
    }

    private static void showCount(@NotNull PresentationData presentation, @NotNull @NlsSafe String countStr) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(73);
        }
        if (countStr == null) {
            DbNodeDescriptor.$$$reportNull$$$0(74);
        }
        presentation.addText(countStr, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    private static void addTooltip(PresentationData presentation, boolean before, @NlsContexts.Tooltip String tooltip) {
        Object result2;
        String cur = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur)) {
            result2 = tooltip;
        } else {
            String separator = "<p>";
            result2 = before ? tooltip + separator + cur : cur + separator + tooltip;
        }
        presentation.setTooltip((String)(((String)result2).startsWith("<html>") ? result2 : "<html>" + (String)result2));
    }

    @Nullable
    static PsiElement getPsiElement(@NotNull Project project, @NotNull BasicNode node) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(75);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(76);
        }
        if (node instanceof DvTreeFilesLayer.QueryFile) {
            DvTreeFilesLayer.QueryFile queryFile = (DvTreeFilesLayer.QueryFile)node;
            return (PsiElement)ReadAction.compute(() -> {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findFile(queryFile.getVirtualFile());
            });
        }
        DbElement dbElement = DbNodeDescriptor.asDbElement(project, node);
        return dbElement != null ? dbElement : (PsiElement)ObjectUtils.tryCast((Object)node, PsiElement.class);
    }

    @Nullable
    static Collection<? extends PsiElement> getPsiElementsForFilesLayer(@NotNull Project project, @NotNull Supplier<? extends Collection<? extends BasicNode>> nodesGetter) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(77);
        }
        if (nodesGetter == null) {
            DbNodeDescriptor.$$$reportNull$$$0(78);
        }
        JBIterable nodes = JBIterable.from((Iterable)nodesGetter.get());
        LinkedHashSet result2 = new LinkedHashSet();
        ReadAction.run(() -> {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            nodes.forEach(o -> {
                if (o instanceof DvTreeFilesLayer.QueryFile) {
                    DvTreeFilesLayer.QueryFile file = (DvTreeFilesLayer.QueryFile)o;
                    result2.add(psiManager.findFile(file.getVirtualFile()));
                }
            });
        });
        return !result2.isEmpty() ? result2 : null;
    }

    @Nullable
    static Collection<? extends VirtualFile> getVirtualFiles(@NotNull Project project, @NotNull Supplier<? extends Collection<? extends BasicNode>> nodesGetter) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(79);
        }
        if (nodesGetter == null) {
            DbNodeDescriptor.$$$reportNull$$$0(80);
        }
        JBIterable nodes = JBIterable.from((Iterable)nodesGetter.get());
        LinkedHashSet result2 = new LinkedHashSet();
        nodes.flatten(o -> DbNodeDescriptor.getVirtualFiles(DbNodeDescriptor.asDbElement(project, o))).addAllTo(result2);
        nodes.forEach(o -> {
            if (o instanceof DvTreeFilesLayer.QueryFile) {
                DvTreeFilesLayer.QueryFile file = (DvTreeFilesLayer.QueryFile)o;
                result2.add(file.getVirtualFile());
            }
        });
        return !result2.isEmpty() ? result2 : null;
    }

    @Nullable
    static Navigatable getNavigatable(@NotNull Project project, @Nullable BasicNode node) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(81);
        }
        if (node == null) {
            return null;
        }
        DbElement db = DbNodeDescriptor.asDbElement(project, node);
        if (db != null) {
            return DbNavigationUtils.createFromTreeNavigatable(db);
        }
        DbModelRegistry modelRegistry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        if (node instanceof HostFamily) {
            HostFamily hostFamily = (HostFamily)node;
            return DbNodeDescriptor.createFamilyNavigatable(modelRegistry, (FamilyWithId)hostFamily);
        }
        if (node instanceof DvErsatzFamilyNode) {
            DvErsatzFamilyNode efn = (DvErsatzFamilyNode)node;
            return DbNodeDescriptor.createFamilyNavigatable(modelRegistry, (FamilyWithId)efn);
        }
        if (node instanceof Navigatable) {
            Navigatable navi = (Navigatable)node;
            return navi;
        }
        return null;
    }

    @Nullable
    public static List<VirtualFile> getVirtualFiles(@Nullable DbElement e) {
        LocalDataSource lds;
        SqlDataSource sqlDs;
        SqlDataSource sqlDataSource = sqlDs = e == null ? null : DbImplUtilCore.getMaybeSqlDataSource((DasDataSource)e.getDataSource());
        if (sqlDs != null) {
            return DbNodeDescriptor.getFilesForSqlDataSource(e, sqlDs);
        }
        LocalDataSource localDataSource = lds = e == null ? null : DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)e.getDataSource());
        if (lds != null) {
            return DbNodeDescriptor.getFilesForLocalDataSource(e, lds);
        }
        return null;
    }

    @Nullable
    private static List<VirtualFile> getFilesForLocalDataSource(@NotNull DbElement e, @NotNull LocalDataSource ds) {
        if (e == null) {
            DbNodeDescriptor.$$$reportNull$$$0(82);
        }
        if (ds == null) {
            DbNodeDescriptor.$$$reportNull$$$0(83);
        }
        String filePath = DbSrcUtils.getPath((Project)e.getProject(), (LocalDataSource)ds, (DasObject)e, (CasingProvider)ds.getModel(), (DbSrcFileSystemCore.ItemType)DbSrcFileSystemCore.ItemType.SRC);
        VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
        if (file == null) {
            filePath = DbSrcUtils.getPath((Project)e.getProject(), (LocalDataSource)ds, (DasObject)e, (CasingProvider)ds.getModel(), null);
            file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
        }
        return file == null ? null : Collections.singletonList(file);
    }

    @Nullable
    private static List<VirtualFile> getFilesForSqlDataSource(@NotNull DbElement e, @NotNull SqlDataSource sqlDs) {
        if (e == null) {
            DbNodeDescriptor.$$$reportNull$$$0(84);
        }
        if (sqlDs == null) {
            DbNodeDescriptor.$$$reportNull$$$0(85);
        }
        if (e instanceof DbDataSource) {
            return sqlDs.getRoots();
        }
        DasObject object = sqlDs.fromModel((DasObject)e.getDelegate());
        PsiElement element = (PsiElement)ObjectUtils.tryCast((Object)object, PsiElement.class);
        PsiFile f = element == null ? null : element.getContainingFile();
        VirtualFile file = f == null ? null : f.getViewProvider().getVirtualFile();
        return file == null ? null : Collections.singletonList(file);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    private static DbElement asDbElement(@NotNull Project project, @Nullable BasicNode node) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(86);
        }
        if (node == null) {
            return null;
        }
        if (node instanceof DbElement) {
            DbElement dbElement = (DbElement)node;
            return dbElement;
        }
        if (project.isDisposed()) {
            return null;
        }
        DbModelRegistry modelRegistry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        if (node instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)node;
            return modelRegistry.findDbDataSource(dsn);
        }
        if (node instanceof BasicElement) {
            BasicElement element = (BasicElement)node;
            return modelRegistry.findDbElement(element);
        }
        if (node instanceof DasObject) {
            DasObject dasObject = (DasObject)node;
            DbDataSource ds = modelRegistry.findDbDataSource(dasObject);
            return ds == null ? null : ds.findElement(dasObject);
        }
        return null;
    }

    @Nullable
    private static NavigationItem createFamilyNavigatable(DbModelRegistry modelRegistry, FamilyWithId bn) {
        DvHostNode hn = (DvHostNode)ObjectUtils.tryCast((Object)bn, DvHostNode.class);
        DbElement host = hn == null ? null : modelRegistry.findDbElement(hn.host);
        return host == null ? null : DbNavigationUtils.createFromTreeFamilyNavigatable(host, bn.getFamilyId().getFakeKind());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 36, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 26: 
            case 55: 
            case 68: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 20: 
            case 24: 
            case 39: 
            case 49: 
            case 53: 
            case 58: 
            case 62: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 57: 
            case 66: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 4: 
            case 7: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionService";
                break;
            }
            case 19: 
            case 42: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsn";
                break;
            }
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mc";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 28: 
            case 56: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoration";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafKind";
                break;
            }
            case 36: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 38: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceOwner";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counters";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 63: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countStr";
                break;
            }
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesGetter";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCommentString";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "countNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkObjectPresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationAdditions";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForDataSource";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setNodePrimaryText";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForEmptyScopeLeaf";
                break;
            }
            case 36: 
            case 52: {
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appendNamespaceChooserLinkWithCounters";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "appendNamespaceChooserLinkWithoutCounters";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "countNamespaces";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "handleStatuses";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handleStatusesOfDataSource";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "checkMissedDriverFiles";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleStatusesOfElement";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "showCount";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementsForFilesLayer";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFiles";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForLocalDataSource";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForSqlDataSource";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "asDbElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 36, 52 -> new IllegalStateException(string);
        };
    }

    private static class MiniContext {
        boolean countShown = false;

        private MiniContext() {
        }
    }

    @Service(value={Service.Level.PROJECT})
    public static final class DataSourceProblemCache
    implements Disposable {
        private final Project myProject;
        private final ExecutorService myExecutor;
        private final Map<RawDataSource, AsyncCachedValue<Set<DataSourceProblem>>> myCache;

        public DataSourceProblemCache(@NotNull Project project) {
            if (project == null) {
                DataSourceProblemCache.$$$reportNull$$$0(0);
            }
            this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DataSourceProblemCache", (int)1);
            this.myCache = ConcurrentFactoryMap.createWeakMap(ds -> new AsyncCachedValue(Collections.emptySet()));
            this.myProject = project;
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener(){

                public void onChanged(@Nullable DbDataSource dbDataSource) {
                    if (dbDataSource == null) {
                        for (AsyncCachedValue<Set<DataSourceProblem>> value : myCache.values()) {
                            value.invalidate();
                        }
                    } else {
                        myCache.get(dbDataSource.getDelegateDataSource()).invalidate();
                    }
                }
            });
        }

        public void dispose() {
            this.myExecutor.shutdownNow();
        }

        private static Set<DataSourceProblem> getDataSourceProblems(@NotNull Project project, @NotNull RawDataSource dataSource) {
            if (project == null) {
                DataSourceProblemCache.$$$reportNull$$$0(1);
            }
            if (dataSource == null) {
                DataSourceProblemCache.$$$reportNull$$$0(2);
            }
            return ((DataSourceProblemCache)project.getService(DataSourceProblemCache.class)).getProblems(dataSource);
        }

        private Set<DataSourceProblem> getProblems(@NotNull RawDataSource dataSource) {
            if (dataSource == null) {
                DataSourceProblemCache.$$$reportNull$$$0(3);
            }
            return this.myCache.get(dataSource).getValue(() -> this.getProblemsAsync(dataSource));
        }

        @NotNull
        private CompletableFuture<Set<DataSourceProblem>> getProblemsAsync(@NotNull RawDataSource dataSource) {
            if (dataSource == null) {
                DataSourceProblemCache.$$$reportNull$$$0(4);
            }
            CompletableFuture<Set<DataSourceProblem>> res2 = CompletableFuture.supplyAsync(() -> DatabaseConfigValidator.getProblems(this.myProject, dataSource.getName(), dataSource, null), this.myExecutor);
            res2.whenComplete((r, th) -> {
                if (r != null) {
                    DatabaseView.getDatabaseView(this.myProject).repaint();
                }
            });
            CompletableFuture<Set<DataSourceProblem>> completableFuture = res2;
            if (completableFuture == null) {
                DataSourceProblemCache.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor$DataSourceProblemCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor$DataSourceProblemCache";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemsAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSourceProblems";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblems";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemsAsync";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

