/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import com.intellij.sql.psi.impl.FlattenedAliasedSqlTableType;
import com.intellij.sql.psi.impl.SqlTableTypeComposite;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableTypeBase
extends SqlTableType {
    public static final SqlTableType EMPTY_TABLE = new Empty(){

        @Override
        public SqlTableType join(SqlTableType type) {
            return type;
        }

        @Override
        public SqlTableType add(SqlTableType type) {
            return type;
        }

        @Override
        public SqlTableType addDistinct(SqlTableType type, CasingProvider casingProvider) {
            return type;
        }

        @Override
        public SqlTableType intersect(SqlTableType type, CasingProvider casingProvider) {
            return this;
        }
    };

    public static SqlTableType ensureTableType(DasType dasType, @NotNull PsiElement element, @Nullable PsiElement qualifier) {
        if (element == null) {
            SqlTableTypeBase.$$$reportNull$$$0(0);
        }
        if (dasType instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)dasType;
            return tableType2;
        }
        return SqlTableTypeBase.createType(element, dasType, element instanceof SqlNameElement ? ((SqlNameElement)element).getName() : element.getText(), element instanceof SqlNameElement && ((SqlNameElement)element).isQuotedIdentifier(), false, true, qualifier, null);
    }

    public static SqlTableType createType(final @NotNull PsiElement element, final @NotNull DasType dasType, final @Nullable String name, final boolean quoted, final boolean generated, final boolean resolvable, final @Nullable PsiElement qualifier, final @Nullable String aliasName) {
        if (element == null) {
            SqlTableTypeBase.$$$reportNull$$$0(1);
        }
        if (dasType == null) {
            SqlTableTypeBase.$$$reportNull$$$0(2);
        }
        String colTypeSpec = dasType.getSpecification();
        final DataType dataType = DataTypeFactory.ofArgs(null, (String)"table", (String)(name == null ? colTypeSpec : name + " " + colTypeSpec), (boolean)false);
        return new SqlTableTypeBase(){

            @NotNull
            public List<DasObject> getMethods() {
                List<DasObject> list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return dataType2;
            }

            public int getColumnCount() {
                return 1;
            }

            public boolean isResolvableColumn(int i2) {
                return resolvable;
            }

            public String getColumnName(int i2) {
                return name;
            }

            public boolean isColumnQuoted(int i2) {
                return quoted;
            }

            public DasType getColumnDasType(int i2) {
                return dasType;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
            }

            @Override
            @Nullable
            public PsiElement getImmediateSourceColumnElement(int i2) {
                return element;
            }

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                PsiElement e = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
                DasTable table = e instanceof PsiColumn ? ((PsiColumn)e).getTable() : null;
                return table instanceof PsiElement ? (PsiElement)table : null;
            }

            @Override
            @Nullable
            public String getColumnTypeAlias(int i2) {
                return aliasName;
            }

            public boolean isGeneratedColumn(int i2) {
                return generated;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static SqlTableType createUnresolvedTableType(@NotNull PsiReference reference2) {
        if (reference2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(3);
        }
        return new UnresolvedRefType(reference2);
    }

    public static SqlTableType createType(@NotNull DasTable info, @Nullable PsiElement tableElement, @Nullable PsiElement place) {
        if (info == null) {
            SqlTableTypeBase.$$$reportNull$$$0(4);
        }
        return TableBasedSqlTableTypeImpl.createTypeWithColumns((DasObject)info, tableElement, place, DasColumn.class, ObjectKind.COLUMN);
    }

    @NotNull
    public static SqlTableType createObjectTypeType(@NotNull DasObject info, @NotNull PsiElement typeElement, @Nullable PsiElement place) {
        if (info == null) {
            SqlTableTypeBase.$$$reportNull$$$0(5);
        }
        if (typeElement == null) {
            SqlTableTypeBase.$$$reportNull$$$0(6);
        }
        return SqlTableTypeBase.createObjectTypeType(info, typeElement, place, true);
    }

    @NotNull
    public static SqlTableType createObjectTypeType(@NotNull DasObject info, @NotNull PsiElement typeElement, @Nullable PsiElement place, boolean withAttributes) {
        SqlTableType superTypeType;
        DbCustomType superType;
        TableBasedSqlTableTypeImpl res;
        if (info == null) {
            SqlTableTypeBase.$$$reportNull$$$0(7);
        }
        if (typeElement == null) {
            SqlTableTypeBase.$$$reportNull$$$0(8);
        }
        TableBasedSqlTableTypeImpl<Object> tableBasedSqlTableTypeImpl = res = withAttributes ? TableBasedSqlTableTypeImpl.createTypeWithColumns(info, typeElement, place, DasTypedObject.class, ObjectKind.OBJECT_ATTRIBUTE) : TableBasedSqlTableTypeImpl.createTypeWithoutColumns(info, typeElement, place);
        if (info instanceof DbCustomType && (superType = ((DbCustomType)info).getSuperType()) != null && (superTypeType = (SqlTableType)RecursionManager.doPreventingRecursion((Object)superType.getDelegate(), (boolean)true, () -> SqlTableTypeBase.createObjectTypeType((DasObject)superType, (PsiElement)superType, null))) != null) {
            SqlTableType sqlTableType = SqlTableTypeBase.inherit(res, superTypeType);
            if (sqlTableType == null) {
                SqlTableTypeBase.$$$reportNull$$$0(9);
            }
            return sqlTableType;
        }
        TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl2 = res;
        if (tableBasedSqlTableTypeImpl2 == null) {
            SqlTableTypeBase.$$$reportNull$$$0(10);
        }
        return tableBasedSqlTableTypeImpl2;
    }

    static SqlTableType inherit(SqlTableType type, SqlTableType superType) {
        final List methods = ContainerUtil.concat((List)type.getMethods(), (List)superType.getMethods());
        final DataType dataType = DataTypeFactory.of((String)StringUtil.notNullize((String)type.getTypeName()));
        return new SqlTableTypeComposite(superType, type){

            @Override
            @NotNull
            public List<DasObject> getMethods() {
                List list = methods;
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public PsiElement getTypeElement() {
        return null;
    }

    @Nullable
    public PsiElement getImmediateTypeElement() {
        return this.getTypeElement();
    }

    @Nullable
    public String getTypeName() {
        return null;
    }

    @Nullable
    public String getColumnTypeAlias(int i2) {
        return null;
    }

    public boolean isColumnTypeAliasQuoted(int i2) {
        return (Boolean)ObjectUtils.chooseNotNull((Object)SqlTableTypeBase.isQuoted(this.getColumnQualifier(i2)), (Object)false);
    }

    @Nullable
    public PsiElement getImmediateSourceColumnElement(int i2) {
        return this.getSourceColumnElement(i2);
    }

    @Nullable
    protected static Boolean isQuoted(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)((SqlNameElement)element));
        }
        if (element instanceof DasObject) {
            return DbSqlUtilCore.isQuoted((DasObject)((DasObject)element));
        }
        return null;
    }

    public SqlTableType join(SqlTableType type) {
        return SqlTableTypeComposite.join(this, type);
    }

    public SqlTableType add(SqlTableType type) {
        return SqlTableTypeComposite.add(this, type);
    }

    public SqlTableType addDistinct(SqlTableType type, CasingProvider casingProvider) {
        Set leftColumns = ObjectName.createCasingAwareSet((ObjectKind)ObjectKind.COLUMN, (CasingProvider)casingProvider);
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            leftColumns.add(ObjectName.create((String)this.getColumnName(i2), (boolean)this.isColumnQuoted(i2)));
        }
        SqlTableType rightType = type;
        for (int i3 = type.getColumnCount() - 1; i3 >= 0; --i3) {
            ObjectName colName = ObjectName.create((String)type.getColumnName(i3), (boolean)type.isColumnQuoted(i3));
            if (!leftColumns.contains(colName)) continue;
            rightType = rightType.subtract(i3);
        }
        return this.add(rightType);
    }

    public SqlTableType intersect(SqlTableType type, CasingProvider casingProvider) {
        Set rightColumns = ObjectName.createCasingAwareSet((ObjectKind)ObjectKind.COLUMN, (CasingProvider)casingProvider);
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            rightColumns.add(ObjectName.create((String)type.getColumnName(i2), (boolean)type.isColumnQuoted(i2)));
        }
        SqlTableTypeBase result = this;
        for (int i3 = this.getColumnCount() - 1; i3 >= 0; --i3) {
            ObjectName colName = ObjectName.create((String)this.getColumnName(i3), (boolean)this.isColumnQuoted(i3));
            if (rightColumns.contains(colName)) continue;
            result = result.subtract(i3);
        }
        return result;
    }

    public SqlTableType subtract(@Nullable PsiElement element) {
        return SubtractedSqlTableTypeImpl.subtract((SqlTableType)this, element);
    }

    public SqlTableType subtract(int columnIndex) {
        return SubtractedSqlTableTypeImpl.subtract((SqlTableType)this, columnIndex);
    }

    public SqlTableType alias(String aliasName, @Nullable PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
        if (newColumns == null) {
            SqlTableTypeBase.$$$reportNull$$$0(11);
        }
        return AliasedSqlTableType.fromNames(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType aliasByDefs(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlDefinition> newColumns) {
        if (newColumns == null) {
            SqlTableTypeBase.$$$reportNull$$$0(12);
        }
        return AliasedSqlTableType.fromDefs(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType flattenedAlias(String aliasName, PsiElement aliasElement, SqlElement sourceElement) {
        return new FlattenedAliasedSqlTableType((SqlTableType)this, aliasName, aliasElement, sourceElement);
    }

    public static <T> List<T> expand(List<T> aliases, int size) {
        ArrayList<T> res = new ArrayList<T>(aliases);
        for (int i2 = res.size(); i2 < size; ++i2) {
            res.add(null);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectTypeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureTableType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedTableType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createObjectTypeType";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "aliasByDefs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    public static class UnresolvedRefType
    extends Empty {
        private final PsiReference myReference;

        public UnresolvedRefType(PsiReference reference2) {
            this.myReference = reference2;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myReference.getCanonicalText();
        }

        @Override
        @Nullable
        public PsiElement getTypeElement() {
            return this.myReference.getElement();
        }
    }

    public static class Empty
    extends SqlTableTypeBase {
        @NotNull
        public List<DasObject> getMethods() {
            List<DasObject> list = Collections.emptyList();
            if (list == null) {
                Empty.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataTypeFactory.of((String)"table()");
            if (dataType == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return dataType;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int i2) {
            throw new NoSuchElementException();
        }

        public boolean isColumnQuoted(int i2) {
            throw new NoSuchElementException();
        }

        public DasType getColumnDasType(int i2) {
            throw new NoSuchElementException();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            throw new NoSuchElementException();
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        public PsiElement getSourceColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public String getColumnTypeAlias(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public SqlTableType subtract(PsiElement element) {
            return this;
        }

        @Override
        public SqlTableType subtract(int columnIndex) {
            return this;
        }

        @Override
        public SqlTableType alias(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
            if (newColumns == null) {
                Empty.$$$reportNull$$$0(2);
            }
            return newColumns.isEmpty() ? this : AliasedSqlTableType.fromNames(this, aliasName, aliasElement, newColumns);
        }

        @Override
        public SqlTableType aliasByDefs(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlDefinition> newColumns) {
            if (newColumns == null) {
                Empty.$$$reportNull$$$0(3);
            }
            return newColumns.isEmpty() ? this : AliasedSqlTableType.fromDefs(this, aliasName, aliasElement, newColumns);
        }

        @Override
        public SqlTableType flattenedAlias(String aliasName, PsiElement aliasElement, SqlElement sourceElement) {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toDataType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "alias";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "aliasByDefs";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

