/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.websocket;

import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequest;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequestRequestHandler;
import com.intellij.httpClient.http.request.HttpRequestHeadersBuilder;
import com.intellij.httpClient.http.request.HttpRequestPsiConvertersKt;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestBidiStreamingMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequestExecutionSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequest;", "<init>", "()V", "supportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "canProcess", "", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "needsScheme", "getNeedsScheme", "()Z", "supportedSchemes", "", "getSupportedSchemes", "()Ljava/util/List;", "Companion", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class WebSocketClientRequestExecutionSupport
implements RequestExecutionSupport<WebSocketClientRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> SCHEMES;

    @Override
    @NotNull
    public Collection<String> supportedMethods(@Nullable Project project) {
        return CollectionsKt.listOf((Object)"WEBSOCKET");
    }

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return this.supportedMethods(null);
    }

    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && Intrinsics.areEqual((Object)requestContext.getMethod(), (Object)"WEBSOCKET") && CollectionsKt.contains((Iterable)SCHEMES, (Object)requestContext.getScheme());
    }

    @Override
    @NotNull
    public RequestHandler<WebSocketClientRequest> getRequestHandler() {
        return new WebSocketClientRequestRequestHandler();
    }

    @Override
    @NotNull
    public RequestConverter<WebSocketClientRequest> getRequestConverter() {
        return new RequestConverter<WebSocketClientRequest>(){

            protected Class<WebSocketClientRequest> getRequestType() {
                return WebSocketClientRequest.class;
            }

            public WebSocketClientRequest psiToCommonRequest(SmartPsiElementPointer<HttpRequest> requestPsiPointer, HttpRequestVariableSubstitutor substitutor2) {
                Intrinsics.checkNotNullParameter(requestPsiPointer, (String)"requestPsiPointer");
                Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
                PsiElement psiElement = requestPsiPointer.getElement();
                Intrinsics.checkNotNull((Object)psiElement);
                HttpRequest element = (HttpRequest)psiElement;
                HttpRequestUrlAccessor httpRequestUrlAccessor = HttpRequestPsiConvertersKt.getFullUrl(element, substitutor2);
                Intrinsics.checkNotNull((Object)httpRequestUrlAccessor);
                String url = httpRequestUrlAccessor.toUrlString(true);
                HttpRequestBidiStreamingMessages messages = HttpRequestBidiStreamingMessages.Companion.createFromBody(element.getRequestBody(), substitutor2);
                HttpRequestHeadersBuilder headers2 = WebSocketClientRequestExecutionSupport.Companion.getHeaders(element, substitutor2);
                return new WebSocketClientRequest(url, messages, headers2);
            }

            protected String toExternalFormInner(WebSocketClientRequest request, String fileName) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return "";
            }
        };
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return SCHEMES;
    }

    static {
        Object[] objectArray = new String[]{"ws", "wss"};
        SCHEMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequestExecutionSupport$Companion;", "", "<init>", "()V", "SCHEMES", "", "", "getHeaders", "Lcom/intellij/httpClient/http/request/HttpRequestHeadersBuilder;", "element", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock(generateAssertion=false)
        @NotNull
        public final HttpRequestHeadersBuilder getHeaders(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
            HttpRequestHeadersBuilder httpRequestHeadersBuilder;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
            HttpRequestHeadersBuilder $this$getHeaders_u24lambda_u240 = httpRequestHeadersBuilder = new HttpRequestHeadersBuilder(null, 1, null);
            boolean bl = false;
            for (HttpHeaderField header : element.getHeaderFieldList()) {
                String string = header.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = "Content-Type".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                $this$getHeaders_u24lambda_u240.add((Pair<String, String>)TuplesKt.to((Object)header.getName(), (Object)header.getValue(substitutor2)));
            }
            HttpRequestHeadersBuilder headers2 = httpRequestHeadersBuilder;
            return headers2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

