/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.injection.graphql;

import com.intellij.httpClient.executor.graphql.request.GraphQLPresentationKt;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.injection.http.request.HttpClientCustomBodyInjector;
import com.intellij.httpClient.injection.http.request.HttpRequestBodyInjector;
import com.intellij.httpClient.injection.http.request.InjectionsKt;
import com.intellij.httpClient.injection.http.request.Place;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.jsgraphql.GraphQLLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/injection/graphql/GraphQLBodyInjector;", "Lcom/intellij/httpClient/injection/http/request/HttpClientCustomBodyInjector;", "<init>", "()V", "isApplicable", "", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "provideInjection", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "message", "Lcom/intellij/httpClient/http/request/psi/HttpRequestMessagesGroup;", "injectGraphQl", "messageBody", "Lcom/intellij/httpClient/http/request/psi/HttpMessageBody;", "intellij.httpClient.injection.graphql"})
public final class GraphQLBodyInjector
implements HttpClientCustomBodyInjector {
    @Override
    public boolean isApplicable(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return Intrinsics.areEqual((Object)request.getHttpMethod(), (Object)"GRAPHQL");
    }

    @Override
    public void provideInjection(@NotNull MultiHostRegistrar registrar, @NotNull HttpRequestMessagesGroup message) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getRequestMessageList().size() == 1 && message.getRequestMessageList().get(0) instanceof HttpMessageBody) {
            HttpRequestMessage httpRequestMessage = message.getRequestMessageList().get(0);
            Intrinsics.checkNotNull((Object)httpRequestMessage, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpMessageBody");
            this.injectGraphQl((HttpMessageBody)httpRequestMessage, registrar);
        }
    }

    private final void injectGraphQl(HttpMessageBody messageBody, MultiHostRegistrar registrar) {
        String text2 = messageBody.getText();
        Intrinsics.checkNotNull((Object)text2);
        int graphQlEnd = GraphQLPresentationKt.findGraphQLEnd(text2);
        String string = text2.substring(0, graphQlEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        List<Place> injectionPlaces = HttpRequestBodyInjector.injectBody(messageBody, string, "", 0);
        GraphQLLanguage graphQLLanguage = GraphQLLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)graphQLLanguage, (String)"INSTANCE");
        Language language = (Language)graphQLLanguage;
        Intrinsics.checkNotNull(injectionPlaces);
        InjectionsKt.inject(registrar, language, injectionPlaces);
    }
}

