/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPortHandler;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortListeningOptions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.PortForwardingProcessWatcher;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ByteIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/MacPortForwardingProcessWatcher;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher;", "pid", "", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "options", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "<init>", "(JLcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;)V", "tcpListeningPortsRegex", "Lkotlin/text/Regex;", "getPortsOfPids", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "pids", "Companion", "intellij.platform.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMacPortForwardingProcessWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacPortForwardingProcessWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/MacPortForwardingProcessWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n1#2:130\n1586#3:131\n1661#3,3:132\n2829#3,7:135\n221#4:142\n222#4:155\n67#5,4:143\n67#5,4:147\n67#5,4:151\n*S KotlinDebug\n*F\n+ 1 MacPortForwardingProcessWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/MacPortForwardingProcessWatcher\n*L\n62#1:131\n62#1:132,3\n62#1:135,7\n93#1:142\n93#1:155\n97#1:143,4\n102#1:147,4\n115#1:151,4\n*E\n"})
public final class MacPortForwardingProcessWatcher
extends PortForwardingProcessWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex tcpListeningPortsRegex;
    @NotNull
    private static final Logger logger = PortForwardingProcessWatcher.getLogger();

    public MacPortForwardingProcessWatcher(long pid, @NotNull ListeningPortHandler handler, @NotNull PortListeningOptions options) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        super(pid, handler, options);
        if (!SystemInfoRt.isMac) {
            boolean bl = false;
            String string = "MacPortForwardingProcessWatcher called not on Mac. This is a programming error";
            throw new IllegalArgumentException(string.toString());
        }
        this.tcpListeningPortsRegex = new Regex("TCP\\s+(?<interface>[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|\\*):(?<port>\\d+) \\(LISTEN\\)");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Set<ListeningPort> getPortsOfPids(@NotNull Set<Long> pids) {
        Intrinsics.checkNotNullParameter(pids, (String)"pids");
        Runtime runtime = Runtime.getRuntime();
        Set scannedOncePorts = new LinkedHashSet();
        Map outputs = new LinkedHashMap();
        Iterator<Long> iterator = pids.iterator();
        while (iterator.hasNext()) {
            long pidToCheck = ((Number)iterator.next()).longValue();
            try {
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Process process = runtime.exec("lsof -Pan -p " + pidToCheck + " -i");
                List resultOutputBytes = new ArrayList();
                InputStream inputStream = process.getInputStream();
                int iterationsTaken = 0;
                while (process.isAlive() && iterationsTaken < 50) {
                    ++iterationsTaken;
                    int availableBytes = inputStream.available();
                    if (availableBytes > 0) {
                        byte[] byArray = inputStream.readNBytes(availableBytes);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
                        resultOutputBytes.add(byArray);
                    }
                    process.waitFor(200L, TimeUnit.MILLISECONDS);
                }
                if (process.isAlive()) {
                    logger.warn("lsof listening ports detection command hanged for more than 10 seconds for pid " + pidToCheck);
                    process.destroyForcibly();
                    continue;
                }
                byte[] byArray = inputStream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                resultOutputBytes.add(byArray);
                Iterable $this$map$iv = resultOutputBytes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                int $i$f$mapTo = 0;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    byte[] byArray2 = (byte[])item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((void)it).length);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator<Object> iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void one_size;
                    $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
                    int all_size = ((Number)accumulator$iv).intValue();
                    boolean bl = false;
                    accumulator$iv = all_size + one_size;
                }
                int resultOutputBytesLen = ((Number)accumulator$iv).intValue();
                byte[] resultStdout = new byte[resultOutputBytesLen];
                int resultStdoutIndex = 0;
                for (byte[] oneResultOutputBytes : resultOutputBytes) {
                    ByteIterator oneTimeOutput = ArrayIteratorsKt.iterator((byte[])oneResultOutputBytes);
                    while (oneTimeOutput.hasNext()) {
                        resultStdout[resultStdoutIndex] = oneTimeOutput.nextByte();
                        ++resultStdoutIndex;
                    }
                }
                String resultStdoutString = StringsKt.decodeToString((byte[])resultStdout);
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    logger.warn("lsof returned non-zero exit code (" + exitValue + ") for pid " + pidToCheck);
                    logger.warn("lsof STDOUT:\n" + resultStdoutString);
                    byte[] byArray3 = process.getErrorStream().readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
                    logger.warn("lsof STDERR:\n" + StringsKt.decodeToString((byte[])byArray3));
                    continue;
                }
                logger.debug("lsof output:");
                logger.debug(resultStdoutString);
                outputs.put(pidToCheck, resultStdoutString);
                logger.debug("Asking lsof for pid " + this.getPid() + " done");
            }
            catch (Throwable e) {
                logger.warn("Failed to get ports for pid " + pidToCheck, e);
            }
        }
        Map $this$forEach$iv = outputs;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            long pid = ((Number)entry.getKey()).longValue();
            String output = (String)entry.getValue();
            if (!StringsKt.contains$default((CharSequence)output, (CharSequence)"(LISTEN)", (boolean)false, (int)2, null)) continue;
            List lines = CollectionsKt.drop((Iterable)StringsKt.lines((CharSequence)output), (int)1);
            for (String line : lines) {
                Logger logger;
                Logger $this$trace$iv = MacPortForwardingProcessWatcher.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Parsing line: \"" + line + "\"");
                }
                Sequence matches = Regex.findAll$default((Regex)this.tcpListeningPortsRegex, (CharSequence)line, (int)0, (int)2, null);
                for (MatchResult match : matches) {
                    MatchGroupCollection matchGroupCollection = match.getGroups();
                    Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
                    MatchNamedGroupCollection namedMatchGroup = (MatchNamedGroupCollection)matchGroupCollection;
                    MatchGroup matchGroup = namedMatchGroup.get("port");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    String port = matchGroup.getValue();
                    Logger $this$trace$iv2 = MacPortForwardingProcessWatcher.logger;
                    int $i$f$trace2 = 0;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl3 = false;
                        logger.trace("Parsed port: \"" + port + "\"");
                    }
                    try {
                        $i$f$trace2 = Integer.parseInt(port);
                    }
                    catch (NumberFormatException e) {
                        MacPortForwardingProcessWatcher.logger.warn("Failed to parse int from port: '" + port + "'");
                        continue;
                    }
                    int intPort = $i$f$trace2;
                    if (!(1 <= intPort ? intPort < 65536 : false)) {
                        MacPortForwardingProcessWatcher.logger.info("Parsed port is not in an adequate port range. port: " + intPort);
                        continue;
                    }
                    String interface_ = null;
                    MatchGroup matchGroup2 = namedMatchGroup.get("interface");
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    interface_ = matchGroup2.getValue();
                    Logger $this$trace$iv3 = MacPortForwardingProcessWatcher.logger;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        logger = $this$trace$iv3;
                        boolean bl4 = false;
                        logger.trace("parsed interface: " + interface_);
                    }
                    if (Intrinsics.areEqual((Object)interface_, (Object)"*")) {
                        interface_ = "0.0.0.0";
                    }
                    scannedOncePorts.add(new ListeningPort(new InetSocketAddress(interface_, intPort), PortType.TCP, pid));
                }
            }
        }
        return scannedOncePorts;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/MacPortForwardingProcessWatcher$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

