/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.sql.common.impl.formatter.settings.LinkingCheckBox;
import com.intellij.database.sql.common.impl.formatter.settings.SqlCodeGenerationMainPanel;
import com.intellij.database.sql.common.impl.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.database.sql.common.impl.formatter.settings.SqlPreviewExamples;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    private static final int STRIPE_WITH_COMBO_BOX_RELATIVE_HEIGHT = 32;
    private final JBCheckBox myInheritCb;
    private final JBCheckBox myDisableCb;
    private final JPanel myWrapper;
    protected ArrayList<CodeStyleAbstractPanel> myPanels;
    private static final int[] INT_0_3_VALUES = new int[]{0, 1, 2, 3};

    protected SqlCodeStyleMainPanel(@NotNull Language settingsLanguage, CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        if (settingsLanguage == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        super(settingsLanguage, currentSettings, settings);
        this.myInheritCb = new LinkingCheckBox(SqlBundle.message((String)"settings.code.style.inherit.general.sql.style", (Object[])new Object[0]), this::switchToTheGeneralStylePage);
        this.myDisableCb = new JBCheckBox(SqlBundle.message((String)"settings.code.style.disable.formatting", (Object[])new Object[0]));
        this.myWrapper = new JPanel(new BorderLayout());
        SqlCodeStyleSettings initialSettings = this.getSqlSettings(this.getCurrentSettings());
        JComponent panel = super.getPanel();
        assert (panel != null);
        Color borderColor = JBColor.border();
        boolean settingsAreInherited = !this.isGeneral() && initialSettings.USE_GENERAL_STYLE;
        boolean settingsAreDisabled = initialSettings.DISABLE_FORMATTING;
        MyCheckBoxesListener checkBoxesListener = new MyCheckBoxesListener();
        this.myInheritCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myInheritCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myInheritCb.setSelected(settingsAreInherited);
        this.myInheritCb.setEnabled(!this.isGeneral());
        this.myInheritCb.setVisible(!this.isGeneral());
        this.myDisableCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myDisableCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myDisableCb.setSelected(settingsAreDisabled);
        JPanel cbStripe = new JPanel(new FlowLayout(0));
        cbStripe.add((Component)this.myInheritCb);
        cbStripe.add((Component)this.myDisableCb);
        JComponent dialectStripe = this.createDialectSelectorStripe(settings);
        JPanel topStripe = new JPanel((LayoutManager)new HorizontalLayout(10, 0));
        topStripe.setPreferredSize(new Dimension(200, JBUIScale.scale((int)32)));
        topStripe.add((Component)cbStripe, "LEFT");
        if (dialectStripe != null) {
            topStripe.add((Component)dialectStripe, "RIGHT");
        }
        this.myWrapper.add((Component)panel, "Center");
        this.myWrapper.add((Component)topStripe, "North");
        if (!SystemInfo.isWindows) {
            this.myWrapper.setBorder(JBUI.Borders.customLine((Color)borderColor, (int)1, (int)0, (int)0, (int)0));
        }
        this.updateControlsAbility(settingsAreInherited, settingsAreDisabled);
    }

    protected abstract boolean isGeneral();

    @NotNull
    protected abstract Language getSettingLanguage();

    @NotNull
    protected abstract SqlLanguageDialect getPreviewDialect();

    @NotNull
    protected abstract Class<? extends SqlCodeStyleSettings> getSettingsClass();

    @Nullable
    protected abstract JComponent createDialectSelectorStripe(CodeStyleSettings var1);

    protected String getPreviewText() {
        this.getSettingsClass();
        return super.getPreviewText();
    }

    protected abstract void switchToTheGeneralStylePage();

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        CodeStyleSettings modelSettings;
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        SqlCodeStyleSettings s = this.getSqlSettings(settings);
        if (!(settings instanceof CodeStyleSchemesModel.ModelSettings) && (modelSettings = this.getModelSettings()) != null && SqlCodeStyleSettingsUtil.settingsActuallyDifferent((SqlCodeStyleSettings)s, (SqlCodeStyleSettings)this.getSqlSettings(modelSettings))) {
            s.manuallyChanged();
        }
        super.apply(settings);
        this.applyMainCheckboxesState(s);
        DatabaseSettings.fireSettingsChanged();
    }

    private void applyMainCheckboxesState(SqlCodeStyleSettings settings) {
        boolean selectedInherited = this.myInheritCb.isSelected() && !this.isGeneral();
        boolean selectedDisabled = this.myDisableCb.isSelected();
        settings.USE_GENERAL_STYLE = selectedInherited;
        settings.DISABLE_FORMATTING = selectedDisabled;
        this.updateControlsAbility(selectedInherited, selectedDisabled);
    }

    private void updateControlsAbility(boolean inherited, boolean disabled) {
        this.myDisableCb.setEnabled(!inherited);
        boolean disable = inherited || disabled;
        JComponent panel = super.getPanel();
        if (panel != null) {
            UIUtil.setEnabled((Component)panel, (!disable ? 1 : 0) != 0, (boolean)true);
        }
    }

    protected void initTabs(CodeStyleSettings settings) {
        this.myPanels = new ArrayList();
        this.myPanels.add((CodeStyleAbstractPanel)new CasePanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new QueriesPanel(this, settings));
        this.myPanels.add((CodeStyleAbstractPanel)new DdlPanel(this, settings));
        this.myPanels.add((CodeStyleAbstractPanel)new CodePanel(this, settings));
        this.myPanels.add((CodeStyleAbstractPanel)new ExpressionsPanel(this, settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlIndentOptionsWrapper(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlWrappingAndBracesPanel(settings));
        this.myPanels.add(new SqlCodeGenerationMainPanel(settings));
        for (CodeStyleAbstractPanel panel : this.myPanels) {
            this.addTab(panel);
        }
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.getSqlSettings((CodeStyleSettings)settings).USE_GENERAL_STYLE != this.myInheritCb.isSelected() || this.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING != this.myDisableCb.isSelected();
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        super.resetImpl(settings);
        SqlCodeStyleSettings s = this.getSqlSettings(settings);
        this.myInheritCb.setSelected(s.USE_GENERAL_STYLE);
        this.myDisableCb.setSelected(s.DISABLE_FORMATTING);
    }

    public JComponent getPanel() {
        return this.myWrapper;
    }

    @NotNull
    private SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(3);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settings.getCustomSettings(this.getSettingsClass());
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(4);
        }
        return sqlCodeStyleSettings;
    }

    protected PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(5);
        }
        if (text == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(6);
        }
        PsiFile previewFile = super.createFileFromText(project, text);
        previewFile.setName(this.getPreviewDialect().getID() + "-preview.sql");
        return previewFile;
    }

    private EditorHighlighter createSqlHighlighter(EditorColorsScheme scheme) {
        SqlLanguageDialect dialect = this.getPreviewDialect();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
        return new LexerEditorHighlighter(highlighter, scheme);
    }

    protected void applyLanguageSettings(Language lang, CodeStyleSettings rootSettings, CodeStyleSettings targetSettings) {
        SqlCodeStyleSettings source = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)rootSettings, (Language)lang);
        SqlCodeStyleSettings target = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)targetSettings, (Language)this.getSettingLanguage());
        SqlCodeStyleSettingsUtil.copyCodeStyleSettings((SqlCodeStyleSettings)source, (SqlCodeStyleSettings)target);
    }

    private static String @NotNull [] msgsNumbers0123Names() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgNo(), "1", "2", "3"};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsNamesDontChangeYesNo() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgYes(), SqlCodeStyleMainPanel.msgNo()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsOpeningNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.on.the.same.line", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.aligned", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.indented", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsContentNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.same.line.aligned", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.wrapped.unindented", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.wrapped.aligned", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.wrapped.indented", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsClosingNamesFromBegin() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgAtTheEnd(), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message((String)"settings.code.style.under.opening", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.under.elements", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsClosingNamesEgypt() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgAtTheEnd(), SqlBundle.message((String)"settings.code.style.unindented", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message((String)"settings.code.style.under.opening", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.under.elements", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsTokenCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsAliasCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.as.identifiers", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsBuiltInsCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.as.keywords", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.as.identifiers", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsAllCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.as.keywords", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.as.identifiers", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElWrapNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.chop", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.chop.if.long", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.wrap.if.long", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElWrapNames2() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.chop", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.chop.if.long", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNamesC() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNamesM() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message((String)"settings.code.style.in.the.middle", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommonLineNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.same.line", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.new.line", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElSectionLineNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.same.line", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.new.line", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsQueryInOneStringNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.never", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.subqueries.only", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.always", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsSelectUseAsNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.add.always", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.remove", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(25);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsFromOnlyJoinIndentNames() {
        String[] stringArray = new String[]{SqlBundle.message((String)"settings.code.style.table.as.usual", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.FROM.indented", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.FROM", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(26);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsFromPlaceOnNames() {
        String[] stringArray = new String[]{SqlBundle.message((String)"settings.code.style.JOIN", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.JOIN.indented", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.JOIN.indented.cont", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.table", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.table.indented", (Object[])new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsExprCaseEndAlignNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.align.with.CASE", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.align.with.WHEN", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsInsertMatrixModeNames() {
        String[] stringArray = (String[])Arrays.stream(SqlCodeStyleConst.INSERT_MATRIX_MODE_VALUES).mapToObj(x -> x == 0 ? SqlBundle.message((String)"settings.code.style.insertMatrix.mode.auto", (Object[])new Object[0]) : (x == 100 ? SqlBundle.message((String)"settings.code.style.insertMatrix.mode.all", (Object[])new Object[0]) : Integer.toString(x))).toArray(String[]::new);
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsInsertMatrixMinWideningThresholdNames() {
        String[] stringArray = (String[])Arrays.stream(SqlCodeStyleConst.INSERT_MATRIX_MIN_WIDENING_THRESHOLD_VALUES).mapToObj(v -> v == 0 ? SqlCodeStyleMainPanel.msgNo() : Integer.toString(v)).toArray(String[]::new);
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(30);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsInsertMatrixBreakThresholdNames() {
        String[] stringArray = (String[])Arrays.stream(SqlCodeStyleConst.INSERT_MATRIX_BREAK_THRESHOLD_VALUES).mapToObj(v -> v == 0 ? SqlCodeStyleMainPanel.msgNo() : Integer.toString(v)).toArray(String[]::new);
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(31);
        }
        return stringArray;
    }

    @NotNull
    private static String msgDontChange() {
        String string = SqlBundle.message((String)"settings.code.style.do.not.change", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static String msgAsInCommon() {
        String string = SqlBundle.message((String)"settings.code.style.as.in.common", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String msgYes() {
        String string = SqlBundle.message((String)"settings.code.style.yes", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String msgNo() {
        String string = SqlBundle.message((String)"settings.code.style.no", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static String msgAuto() {
        String string = SqlBundle.message((String)"settings.code.style.auto", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String msgToLeft() {
        String string = SqlBundle.message((String)"settings.code.style.to.left", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    private static String msgToRight() {
        String string = SqlBundle.message((String)"settings.code.style.to.right", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String msgToBegin() {
        String string = SqlBundle.message((String)"settings.code.style.to.begin", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private static String msgToEnd() {
        String string = SqlBundle.message((String)"settings.code.style.to.end", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static String msgAtTheEnd() {
        String string = SqlBundle.message((String)"settings.code.style.at.the.end", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static String msgToLower() {
        String string = SqlBundle.message((String)"settings.code.style.to.lower", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static String msgToUpper() {
        String string = SqlBundle.message((String)"settings.code.style.to.upper", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static String msgToTitle() {
        String string = SqlBundle.message((String)"settings.code.style.to.title", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgOpeningSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.the.opening.parenthesis", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgContentSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.elements", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgClosingSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.the.closing.parenthesis", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElCommaSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.comma", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElWrapSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.wrap.elements", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElSectionLineSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.elements.on", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElCommonLineSettingName() {
        String string = SqlBundle.message((String)"settings.code.style.place.clause.elements.on", (Object[])new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(51);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsNumbers0123Names";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsNamesDontChangeYesNo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsOpeningNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsContentNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsClosingNamesFromBegin";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsClosingNamesEgypt";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsTokenCaseNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsAliasCaseNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsBuiltInsCaseNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsAllCaseNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElWrapNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElWrapNames2";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNamesC";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNamesM";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommonLineNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElSectionLineNames";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsQueryInOneStringNames";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsSelectUseAsNames";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsFromOnlyJoinIndentNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsFromPlaceOnNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsExprCaseEndAlignNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsInsertMatrixModeNames";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsInsertMatrixMinWideningThresholdNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsInsertMatrixBreakThresholdNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "msgDontChange";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAsInCommon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "msgYes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "msgNo";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAuto";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToLeft";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToRight";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToBegin";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToEnd";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAtTheEnd";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToLower";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToUpper";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToTitle";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "msgOpeningSettingName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "msgContentSettingName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "msgClosingSettingName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElCommaSettingName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElWrapSettingName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElSectionLineSettingName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElCommonLineSettingName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 -> new IllegalStateException(string);
        };
    }

    private class MyCheckBoxesListener
    implements ChangeListener {
        private MyCheckBoxesListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            CodeStyleSettings settingsContainer;
            if (e == null) {
                MyCheckBoxesListener.$$$reportNull$$$0(0);
            }
            if ((settingsContainer = SqlCodeStyleMainPanel.this.getModelSettings()) == null) {
                return;
            }
            SqlCodeStyleSettings settings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass());
            boolean selectedInherited = SqlCodeStyleMainPanel.this.myInheritCb.isSelected();
            boolean selectedDisabled = SqlCodeStyleMainPanel.this.myDisableCb.isSelected();
            if (settings.USE_GENERAL_STYLE == selectedInherited && settings.DISABLE_FORMATTING == selectedDisabled) {
                return;
            }
            SqlCodeStyleMainPanel.this.applyMainCheckboxesState(settings);
            SqlCodeStyleMainPanel.this.somethingChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$MyCheckBoxesListener", "stateChanged"));
        }
    }

    public class CasePanel
    extends OptionsPanel {
        public CasePanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CASE_SETTINGS;
        }

        protected void initTables() {
            int[] quoteTypeOptions;
            boolean supportGraveAccent;
            boolean supportBrackets;
            String CASE_OPTIONS = SqlBundle.message((String)"settings.code.style.word.case", (Object[])new Object[0]);
            String QUOTATION_OPTIONS = SqlBundle.message((String)"settings.code.style.quotation", (Object[])new Object[0]);
            String[] QUOTE_UNQUOTE_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message((String)"settings.code.style.unquote", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.quote", (Object[])new Object[0])};
            String[] QUOTE_TYPE_ALL_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message((String)"settings.code.style.double.quotes.or.another", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.double.quotes.only", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.brackets.or.double.quotes", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.brackets.only", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.grave.accents.or.double.quotes", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.grave.accents.only", (Object[])new Object[0])};
            String[] QUOTE_TYPE_BR_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message((String)"settings.code.style.double.quotes.or.brackets", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.double.quotes.only", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.brackets.or.double.quotes", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.brackets.only", (Object[])new Object[0])};
            String[] QUOTE_TYPE_GA_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message((String)"settings.code.style.double.quotes.or.grave.accent", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.double.quotes.only", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.grave.accents.or.double.quotes", (Object[])new Object[0]), SqlBundle.message((String)"settings.code.style.grave.accents.only", (Object[])new Object[0])};
            this.showSqlCustomOption(CASE_OPTIONS, "KEYWORD_CASE", SqlBundle.message((String)"settings.code.style.keywords", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "IDENTIFIER_CASE", SqlBundle.message((String)"settings.code.style.identifiers", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "TYPE_CASE", SqlBundle.message((String)"settings.code.style.types.builtin", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsAllCaseNames(), SqlCodeStyleConst.TOKEN_CASE_ALL);
            this.showSqlCustomOption(CASE_OPTIONS, "CUSTOM_TYPE_CASE", SqlBundle.message((String)"settings.code.style.types.custom", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsAllCaseNames(), SqlCodeStyleConst.TOKEN_CASE_ALL);
            this.showSqlCustomOption(CASE_OPTIONS, "ALIAS_CASE", SqlBundle.message((String)"settings.code.style.aliases", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsAliasCaseNames(), SqlCodeStyleConst.ALIAS_CASE_EXT);
            this.showSqlCustomOption(CASE_OPTIONS, "BUILT_IN_CASE", SqlBundle.message((String)"settings.code.style.builtIns", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsBuiltInsCaseNames(), SqlCodeStyleConst.TOKEN_CASE_BLT);
            this.showSqlCustomOption(CASE_OPTIONS, "QUOTED_IDENTIFIER_CASE", SqlBundle.message((String)"settings.code.style.quoted.identifiers", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "ORIGINAL_CASE", SqlBundle.message((String)"settings.code.style.use.original.case", (Object[])new Object[0]));
            this.showSqlCustomOption(QUOTATION_OPTIONS, "QUOTE_IDENTIFIER", SqlBundle.message((String)"settings.code.style.identifier.quotation", (Object[])new Object[0]), QUOTE_UNQUOTE_OPTIONS_NAMES, SqlCodeStyleConst.QUOTE_UNQUOTE_OPTIONS);
            if (SqlCodeStyleMainPanel.this.isGeneral()) {
                supportBrackets = true;
                supportGraveAccent = true;
            } else {
                SqlCodeStyleSettings s = this.getSqlSettings();
                supportBrackets = s.quotationSupportBrackets();
                supportGraveAccent = s.quotationSupportGraveAccent();
            }
            String[] quoteTypeNames = switch ((supportBrackets ? 1 : 0) + (supportGraveAccent ? 2 : 0)) {
                case 1 -> {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_BR_OPTIONS;
                    yield QUOTE_TYPE_BR_OPTIONS_NAMES;
                }
                case 2 -> {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_GA_OPTIONS;
                    yield QUOTE_TYPE_GA_OPTIONS_NAMES;
                }
                case 3 -> {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_ALL_OPTIONS;
                    yield QUOTE_TYPE_ALL_OPTIONS_NAMES;
                }
                default -> {
                    quoteTypeOptions = null;
                    yield null;
                }
            };
            if (quoteTypeOptions != null) {
                this.showSqlCustomOption(QUOTATION_OPTIONS, "QUOTE_TYPE", SqlBundle.message((String)"settings.code.style.quotation.character", (Object[])new Object[0]), quoteTypeNames, quoteTypeOptions);
            }
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"settings.code.style.case", (Object[])new Object[0]);
            if (string == null) {
                CasePanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$CasePanel", "getTabTitle"));
        }
    }

    public class QueriesPanel
    extends OptionsPanel {
        public QueriesPanel(SqlCodeStyleMainPanel this$0, CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.QUERIES_SETTINGS;
        }

        protected void initTables() {
            String SECTION_QUERY = SqlBundle.message((String)"settings.code.style.common", (Object[])new Object[0]);
            String SECTION_INSERT = SqlBundle.message((String)"settings.code.style.insert.statement.and.values.clause", (Object[])new Object[0]);
            String SECTION_SET = SqlBundle.message((String)"settings.code.style.update.statement", (Object[])new Object[0]);
            String SECTION_WITH = SqlBundle.message((String)"settings.code.style.with.clause", (Object[])new Object[0]);
            String SECTION_SELECT = SqlBundle.message((String)"settings.code.style.select.clause", (Object[])new Object[0]);
            String SECTION_FROM = SqlBundle.message((String)"settings.code.style.from.clause", (Object[])new Object[0]);
            String SECTION_WHERE = SqlBundle.message((String)"settings.code.style.where.and.having.clauses", (Object[])new Object[0]);
            String SECTION_ORDER = SqlBundle.message((String)"settings.code.style.group.by.and.order.by.clauses", (Object[])new Object[0]);
            String SECTION_SUBQUERY = SqlBundle.message((String)"settings.code.style.subquery", (Object[])new Object[0]);
            String[] msgs1stWordAlignNames = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgToLeft(), SqlBundle.message((String)"settings.code.style.to.left.with.indent", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgToRight()};
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_SECTION_1ST_WORD_ALIGN", SqlBundle.message((String)"settings.code.style.align.the.first.word.of.clause", (Object[])new Object[0]), msgs1stWordAlignNames, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_EL_LINE", SqlCodeStyleMainPanel.msgElCommonLineSettingName(), SqlCodeStyleMainPanel.msgsElCommonLineNames(), SqlCodeStyleConst.EL_COMMON_LINE_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_IN_ONE_STRING", SqlBundle.message((String)"settings.code.style.collapse.short.statement", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsQueryInOneStringNames(), SqlCodeStyleConst.QUERY_IN_ONE_STRING_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_TRUE_INDENT", SqlBundle.message((String)"settings.code.style.keep.section.elements.under.section.header", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_ALIGN_ELEMENTS", SqlBundle.message((String)"settings.code.style.align.section.elements", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_ALIGN_LINE_COMMENTS", SqlBundle.message((String)"settings.code.style.align.line.comments.at.right.of.elements", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_INTO_NL", SqlBundle.message((String)"settings.code.style.place.into.on.the.new.line", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_TABLE_EL_LINE", SqlBundle.message((String)"settings.code.style.place.into.clause.elements.on", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_VALUES_EL_LINE", SqlBundle.message((String)"settings.code.style.place.values.clause.elements.rows.on", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_CONTENT", SqlBundle.message((String)"settings.code.style.place.columns.or.values", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesFromBegin(), SqlCodeStyleConst.CLOSING_VALUES_FROM_BEGIN);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_EL_WRAP", SqlBundle.message((String)"settings.code.style.wrap.columns.or.values", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_SPACE_WITHIN_PARENTHESES", SqlBundle.message((String)"settings.code.style.put.spaces.within.parentheses", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_COLLAPSE_MULTI_ROW_VALUES", SqlBundle.message((String)"settings.code.style.collapse.short.multi.row.values", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_MATRIX_ALIGN", SqlBundle.message((String)"settings.code.style.insertMatrix.align", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_MATRIX_INCLUDING_HEADER", SqlBundle.message((String)"settings.code.style.insertMatrix.align.including.header", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_MATRIX_MODE", SqlBundle.message((String)"settings.code.style.insertMatrix.mode", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsInsertMatrixModeNames(), SqlCodeStyleConst.INSERT_MATRIX_MODE_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_MATRIX_MIN_WIDENING_THRESHOLD", SqlBundle.message((String)"settings.code.style.insertMatrix.min.widening.threshold", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsInsertMatrixMinWideningThresholdNames(), SqlCodeStyleConst.INSERT_MATRIX_MIN_WIDENING_THRESHOLD_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_MATRIX_BREAK_THRESHOLD", SqlBundle.message((String)"settings.code.style.insertMatrix.break.threshold", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsInsertMatrixBreakThresholdNames(), SqlCodeStyleConst.INSERT_MATRIX_BREAK_THRESHOLD_VALUES);
            this.showSqlCustomOption(SECTION_SET, "SET_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SET, "SET_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_SET, "SET_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_SET, "SET_ALIGN_EQUAL_SIGN", SqlBundle.message((String)"settings.code.style.align.equals", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_WRAP", SqlBundle.message((String)"settings.code.style.wrap.subqueries", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames2(), SqlCodeStyleConst.EL_WRAP_VALUES_2);
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesM(), SqlCodeStyleConst.EL_COMMA_VALUES_M);
            this.showSqlCustomOption(SECTION_WITH, "WITH_ALIGN_AS", SqlBundle.message((String)"settings.code.style.align.as", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_NEW_LINE_AFTER_ALL_DISTINCT", SqlBundle.message((String)"settings.code.style.new.line.after.all.distinct", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_KEEP_N_ITEMS_IN_LINE", SqlBundle.message((String)"settings.code.style.keep.elements.on.one.line.if.less", (Object[])new Object[0]), SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_NAMES, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_USE_AS_WORD", SqlBundle.message((String)"settings.code.style.use.as", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsSelectUseAsNames(), SqlCodeStyleConst.SELECT_USE_AS_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_ALIGN_AS", SqlBundle.message((String)"settings.code.style.align.as", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_ASTERISK_REGULAR", SqlBundle.message((String)"settings.code.style.select.asterisk.regular", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_JOIN_1", SqlBundle.message((String)"settings.code.style.wrap.the.first.join", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_JOIN_2", SqlBundle.message((String)"settings.code.style.wrap.the.next.join", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_INDENT_JOIN", SqlBundle.message((String)"settings.code.style.indent.join", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_ONLY_JOIN_INDENT", SqlBundle.message((String)"settings.code.style.place.join.in.join-only.queries.under", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsFromOnlyJoinIndentNames(), SqlCodeStyleConst.FROM_ONLY_JOIN_INDENT_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_ALIGN_JOIN_TABLES", SqlBundle.message((String)"settings.code.style.align.joined.tables", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_ALIGN_ALIASES", SqlBundle.message((String)"settings.code.style.align.table.aliases", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_ON", SqlBundle.message((String)"settings.code.style.wrap.on.using", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_PLACE_ON", SqlBundle.message((String)"settings.code.style.place.on.using.under", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsFromPlaceOnNames(), SqlCodeStyleConst.FROM_PLACE_ON_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_BOUND", SqlBundle.message((String)"settings.code.style.place.top.level.and.or", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_ALIGN_ASC_DESC", SqlBundle.message((String)"settings.code.style.align.asc.desc", (Object[])new Object[0]));
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_CONTENT", SqlBundle.message((String)"settings.code.style.place.subquery", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_PAR_SPACE_BEFORE", SqlBundle.message((String)"settings.code.style.put.spaces.before.parenthesis", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_PAR_SPACE_INSIDE", SqlBundle.message((String)"settings.code.style.put.spaces.within.parentheses", (Object[])new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"settings.code.style.queries", (Object[])new Object[0]);
            if (string == null) {
                QueriesPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$QueriesPanel", "getTabTitle"));
        }
    }

    public class DdlPanel
    extends OptionsPanel {
        public DdlPanel(SqlCodeStyleMainPanel this$0, CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.DDL_SETTINGS;
        }

        protected void initTables() {
            String TABLE_CREATE = SqlBundle.message((String)"settings.code.style.table.create", (Object[])new Object[0]);
            String TABLE_ALTER = SqlBundle.message((String)"settings.code.style.table.alter", (Object[])new Object[0]);
            String TABLE_CREATE_ALTER = SqlBundle.message((String)"settings.code.style.table.create.alter", (Object[])new Object[0]);
            String CREATE_SCHEMA = SqlBundle.message((String)"settings.code.style.create.schema", (Object[])new Object[0]);
            String CONSTRAINT = SqlBundle.message((String)"settings.code.style.constraint", (Object[])new Object[0]);
            String VIEW = SqlBundle.message((String)"settings.code.style.views", (Object[])new Object[0]);
            String POSTFIX_OPTION = SqlBundle.message((String)"settings.code.style.postfix.options", (Object[])new Object[0]);
            this.showSqlCustomOption(TABLE_CREATE, "TABLE_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(TABLE_CREATE, "TABLE_CONTENT", SqlCodeStyleMainPanel.msgContentSettingName(), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(TABLE_CREATE, "TABLE_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(TABLE_CREATE, "TABLE_COLLAPSE", SqlBundle.message((String)"settings.code.style.collapse.when.short", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_INSTRUCTION_WRAP", SqlBundle.message((String)"settings.code.style.alter.instruction.wrap", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_INSTRUCTION_INDENT", SqlBundle.message((String)"settings.code.style.alter.instruction.indent", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_INSTRUCTION_ALIGN", SqlBundle.message((String)"settings.code.style.alter.instruction.align", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_ITEM_WRAP", SqlBundle.message((String)"settings.code.style.alter.item.wrap", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_ITEM_INDENT", SqlBundle.message((String)"settings.code.style.alter.item.indent", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_ALTER, "TABLE_ALTER_ITEM_ALIGN", SqlBundle.message((String)"settings.code.style.alter.item.align", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_CREATE_ALTER, "TABLE_TYPES_ALIGN", SqlBundle.message((String)"settings.code.style.align.types", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_CREATE_ALTER, "TABLE_DEFAULTS_ALIGN", SqlBundle.message((String)"settings.code.style.align.defaults", (Object[])new Object[0]));
            this.showSqlCustomOption(TABLE_CREATE_ALTER, "TABLE_NULLABILITIES_ALIGN", SqlBundle.message((String)"settings.code.style.align.nullabilities", (Object[])new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_1", SqlBundle.message((String)"settings.code.style.wrap.constraint", (Object[])new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_2", SqlBundle.message((String)"settings.code.style.wrap.key.check", (Object[])new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_3", SqlBundle.message((String)"settings.code.style.wrap.references", (Object[])new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_4", SqlBundle.message((String)"settings.code.style.wrap.cascade.and.deferrability", (Object[])new Object[0]));
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_CONTENT_INDENT", SqlBundle.message((String)"settings.code.style.indent.content", (Object[])new Object[0]));
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_BLANK_LINES_MIN", SqlBundle.message((String)"settings.code.style.minimum.blank.lines.between.declaration", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_BLANK_LINES_MAX", SqlBundle.message((String)"settings.code.style.maximum.blank.lines.between.declaration", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(VIEW, "VIEW_WRAP_AS", SqlBundle.message((String)"settings.code.style.wrap.as", (Object[])new Object[0]));
            this.showSqlCustomOption(VIEW, "VIEW_WRAP_QUERY", SqlBundle.message((String)"settings.code.style.wrap.the.beginning.of.the.query", (Object[])new Object[0]));
            this.showSqlCustomOption(VIEW, "VIEW_INDENT_QUERY", SqlBundle.message((String)"settings.code.style.indent.query", (Object[])new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_WRAP_1", SqlBundle.message((String)"settings.code.style.wrap.first.option", (Object[])new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_WRAP_2", SqlBundle.message((String)"settings.code.style.wrap.next.option", (Object[])new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_INDENT", SqlBundle.message((String)"settings.code.style.indent.options", (Object[])new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_ALIGN", SqlBundle.message((String)"settings.code.style.align.options", (Object[])new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"code.style.ui.ddl", (Object[])new Object[0]);
            if (string == null) {
                DdlPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$DdlPanel", "getTabTitle"));
        }
    }

    public class CodePanel
    extends OptionsPanel {
        public CodePanel(SqlCodeStyleMainPanel this$0, CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CODE_SETTINGS;
        }

        protected void initTables() {
            String SCRIPT = SqlBundle.message((String)"settings.code.style.script", (Object[])new Object[0]);
            String COMMON = SqlBundle.message((String)"settings.code.style.imp.common", (Object[])new Object[0]);
            String DECLARE = SqlBundle.message((String)"settings.code.style.declared.variables", (Object[])new Object[0]);
            String ROUTINE_ARG = SqlBundle.message((String)"settings.code.style.routine.arguments", (Object[])new Object[0]);
            String ROUTINE_BLOCK = SqlBundle.message((String)"settings.code.style.routine.statement", (Object[])new Object[0]);
            String FORK = SqlBundle.message((String)"settings.code.style.if.then.else", (Object[])new Object[0]);
            String LOOP = SqlBundle.message((String)"settings.code.style.loops", (Object[])new Object[0]);
            this.showSqlCustomOption(SCRIPT, "SCRIPT_STMT_SEMICOLON_WRAP", SqlBundle.message((String)"settings.code.style.script.semicolon.wrap", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(SCRIPT, "SCRIPT_STMT_FOLLOWS_BLANK_LINE", SqlBundle.message((String)"settings.code.style.script.follows.blank.line", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(COMMON, "IMP_COMMON_WRAP_EVERY_STATEMENT", SqlBundle.message((String)"settings.code.style.wrap.every.statement", (Object[])new Object[0]));
            this.showSqlCustomOption(COMMON, "IMP_COMMON_KEEP_BLANK_LINES_IN_CODE", SqlBundle.message((String)"settings.code.style.keep.blank.lines.in.code", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_CONTENT_WRAP", SqlBundle.message((String)"settings.code.style.wrap.section", (Object[])new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_EL_WRAP", SqlBundle.message((String)"settings.code.style.wrap.variables", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_TYPE", SqlBundle.message((String)"settings.code.style.align.types", (Object[])new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_EQ", SqlBundle.message((String)"settings.code.style.align.assignments", (Object[])new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_DEFAULT", SqlBundle.message((String)"settings.code.style.align.expressions", (Object[])new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_LINE_COMMENTS", SqlBundle.message((String)"settings.code.style.align.lineComments", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_CONTENT", SqlCodeStyleMainPanel.msgContentSettingName(), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_SPACE_WITHIN_PARENTHESES", SqlBundle.message((String)"settings.code.style.put.spaces.within.parentheses", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_ALIGN_TYPES", SqlBundle.message((String)"settings.code.style.align.types", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_AS_WRAP", SqlBundle.message((String)"settings.code.style.wrap.as", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_L_QUOTE_WRAP_BEFORE", SqlBundle.message((String)"settings.code.style.wrap.opening", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_L_QUOTE_WRAP_AFTER", SqlBundle.message((String)"settings.code.style.wrap.the.content.after.opening", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_R_QUOTE_WRAP_BEFORE", SqlBundle.message((String)"settings.code.style.wrap.before.closing", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_R_QUOTE_WRAP_AFTER", SqlBundle.message((String)"settings.code.style.wrap.options.after.closing", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_THEN", SqlBundle.message((String)"settings.code.style.wrap.then", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_ELSE", SqlBundle.message((String)"settings.code.style.wrap.else", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_INNER", SqlBundle.message((String)"settings.code.style.wrap.inner.code", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_INDENT_THEN_ELSE", SqlBundle.message((String)"settings.code.style.indent.then.and.else", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_INDENT_END", SqlBundle.message((String)"settings.code.style.indent.end.if", (Object[])new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_COLLAPSE", SqlBundle.message((String)"settings.code.style.collapse.when.short", (Object[])new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_LOOP_WRAP", SqlBundle.message((String)"settings.code.style.wrap.loop", (Object[])new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_LOOP_INDENT", SqlBundle.message((String)"settings.code.style.indent.loop", (Object[])new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_END_INDENT", SqlBundle.message((String)"settings.code.style.indent.end.loop", (Object[])new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_COLLAPSE", SqlBundle.message((String)"settings.code.style.collapse.when.short", (Object[])new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"settings.code.style.code", (Object[])new Object[0]);
            if (string == null) {
                CodePanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$CodePanel", "getTabTitle"));
        }
    }

    public class ExpressionsPanel
    extends OptionsPanel {
        public ExpressionsPanel(SqlCodeStyleMainPanel this$0, CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.EXPRESSIONS_SETTINGS;
        }

        protected void initTables() {
            String CORTEGE = SqlBundle.message((String)"settings.code.style.cortege", (Object[])new Object[0]);
            String BINARY_EXPRESSION = SqlBundle.message((String)"settings.code.style.binary.expression", (Object[])new Object[0]);
            String ROUTINE_CALL = SqlBundle.message((String)"settings.code.style.function.or.procedure.call", (Object[])new Object[0]);
            String CASE_CLAUSE = SqlBundle.message((String)"settings.code.style.case.clause", (Object[])new Object[0]);
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_BEFORE_L_PAREN", SqlBundle.message((String)"settings.code.style.add.space.before.left.parentheses", (Object[])new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_WITHIN_PARENTHESES", SqlBundle.message((String)"settings.code.style.space.within.parentheses", (Object[])new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_COMMA_1ST", SqlBundle.message((String)"settings.code.style.place.comma.to.begin", (Object[])new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_BEFORE_COMMA", SqlBundle.message((String)"settings.code.style.space.before.comma", (Object[])new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_AFTER_COMMA", SqlBundle.message((String)"settings.code.style.space.after.comma", (Object[])new Object[0]));
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_SPACE_AROUND_OPERATOR", SqlBundle.message((String)"settings.code.style.use.spaces.around.operators", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_BINARY_OP_ALIGN", SqlBundle.message((String)"settings.code.style.align.operands.in.binary.expressions", (Object[])new Object[0]));
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_SPACE_WITHIN_PARENTHESES", SqlBundle.message((String)"settings.code.style.space.within.parenthesized.sub.expressions", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_INSIDE_PARENTHESES", SqlBundle.message((String)"settings.code.style.space.within.parentheses", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_BEFORE_COMMA", SqlBundle.message((String)"settings.code.style.space.before.comma", (Object[])new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_AFTER_COMMA", SqlBundle.message((String)"settings.code.style.space.after.comma", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_WHEN_WRAP", SqlBundle.message((String)"settings.code.style.wrap.when", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_WHEN_INDENT", SqlBundle.message((String)"settings.code.style.indent.when.if.wrapped", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_THEN_WRAP", SqlBundle.message((String)"settings.code.style.wrap.then", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_THEN_ALIGN", SqlBundle.message((String)"settings.code.style.align.then", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_ELSE_ALIGN_THEN", SqlBundle.message((String)"settings.code.style.align.else.under.then.when.then.aligned", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_END", SqlBundle.message((String)"settings.code.style.align.end", (Object[])new Object[0]), SqlCodeStyleMainPanel.msgsExprCaseEndAlignNames(), SqlCodeStyleConst.EXPR_CASE_END_ALIGN_VALUES);
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_KEEP_NL_AFTER_THEN", SqlBundle.message((String)"settings.code.style.keep.new.line.after.then.else", (Object[])new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_COLLAPSE", SqlBundle.message((String)"settings.code.style.collapse.short.clause", (Object[])new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"settings.code.style.expressions", (Object[])new Object[0]);
            if (string == null) {
                ExpressionsPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$ExpressionsPanel", "getTabTitle"));
        }
    }

    private class SqlIndentOptionsWrapper
    extends TabbedLanguageCodeStylePanel.MyIndentOptionsWrapper
    implements SqlSettingsPanel {
        protected SqlIndentOptionsWrapper(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings, (IndentOptionsEditor)new SmartIndentOptionsEditor());
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.INDENT_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        @Override
        public void updatePreviewText(@NotNull String text) {
            if (text == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(0);
            }
            this.setEditorText(text, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
            if (project == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(1);
            }
            if (text == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(2);
            }
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text);
        }

        protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(3);
            }
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return SqlCodeStyleMainPanel.this.getSqlSettings(settings).getCorrespondedIndentOptions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$SqlIndentOptionsWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePreviewText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFileFromText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlighter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SqlWrappingAndBracesPanel
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel
    implements SqlSettingsPanel {
        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message((String)"settings.code.style.wrapping", (Object[])new Object[0]);
            if (string == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.WRAPPING_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected int getRightMargin() {
            return 80;
        }

        SqlWrappingAndBracesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        @Override
        public void updatePreviewText(@NotNull String text) {
            if (text == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(1);
            }
            this.setEditorText(text, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
            if (project == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(2);
            }
            if (text == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(3);
            }
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text);
        }

        protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(4);
            }
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected void initTables() {
            this.addOption("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP);
            this.addOption("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP);
            this.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }

        protected void customizeSettings() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$SqlWrappingAndBracesPanel";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$SqlWrappingAndBracesPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePreviewText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileFromText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyTreeKeyboardListener
    extends KeyAdapter {
        private final TreeTable myTreeTable;

        private MyTreeKeyboardListener(TreeTable treeTable) {
            this.myTreeTable = treeTable;
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.isControlDown()) {
                boolean handled = true;
                int keyCode = ev.getKeyCode();
                if (keyCode == 45 || keyCode == 109) {
                    this.collapseAll();
                } else if (keyCode == 521 || keyCode == 107) {
                    this.expandAll();
                } else {
                    handled = false;
                }
                if (handled) {
                    ev.consume();
                }
            }
        }

        private void collapseAll() {
            TreeTableTree tree = this.myTreeTable.getTree();
            int n = tree.getRowCount();
            for (int i = n - 2; i >= 0; --i) {
                tree.collapseRow(i);
            }
        }

        private void expandAll() {
            TreeTableTree tree = this.myTreeTable.getTree();
            int n = tree.getRowCount();
            for (int i = n - 1; i >= 0; --i) {
                tree.expandRow(i);
            }
        }
    }

    public abstract class OptionsPanel
    extends OptionTableWithPreviewPanel
    implements SqlSettingsPanel {
        public OptionsPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        @Override
        public abstract SqlCodeStyleSettingsType getType();

        public Language getDefaultLanguage() {
            return SqlCodeStyleMainPanel.this.getPreviewDialect();
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            SqlCodeStyleSettingsType type = this.getType();
            return type.commonType != null ? type.commonType : LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
        }

        private boolean isSettingHidden(@NotNull String settingName) {
            if (settingName == null) {
                OptionsPanel.$$$reportNull$$$0(0);
            }
            return this.getSqlSettings().isSettingHidden(settingName);
        }

        @NotNull
        protected SqlCodeStyleSettings getSqlSettings() {
            SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)this.getSettings().getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass());
            if (sqlCodeStyleSettings == null) {
                OptionsPanel.$$$reportNull$$$0(1);
            }
            return sqlCodeStyleSettings;
        }

        protected TreeTable createOptionsTree(CodeStyleSettings settings) {
            TreeTable optionsTree = super.createOptionsTree(settings);
            optionsTree.addKeyListener((KeyListener)new MyTreeKeyboardListener(optionsTree));
            return optionsTree;
        }

        protected void showSqlCustomOption(@Nls String groupName, String fieldName, @Nls String title) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[0]);
        }

        protected void showSqlCustomOption(@Nls String groupName, String fieldName, @Nls String title, String[] names, int[] values) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[]{names, values});
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
            if (project == null) {
                OptionsPanel.$$$reportNull$$$0(2);
            }
            if (text == null) {
                OptionsPanel.$$$reportNull$$$0(3);
            }
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text);
        }

        @Override
        public void updatePreviewText(@NotNull String text) {
            if (text == null) {
                OptionsPanel.$$$reportNull$$$0(4);
            }
            this.setEditorText(text, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                OptionsPanel.$$$reportNull$$$0(5);
            }
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$OptionsPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleMainPanel$OptionsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSettingHidden";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileFromText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePreviewText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface SqlSettingsPanel {
        public SqlCodeStyleSettingsType getType();

        public void updatePreviewText(@NotNull String var1);
    }
}

