/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.codeStyle.JsPrettierCodeStyleConfiguratorKt;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleConfigurator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/prettierjs/codeStyle/JsPrettierCodeStyleConfigurator;", "T", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleConfigurator;", "customSettingsClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "applySettings", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "prettierConfig", "Lcom/intellij/prettierjs/PrettierConfig;", "isApplied", "", "intellij.prettierJS"})
public final class JsPrettierCodeStyleConfigurator<T extends JSCodeStyleSettings>
implements PrettierCodeStyleConfigurator {
    @NotNull
    private final Class<T> customSettingsClass;

    public JsPrettierCodeStyleConfigurator(@NotNull Class<T> customSettingsClass) {
        Intrinsics.checkNotNullParameter(customSettingsClass, (String)"customSettingsClass");
        this.customSettingsClass = customSettingsClass;
    }

    @Override
    public void applySettings(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile, @NotNull PrettierConfig prettierConfig2) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)prettierConfig2, (String)"prettierConfig");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(this.customSettingsClass);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        CustomCodeStyleSettings customCodeStyleSettings2 = customCodeStyleSettings;
        JSCodeStyleSettings $this$applySettings_u24lambda_u240 = (JSCodeStyleSettings)customCodeStyleSettings2;
        boolean bl = false;
        $this$applySettings_u24lambda_u240.USE_DOUBLE_QUOTES = !prettierConfig2.singleQuote;
        $this$applySettings_u24lambda_u240.USE_SEMICOLON_AFTER_STATEMENT = prettierConfig2.semi;
        $this$applySettings_u24lambda_u240.SPACES_WITHIN_OBJECT_LITERAL_BRACES = prettierConfig2.bracketSpacing;
        $this$applySettings_u24lambda_u240.SPACES_WITHIN_OBJECT_TYPE_BRACES = prettierConfig2.bracketSpacing;
        $this$applySettings_u24lambda_u240.SPACES_WITHIN_IMPORTS = prettierConfig2.bracketSpacing;
        PrettierConfig.TrailingCommaOption trailingCommaOption = prettierConfig2.trailingComma;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)trailingCommaOption), (String)"trailingComma");
        $this$applySettings_u24lambda_u240.ENFORCE_TRAILING_COMMA = JsPrettierCodeStyleConfiguratorKt.access$convertTrailingCommaOption(trailingCommaOption);
        $this$applySettings_u24lambda_u240.FORCE_QUOTE_STYlE = true;
        $this$applySettings_u24lambda_u240.FORCE_SEMICOLON_STYLE = true;
        $this$applySettings_u24lambda_u240.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplied(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile, @NotNull PrettierConfig prettierConfig2) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)prettierConfig2, (String)"prettierConfig");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(this.customSettingsClass);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        JSCodeStyleSettings customSettings = (JSCodeStyleSettings)customCodeStyleSettings;
        if (customSettings.USE_DOUBLE_QUOTES != !prettierConfig2.singleQuote) return false;
        if (customSettings.USE_SEMICOLON_AFTER_STATEMENT != prettierConfig2.semi) return false;
        if (customSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES != prettierConfig2.bracketSpacing) return false;
        if (customSettings.SPACES_WITHIN_OBJECT_TYPE_BRACES != prettierConfig2.bracketSpacing) return false;
        if (customSettings.SPACES_WITHIN_IMPORTS != prettierConfig2.bracketSpacing) return false;
        JSCodeStyleSettings.TrailingCommaOption trailingCommaOption = customSettings.ENFORCE_TRAILING_COMMA;
        PrettierConfig.TrailingCommaOption trailingCommaOption2 = prettierConfig2.trailingComma;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)trailingCommaOption2), (String)"trailingComma");
        if (trailingCommaOption != JsPrettierCodeStyleConfiguratorKt.access$convertTrailingCommaOption(trailingCommaOption2)) return false;
        if (!customSettings.FORCE_QUOTE_STYlE) return false;
        if (!customSettings.FORCE_SEMICOLON_STYLE) return false;
        if (customSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH) return false;
        return true;
    }
}

