/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost;

import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.util.ApplicationKt;
import com.intellij.util.net.ssl.InitialUntrustedCertificateStrategyProvider;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import com.intellij.util.net.ssl.UntrustedCertificateStrategyWithReason;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/UnattendedHostInitialUntrustedCertificateStrategyProvider;", "Lcom/intellij/util/net/ssl/InitialUntrustedCertificateStrategyProvider;", "<init>", "()V", "getStrategy", "Lcom/intellij/util/net/ssl/UntrustedCertificateStrategyWithReason;", "Companion", "intellij.platform.remoteController.backend"})
public final class UnattendedHostInitialUntrustedCertificateStrategyProvider
implements InitialUntrustedCertificateStrategyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String certificateCheckIsRejectedMessage = "Certificate check is rejected. \nWe were unable to process modal certificate check request because no user is connected.\nPlease, follow the instruction below if you want request to be allowed automatically:\n\n- Under Linux all certificates in .crt (PEM) format from the following locations are imported:\n  /etc/ssl/certs/*\n  /etc/pki/tls/certs/*\n  /system/etc/security/cacerts/*\n  /etc/ssl/certs/ca-certificates.crt\n  /etc/pki/tls/certs/ca-bundle.crt\n  /etc/ssl/ca-bundle.pem\n  /etc/pki/tls/cacert.pem\n  /etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem\n  /etc/ssl/cert.pem\n  \n  See https://github.com/JetBrains/jvm-native-trusted-roots/blob/trunk/src/main/java/org/jetbrains/nativecerts/linux/LinuxTrustedCertificatesUtil.java\n  \n- Under Mac OS X, the code calls system functions to get system-wide and user-specific custom trusted certificates.\n  See https://github.com/JetBrains/jvm-native-trusted-roots/blob/trunk/src/main/java/org/jetbrains/nativecerts/mac/SecurityFrameworkUtil.java\n\n- Under Windows, the code calls system functions to get system-wide, user-specific or group-policy distributed trusted certificates.\n  See https://github.com/JetBrains/jvm-native-trusted-roots/blob/trunk/src/main/java/org/jetbrains/nativecerts/win32/Crypt32Ext.java\n";

    @NotNull
    public UntrustedCertificateStrategyWithReason getStrategy() {
        if (!AppMode.isRemoteDevHost()) {
            String notUnattendedModeText = "Host is not in an unattended mode. Allowing modal certificate check";
            return new UntrustedCertificateStrategyWithReason(UntrustedCertificateStrategy.ASK_USER, notUnattendedModeText);
        }
        if (UtilKt.getControllerSessionOrNull((Application)ApplicationKt.getApplication()) == null) {
            String rejectReason = "Controller is not connected. " + certificateCheckIsRejectedMessage;
            return new UntrustedCertificateStrategyWithReason(UntrustedCertificateStrategy.REJECT, rejectReason);
        }
        String askReason = "Controller is connected. Allowing modal certificate check";
        return new UntrustedCertificateStrategyWithReason(UntrustedCertificateStrategy.ASK_USER, askReason);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/UnattendedHostInitialUntrustedCertificateStrategyProvider$Companion;", "", "<init>", "()V", "certificateCheckIsRejectedMessage", "", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

