/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.text.StringKt;
import com.jetbrains.rdserver.unattendedHost.UnattendedStatusUtil;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/UnattendedHostStatusHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "PREFIX", "", "STATUS_PREFIX", "TOKEN_VARIABLE_NAME", "token", "", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostStatusHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostStatusHandler.kt\ncom/jetbrains/rdserver/unattendedHost/UnattendedHostStatusHandler\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,69:1\n27#2:70\n87#2,2:71\n28#2,2:73\n98#2:75\n30#2:76\n90#2,6:77\n*S KotlinDebug\n*F\n+ 1 UnattendedHostStatusHandler.kt\ncom/jetbrains/rdserver/unattendedHost/UnattendedHostStatusHandler\n*L\n42#1:70\n42#1:71,2\n42#1:73,2\n42#1:75\n42#1:76\n42#1:77,6\n*E\n"})
public final class UnattendedHostStatusHandler
extends HttpRequestHandler {
    @NotNull
    private final String PREFIX;
    @NotNull
    private final String STATUS_PREFIX;
    @NotNull
    private final String TOKEN_VARIABLE_NAME;
    @Nullable
    private final byte[] token;

    public UnattendedHostStatusHandler() {
        byte[] byArray;
        String string;
        this.PREFIX = "/codeWithMe";
        this.STATUS_PREFIX = this.PREFIX + "/unattendedHostStatus";
        this.TOKEN_VARIABLE_NAME = "CWM_HOST_STATUS_OVER_HTTP_TOKEN";
        String string2 = StringKt.nullize((String)System.getProperty(this.TOKEN_VARIABLE_NAME), (boolean)true);
        if (string2 == null) {
            string2 = StringKt.nullize((String)System.getenv(this.TOKEN_VARIABLE_NAME), (boolean)true);
        }
        if ((string = string2) != null) {
            String string3 = string;
            byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        this.token = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)this.STATUS_PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.token != null ? !(this.token.length == 0) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SpanBuilder spanBuilder = TelemetryManager.Companion.getTracer(RdctScopesKt.RDCT).spanBuilder("rdct.reportHostStatus", TracerLevel.DEFAULT).setAttribute("type", "http.json");
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setAttribute(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            boolean bl;
            Throwable throwable;
            AutoCloseable autoCloseable;
            block18: {
                Map parameters;
                block17: {
                    byte[] providedToken;
                    Span span$iv = $this$useWithoutActiveScope$iv$iv;
                    boolean bl2 = false;
                    autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                    throwable = null;
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl3 = false;
                    Span span2 = span$iv;
                    boolean bl4 = false;
                    parameters = urlDecoder.parameters();
                    Object object = parameters;
                    if (object != null && (object = (List)object.get("token")) != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null && (object = StringKt.nullize((String)object, (boolean)true)) != null) {
                        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                        v4 = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    } else {
                        v4 = providedToken = null;
                    }
                    if (providedToken != null && this.token != null && MessageDigest.isEqual(providedToken, this.token)) break block17;
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
                    HttpResponse httpResponse = (HttpResponse)response;
                    Channel channel = context.channel();
                    Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                    Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
                    boolean bl5 = true;
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    boolean bl6 = bl5;
                    return bl6;
                }
                List list = (List)parameters.get("exit");
                boolean bl7 = list != null ? !((Collection)list).isEmpty() : false;
                if (!bl7) break block18;
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                HttpResponse httpResponse = (HttpResponse)response;
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
                ApplicationKt.getApplication().invokeLater(UnattendedHostStatusHandler::process$lambda$0$0, ModalityState.any());
                ApplicationKt.getApplication().invokeLater(() -> UnattendedHostStatusHandler.process$lambda$0$1(parameters), ModalityState.nonModal());
                boolean bl8 = true;
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                boolean bl9 = bl8;
                return bl9;
            }
            try {
                String statusInfo = UnattendedStatusUtil.INSTANCE.getStatusJson();
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(statusInfo), (Charset)Charsets.UTF_8));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
                HttpResponse httpResponse = (HttpResponse)response;
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
                bl = true;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw throwable3;
                    }
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            boolean bl10 = bl;
            return bl10;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    private static final void process$lambda$0$0() {
        LaterInvocator.forceLeaveAllModals((String)"UnattendedHostStatusHandler requested exit");
    }

    private static final void process$lambda$0$1(Map $parameters) {
        List list = (List)$parameters.get("restart");
        ApplicationKt.getApplication().exit(true, true, list != null ? !((Collection)list).isEmpty() : false);
    }
}

