/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.metrics;

import com.jetbrains.rdserver.unattendedHost.metrics.CGroupMetricsReader;
import com.jetbrains.rdserver.unattendedHost.metrics.MemoryStatQuery;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupV2MetricsReader;", "Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupMetricsReader;", "<init>", "()V", "isAcceptable", "", "()Z", "isAcceptable$delegate", "Lkotlin/Lazy;", "getMemoryUsed", "", "()Ljava/lang/Long;", "getAvailableMemory", "getMemoryStatFile", "Ljava/io/File;", "Companion", "intellij.platform.remoteController.backend"})
public final class CGroupV2MetricsReader
extends CGroupMetricsReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isAcceptable$delegate = LazyKt.lazy(CGroupV2MetricsReader::isAcceptable_delegate$lambda$0);
    @NotNull
    private static final CGroupV2MetricsReader INSTANCE = new CGroupV2MetricsReader();
    @NotNull
    private static final String MEMORY_STAT_FILE = "/sys/fs/cgroup/memory.stat";
    @NotNull
    private static final String MEMORY_CURRENT_FILE = "/sys/fs/cgroup/memory.current";
    @NotNull
    private static final String MEMORY_MAX_FILE = "/sys/fs/cgroup/memory.max";

    @Override
    public boolean isAcceptable() {
        Lazy lazy = this.isAcceptable$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @Nullable
    public Long getMemoryUsed() {
        Long l = this.getInfoFromMemoryStatFile((Function1<? super MemoryStatQuery, Unit>)((Function1)CGroupV2MetricsReader::getMemoryUsed$lambda$0));
        if (l == null) {
            l = this.readLong(new File(MEMORY_CURRENT_FILE));
        }
        return l;
    }

    @Override
    @Nullable
    public Long getAvailableMemory() {
        Long memoryMax = this.readLong(new File(MEMORY_MAX_FILE));
        OperatingSystemMXBean operatingSystemMXBean = this.getMxBean();
        Long totalMemorySize = operatingSystemMXBean != null ? Long.valueOf(operatingSystemMXBean.getTotalMemorySize()) : null;
        return this.getMinOrOneOf(memoryMax, totalMemorySize);
    }

    @Override
    @NotNull
    public File getMemoryStatFile() {
        return new File(MEMORY_STAT_FILE);
    }

    private static final boolean isAcceptable_delegate$lambda$0() {
        return new File(MEMORY_STAT_FILE).exists();
    }

    private static final Unit getMemoryUsed$lambda$0(MemoryStatQuery $this$getInfoFromMemoryStatFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getInfoFromMemoryStatFile, (String)"$this$getInfoFromMemoryStatFile");
        $this$getInfoFromMemoryStatFile.unaryPlus("anon");
        $this$getInfoFromMemoryStatFile.unaryPlus("shmem");
        $this$getInfoFromMemoryStatFile.unaryPlus("file");
        $this$getInfoFromMemoryStatFile.unaryMinus("inactive_file");
        $this$getInfoFromMemoryStatFile.unaryMinus("slab_reclaimable");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupV2MetricsReader$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupV2MetricsReader;", "getINSTANCE", "()Lcom/jetbrains/rdserver/unattendedHost/metrics/CGroupV2MetricsReader;", "MEMORY_STAT_FILE", "", "MEMORY_CURRENT_FILE", "MEMORY_MAX_FILE", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CGroupV2MetricsReader getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

