/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.styledComponents;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0001H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\b0\b0\nH\u0000\u001a\u0016\u0010\f\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\r0\r0\nH\u0000\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0000\u001a\u0016\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a/\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00012\u0006\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0018\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"taggedTemplate", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/lang/javascript/psi/ecma6/JSStringTemplateExpression;", "name", "", "tagPattern", "Lcom/intellij/lang/javascript/psi/JSExpression;", "withReferenceName", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "referenceExpression", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "kotlin.jvm.PlatformType", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "withNameStartingWith", "names", "", "getReferenceParts", "jsReferenceExpression", "jsxAttribute", "Lcom/intellij/psi/PsiElement;", "jsxBodyText", "tagName", "attributeNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/patterns/ElementPattern;", "intellij.styled.components"})
public final class PatternsKt {
    @NotNull
    public static final ElementPattern<JSStringTemplateExpression> taggedTemplate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiElementPattern psiElementPattern = PatternsKt.referenceExpression().withText(name);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern, (String)"withText(...)");
        return PatternsKt.taggedTemplate((ElementPattern<? extends JSExpression>)((ElementPattern)psiElementPattern));
    }

    @NotNull
    public static final ElementPattern<JSStringTemplateExpression> taggedTemplate(@NotNull ElementPattern<? extends JSExpression> tagPattern) {
        Intrinsics.checkNotNullParameter(tagPattern, (String)"tagPattern");
        TreeElementPattern treeElementPattern = PlatformPatterns.psiElement(JSStringTemplateExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(ES6TaggedTemplateExpression.class).withChild(tagPattern));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        return (ElementPattern)treeElementPattern;
    }

    @NotNull
    public static final ElementPattern<JSReferenceExpression> withReferenceName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ObjectPattern objectPattern = PatternsKt.referenceExpression().with((PatternCondition)new PatternCondition<JSReferenceExpression>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super("referenceName");
            }

            public boolean accepts(JSReferenceExpression referenceExpression, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)this.$name);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (ElementPattern)objectPattern;
    }

    @NotNull
    public static final PsiElementPattern.Capture<JSReferenceExpression> referenceExpression() {
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(JSReferenceExpression.class);
        Intrinsics.checkNotNull((Object)capture);
        return capture;
    }

    @NotNull
    public static final PsiElementPattern.Capture<JSCallExpression> callExpression() {
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(JSCallExpression.class);
        Intrinsics.checkNotNull((Object)capture);
        return capture;
    }

    @NotNull
    public static final ElementPattern<JSReferenceExpression> withNameStartingWith(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        ObjectPattern objectPattern = PatternsKt.referenceExpression().with((PatternCondition)new PatternCondition<JSReferenceExpression>(names){
            final /* synthetic */ List<String> $names;
            {
                this.$names = $names;
                super("nameStartingWith");
            }

            public boolean accepts(JSReferenceExpression referenceExpression, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return ContainerUtil.startsWith(PatternsKt.getReferenceParts(referenceExpression), this.$names);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (ElementPattern)objectPattern;
    }

    @NotNull
    public static final List<String> getReferenceParts(@NotNull JSReferenceExpression jsReferenceExpression) {
        Intrinsics.checkNotNullParameter((Object)jsReferenceExpression, (String)"jsReferenceExpression");
        SmartList nameParts = new SmartList();
        JSReferenceExpression ref = jsReferenceExpression;
        while (ref != null) {
            String name = ref.getReferenceName();
            CharSequence charSequence = name;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                List list = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"emptyList(...)");
                return list;
            }
            nameParts.add((Object)name);
            JSExpression qualifier = ref.getQualifier();
            JSReferenceExpression jSReferenceExpression = qualifier instanceof JSReferenceExpression ? (JSReferenceExpression)qualifier : null;
            if (jSReferenceExpression == null) {
                jSReferenceExpression = (JSReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)qualifier), JSReferenceExpression.class);
            }
            ref = jSReferenceExpression;
        }
        Collections.reverse((List)nameParts);
        return (List)nameParts;
    }

    @NotNull
    public static final ElementPattern<? extends PsiElement> jsxAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        XmlAttributeValuePattern cssAttributePattern2 = XmlPatterns.xmlAttributeValue((ElementPattern)((ElementPattern)XmlPatterns.xmlAttribute((String)name).withParent((ElementPattern)XmlPatterns.xmlTag().with((PatternCondition)new PatternCondition<XmlTag>(){

            public boolean accepts(XmlTag tag, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return DialectDetector.isJSX((PsiElement)((PsiElement)tag));
            }
        }))));
        XmlAttributeValuePattern stringValuedCssAttribute = (XmlAttributeValuePattern)cssAttributePattern2.withChild((ElementPattern)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN));
        JSElementPattern.Capture jsInCssAttributePattern2 = (JSElementPattern.Capture)((JSElementPattern.Capture)JSPatterns.jsLiteralExpression().with((PatternCondition)new PatternCondition<JSLiteralExpression>(){

            public boolean accepts(JSLiteralExpression literal, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                return literal.isStringLiteral() || literal instanceof JSStringTemplateExpression;
            }
        })).withAncestor(2, (ElementPattern)PlatformPatterns.psiElement(JSEmbeddedContent.class).withParent((ElementPattern)cssAttributePattern2));
        ElementPattern[] elementPatternArray = new ElementPattern[]{stringValuedCssAttribute, jsInCssAttributePattern2};
        ElementPattern elementPattern = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        return elementPattern;
    }

    @NotNull
    public static final ElementPattern<? extends PsiElement> jsxBodyText(@NotNull String tagName, String ... attributeNames) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)attributeNames, (String)"attributeNames");
        TreeElementPattern treeElementPattern = ((JSElementPattern.Capture)JSPatterns.jsLiteralExpression().with((PatternCondition)new PatternCondition<JSLiteralExpression>(){

            public boolean accepts(JSLiteralExpression literal, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                return literal.isStringLiteral() || literal instanceof JSStringTemplateExpression;
            }
        })).withAncestor(3, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(tagName)).withAnyAttribute(Arrays.copyOf(attributeNames, attributeNames.length)));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withAncestor(...)");
        return (ElementPattern)treeElementPattern;
    }
}

