/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.connectionFrame;

import com.intellij.core.CoreBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ToolbarService;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.EDT;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.CustomConnectionFrameComponentProvider;
import com.jetbrains.gateway.api.CustomConnectionFrameContext;
import com.jetbrains.gateway.api.DefaultCustomConnectionFrameComponentProviderKt;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.gateway.connectionFrame.ConnectionFrame;
import com.jetbrains.gateway.connectionFrame.ConnectionFrameKt;
import com.jetbrains.gateway.connectionFrame.ConnectionFrameManagerImpl;
import com.jetbrains.gateway.connectionFrame.TrayIconHelper;
import java.awt.Component;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/gateway/connectionFrame/ConnectionFrame;", "Ljavax/swing/JDialog;", "Lcom/intellij/openapi/Disposable;", "handle", "Lcom/jetbrains/gateway/api/GatewayConnectionHandle;", "<init>", "(Lcom/jetbrains/gateway/api/GatewayConnectionHandle;)V", "handleTitle", "", "trayIcon", "Ljava/awt/TrayIcon;", "createComponentContext", "Lcom/jetbrains/gateway/api/CustomConnectionFrameContext;", "showDialogIfNeeded", "", "hideToTray", "restoreFromTray", "disconnect", "setupTrayIcon", "", "removeTrayIcon", "Companion", "intellij.gateway"})
@SourceDebugExtension(value={"SMAP\nConnectionFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionFrame.kt\ncom/jetbrains/gateway/connectionFrame/ConnectionFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n2792#2,3:175\n13#3:178\n*S KotlinDebug\n*F\n+ 1 ConnectionFrame.kt\ncom/jetbrains/gateway/connectionFrame/ConnectionFrame\n*L\n73#1:175,3\n35#1:178\n*E\n"})
public final class ConnectionFrame
extends JDialog
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GatewayConnectionHandle handle;
    @NotNull
    private final String handleTitle;
    @Nullable
    private final TrayIcon trayIcon;
    @NotNull
    private static final Logger logger;

    public ConnectionFrame(@NotNull GatewayConnectionHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        super(ConnectionFrameKt.access$getWindow$p());
        this.handle = handle;
        this.handleTitle = this.handle.getTitle();
        this.trayIcon = TrayIconHelper.INSTANCE.create(this.handleTitle, (Function0<Unit>)((Function0)() -> ConnectionFrame.trayIcon$lambda$0(this)), (Function0<Unit>)((Function0)() -> ConnectionFrame.trayIcon$lambda$1(this)));
        this.setDefaultCloseOperation(0);
        this.setTitle(this.handleTitle);
        final CustomConnectionFrameComponentProvider customComponentProvider = this.handle.customComponentProvider(this.handle.getLifetime());
        this.setContentPane(customComponentProvider.createComponent(this.createComponentContext(this.trayIcon)));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String[] stringArray = new String[]{GatewayBundle.INSTANCE.message("connectionFrame.confirmation.disconnect", new Object[0]), DefaultCustomConnectionFrameComponentProviderKt.hideToTrayActionName(), CoreBundle.message((String)"button.cancel", (Object[])new Object[0])};
                int res = Messages.showDialog((String)customComponentProvider.getCloseConfirmationText(), (String)GatewayBundle.INSTANCE.message("connectionFrame.disconnectDialog.title", new Object[0]), (String[])stringArray, (int)1, (Icon)Messages.getWarningIcon());
                switch (res) {
                    case 0: {
                        this.disconnect();
                        break;
                    }
                    case 1: {
                        this.hideToTray();
                    }
                }
            }
        });
        this.handle.getLifetime().onTermination(() -> ConnectionFrame._init_$lambda$0(this));
        ComponentUtil.decorateWindowHeader((JRootPane)this.rootPane);
        ToolbarService toolbarService = ToolbarService.Companion.getInstance();
        Window window = this;
        JRootPane jRootPane = this.rootPane;
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
        toolbarService.setTransparentTitleBar(window, jRootPane, arg_0 -> ConnectionFrame._init_$lambda$1(this, arg_0));
        MnemonicHelper.init((Component)this);
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.showDialogIfNeeded();
    }

    private final CustomConnectionFrameContext createComponentContext(TrayIcon trayIcon) {
        return new CustomConnectionFrameContext(trayIcon, this){
            private final CustomConnectionFrameContext.HideToTrayPossibility hideToTrayPossibility;
            final /* synthetic */ ConnectionFrame this$0;
            {
                this.this$0 = $receiver;
                this.hideToTrayPossibility = $trayIcon == null ? (CustomConnectionFrameContext.HideToTrayPossibility)CustomConnectionFrameContext.HideToTrayPossibility.Impossible.INSTANCE : (CustomConnectionFrameContext.HideToTrayPossibility)new CustomConnectionFrameContext.HideToTrayPossibility.Possible(() -> createComponentContext.1.hideToTrayPossibility$lambda$0(this));
            }

            public CustomConnectionFrameContext.HideToTrayPossibility getHideToTrayPossibility() {
                return this.hideToTrayPossibility;
            }

            public void openGateway() {
                WelcomeFrame.Companion.showIfNoProjectOpened$default((WelcomeFrame.Companion)WelcomeFrame.Companion, null, (int)1, null);
            }

            public void hideToTray() {
                ConnectionFrame.access$hideToTray(this.this$0);
            }

            private static final Unit hideToTrayPossibility$lambda$0(createComponentContext.1 this$0) {
                this$0.hideToTray();
                return Unit.INSTANCE;
            }
        };
    }

    private final void showDialogIfNeeded() {
        if (this.handle.hideToTrayOnStart() && this.setupTrayIcon()) {
            logger.info("Hide window '" + this.getTitle() + "' into tray on startup");
            this.setVisible(false);
        } else {
            logger.info("Window '" + this.getTitle() + "': show on startup");
            this.setVisible(true);
            this.requestFocus();
        }
    }

    private final void hideToTray() {
        if (!this.isVisible()) {
            logger.error("Window '" + this.getTitle() + "' is already hidden");
        } else if (this.setupTrayIcon()) {
            logger.info("Hide window '" + this.getTitle() + "' into tray");
            this.setVisible(false);
        }
    }

    private final void restoreFromTray() {
        if (this.isVisible()) {
            logger.error("Window '" + this.getTitle() + "' is already shown");
        } else {
            logger.info("Restore window '" + this.getTitle() + "' from tray");
            this.removeTrayIcon();
            this.setVisible(true);
        }
    }

    private final void disconnect() {
        logger.info("Disconnect '" + this.getTitle() + "'");
        this.handle.terminate();
    }

    private final boolean setupTrayIcon() {
        EDT.assertIsEdt();
        if (this.trayIcon == null) {
            return false;
        }
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
            return true;
        }
        catch (Throwable ex) {
            logger.warn(ex);
            return false;
        }
    }

    private final void removeTrayIcon() {
        EDT.assertIsEdt();
        if (this.trayIcon == null) {
            return;
        }
        SystemTray.getSystemTray().remove(this.trayIcon);
    }

    private static final Unit trayIcon$lambda$0(ConnectionFrame this$0) {
        this$0.restoreFromTray();
        return Unit.INSTANCE;
    }

    private static final Unit trayIcon$lambda$1(ConnectionFrame this$0) {
        this$0.disconnect();
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void lambda$0$0(ConnectionFrame this$0) {
        this$0.removeTrayIcon();
        if (ProjectUtil.getOpenProjects().length == 0 && WelcomeFrame.Companion.getInstance() == null) {
            boolean bl;
            block5: {
                GatewayConnectionFrameManager gatewayConnectionFrameManager = GatewayConnectionFrameManager.Companion.getInstance();
                Intrinsics.checkNotNull((Object)gatewayConnectionFrameManager, (String)"null cannot be cast to non-null type com.jetbrains.gateway.connectionFrame.ConnectionFrameManagerImpl");
                Iterable $this$none$iv = ((ConnectionFrameManagerImpl)gatewayConnectionFrameManager).get();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Disposable it = (Disposable)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)this$0))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                ApplicationManager.getApplication().exit();
                return;
            }
        }
        Disposer.dispose((Disposable)this$0);
    }

    private static final void lambda$1$0(Runnable $runnable) {
        $runnable.run();
    }

    private static final Unit _init_$lambda$0(ConnectionFrame this$0) {
        ApplicationKt.getApplication().invokeLater(() -> ConnectionFrame.lambda$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ConnectionFrame this$0, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Disposer.register((Disposable)this$0, () -> ConnectionFrame.lambda$1$0(runnable));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConnectionFrame.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ConnectionFrame.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/connectionFrame/ConnectionFrame$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

