/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions;

import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DataSnapshot;
import com.intellij.openapi.actionSystem.DataSnapshotProvider;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.requests.PatchEngineErrorsKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.codeWithMe.actions.RdPlatformDataKeys;
import com.jetbrains.rd.ui.ComponentIdProviders;
import com.jetbrains.rd.ui.bindable.ConverterStorage;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.BackendActionDataContext;
import com.jetbrains.rdserver.actions.BackendActionDataContextKt;
import com.jetbrains.rdserver.actions.BackendActionDataProvider;
import com.jetbrains.rdserver.actions.BackendDataKeys;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.ContextIdTimestampsKt;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHost;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/actions/BackendActionDataContext;", "", "<init>", "()V", "create", "Lcom/intellij/openapi/actionSystem/DataContext;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "requestTimestampSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "actualTimestampSet", "getContextComponent", "Ljava/awt/Component;", "timestampContext", "getContextComponent1", "getContextComponent2", "getContextComponent3", "getContextComponent4", "createTimestampProvider", "Lcom/intellij/openapi/actionSystem/DataSnapshotProvider;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendActionDataContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendActionDataContext.kt\ncom/jetbrains/rdserver/actions/BackendActionDataContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n1915#3,2:132\n*S KotlinDebug\n*F\n+ 1 BackendActionDataContext.kt\ncom/jetbrains/rdserver/actions/BackendActionDataContext\n*L\n42#1:132,2\n*E\n"})
public final class BackendActionDataContext {
    @NotNull
    public static final BackendActionDataContext INSTANCE = new BackendActionDataContext();

    private BackendActionDataContext() {
    }

    @NotNull
    public final DataContext create(@NotNull ClientAppSession session, @NotNull ActionTimestampSet requestTimestampSet, @NotNull ActionTimestampSet actualTimestampSet) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)requestTimestampSet, (String)"requestTimestampSet");
        Intrinsics.checkNotNullParameter((Object)actualTimestampSet, (String)"actualTimestampSet");
        DataSnapshotProvider timestampProvider = this.createTimestampProvider(session, requestTimestampSet, actualTimestampSet);
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)DataContext.EMPTY_CONTEXT, (DataSnapshotProvider)timestampProvider);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"withSnapshot(...)");
        DataContext timestampContext = dataContext;
        Component component = this.getContextComponent(session, timestampContext);
        DataContext dataContext2 = DataManager.getInstance().getDataContext(component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext componentContext = dataContext2;
        DataContext dataContext3 = CustomizedDataContext.withSnapshot((DataContext)componentContext, arg_0 -> BackendActionDataContext.create$lambda$0(timestampContext, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"withSnapshot(...)");
        DataContext customized12 = dataContext3;
        DataContext dataContext4 = CustomizedDataContext.withSnapshot((DataContext)customized12, (DataSnapshotProvider)timestampProvider);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext4, (String)"withSnapshot(...)");
        DataContext customized2 = dataContext4;
        return Utils.createAsyncDataContext((DataContext)customized2);
    }

    private final Component getContextComponent(ClientAppSession session, DataContext timestampContext) {
        Component component = this.getContextComponent1(session, timestampContext);
        if (component == null && (component = this.getContextComponent2(session, timestampContext)) == null && (component = this.getContextComponent3(session, timestampContext)) == null) {
            component = this.getContextComponent4(timestampContext);
        }
        return component;
    }

    private final Component getContextComponent1(ClientAppSession session, DataContext timestampContext) {
        Serializable serializable;
        block5: {
            block3: {
                Component component;
                block4: {
                    Pair pair = (Pair)ContextIdTimestampsKt.getBE_CONTEXT_ID_KEY().getData(timestampContext);
                    if (pair == null) {
                        return null;
                    }
                    Pair context = pair;
                    Component component2 = ConverterStorage.Companion.getInstance(session).tryGetComponentByDataId((Integer)context.getFirst());
                    if (component2 == null) break block3;
                    component = component2;
                    boolean bl = false;
                    serializable = (Point)context.getSecond();
                    if (serializable == null) break block4;
                    Point it = serializable;
                    boolean bl2 = false;
                    Component component3 = UIUtil.getDeepestComponentAt((Component)component, (int)it.x, (int)it.y);
                    serializable = component3;
                    if (component3 != null) break block5;
                }
                serializable = component;
                break block5;
            }
            serializable = null;
        }
        return serializable;
    }

    private final Component getContextComponent2(ClientAppSession session, DataContext timestampContext) {
        JPanel jPanel;
        Notification notification = (Notification)Notification.KEY.getData(timestampContext);
        if (notification != null) {
            Notification it = notification;
            boolean bl = false;
            jPanel = BackendNotificationsHost.Companion.getInstance(session).getFakeVisibleComponent();
        } else {
            jPanel = null;
        }
        return jPanel;
    }

    private final Component getContextComponent3(ClientAppSession session, DataContext timestampContext) {
        ComponentId componentId = (ComponentId)RdPlatformDataKeys.Companion.getCONTROL_ID().getData(timestampContext);
        if (componentId == null) {
            return null;
        }
        ComponentId componentId2 = componentId;
        return ComponentIdProviders.tryGetComponentById$default((ComponentIdProviders)ComponentIdProviders.INSTANCE, (ComponentId)componentId2, (ClientAppSession)session, null, (int)4, null);
    }

    private final Component getContextComponent4(DataContext timestampContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(timestampContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return WindowManager.getInstance().getFrame(project2);
    }

    private final DataSnapshotProvider createTimestampProvider(ClientAppSession session, ActionTimestampSet requestTimestampSet, ActionTimestampSet actualTimestampSet) {
        ProjectTimestamp projectTimestamp = requestTimestampSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        RdProjectId projectId = projectTimestamp != null ? projectTimestamp.getProjectId() : null;
        ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)projectId);
        return new DataSnapshotProvider(session, projectSession, requestTimestampSet, actualTimestampSet){
            private boolean failed;
            private final ConcurrentHashMap<ActionTimestamp<?>, Object> dataMap;
            final /* synthetic */ ClientAppSession $session;
            final /* synthetic */ ClientProjectSession $projectSession;
            final /* synthetic */ ActionTimestampSet $requestTimestampSet;
            final /* synthetic */ ActionTimestampSet $actualTimestampSet;
            {
                this.$session = $session;
                this.$projectSession = $projectSession;
                this.$requestTimestampSet = $requestTimestampSet;
                this.$actualTimestampSet = $actualTimestampSet;
                this.dataMap = new ConcurrentHashMap<K, V>();
            }

            public void dataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                sink.set(BackendDataKeys.INSTANCE.getAPP_SESSION(), (Object)this.$session);
                sink.set(BackendDataKeys.INSTANCE.getPROJECT_SESSION(), (Object)this.$projectSession);
                if (this.failed) {
                    BackendActionDataContextKt.access$getLOG$p().warn("Requesting snapshot for already failed DataContext");
                    PatchEngineErrorsKt.patchEngineFail$default((String)"Requesting snapshot for already failed DataContext", null, (int)2, null);
                    throw new KotlinNothingValueException();
                }
                this.$requestTimestampSet.getAllTimestamps().forEach((arg_0, arg_1) -> createTimestampProvider.1.dataSnapshot$lambda$1((arg_0, arg_1) -> createTimestampProvider.1.dataSnapshot$lambda$0(this, this.$actualTimestampSet, sink, arg_0, arg_1), arg_0, arg_1));
            }

            private static final Unit dataSnapshot$lambda$0(createTimestampProvider.1 this$0, ActionTimestampSet $actualTimestampSet, DataSink $sink, String dataId, ActionTimestamp requestTimestamp) {
                Object data;
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                Intrinsics.checkNotNullParameter((Object)requestTimestamp, (String)"requestTimestamp");
                Object existing = this$0.dataMap.get(requestTimestamp);
                Object object = existing;
                if (object == null) {
                    if (requestTimestamp instanceof UpgradableTimestamp) {
                        TimestampUpgradeResult result = ((UpgradableTimestamp)requestTimestamp).upgrade($actualTimestampSet);
                        if (result instanceof TimestampUpgradeResult.Failure) {
                            this$0.failed = true;
                            Logger $this$trace$iv = BackendActionDataContextKt.access$getLOG$p();
                            boolean $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                Logger logger = $this$trace$iv;
                                boolean bl = false;
                                logger.trace("Timestamp upgrade for " + dataId + " failed");
                            }
                            PatchEngineErrorsKt.patchEngineFail$default((String)((TimestampUpgradeResult.Failure)result).getMessage(), null, (int)2, null);
                            throw new KotlinNothingValueException();
                        }
                        if (result instanceof TimestampUpgradeResult.RetryRequest) {
                            this$0.failed = true;
                            Logger $this$trace$iv = BackendActionDataContextKt.access$getLOG$p();
                            boolean $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                Logger logger = $this$trace$iv;
                                boolean bl = false;
                                logger.trace("Timestamp upgrade for " + dataId + " required a retry");
                            }
                            PatchEngineErrorsKt.patchEngineRetry$default((String)((TimestampUpgradeResult.RetryRequest)result).getMessage(), null, (int)2, null);
                            throw new KotlinNothingValueException();
                        }
                        if (result instanceof TimestampUpgradeResult.Success) {
                            Object object2;
                            Object it = object2 = ((TimestampUpgradeResult.Success)result).getTimestamp().getData();
                            boolean bl = false;
                            ((Map)this$0.dataMap).put(requestTimestamp, it);
                            object = object2;
                        } else {
                            object = ((UpgradableTimestamp)requestTimestamp).getData();
                        }
                    } else {
                        object = requestTimestamp.getData();
                    }
                }
                if ((data = object) != null) {
                    $sink.set(DataKey.Companion.create(dataId), data);
                }
                return Unit.INSTANCE;
            }

            private static final void dataSnapshot$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        };
    }

    private static final void create$lambda$0(DataContext $timestampContext, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataSnapshot snapshot2 = new DataSnapshot($timestampContext){
            final /* synthetic */ DataContext $timestampContext;
            {
                this.$timestampContext = $timestampContext;
            }

            public <T> T get(DataKey<T> key) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                return (T)key.getData(this.$timestampContext);
            }
        };
        Iterable $this$forEach$iv = BackendActionDataProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackendActionDataProvider provider = (BackendActionDataProvider)element$iv;
            boolean bl = false;
            provider.dataSnapshot(sink, snapshot2);
        }
    }
}

