/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.cef;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.ide.model.CefModel_GeneratedKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.cef.BackendCefBrowser;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/cef/BackendCefHost;", "", "<init>", "()V", "idGenerator", "", "bind", "Lkotlin/Pair;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "browser", "Lcom/jetbrains/rdserver/cef/BackendCefBrowser;", "createImmediately", "", "SessionListener", "intellij.platform.backend.split"})
public final class BackendCefHost {
    private int idGenerator;

    @RequiresEdt
    @Nullable
    public final Pair<Integer, Lifetime> bind(@NotNull BackendCefBrowser browser, boolean createImmediately) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        ClientAppSession clientAppSession = (ClientAppSession)CollectionsKt.firstOrNull((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER));
        if (clientAppSession == null) {
            return null;
        }
        ClientAppSession controllerSession = clientAppSession;
        Protocol protocol = RemoteSessionKt.getProtocol(controllerSession);
        ++this.idGenerator;
        int id = this.idGenerator;
        Lifetime lifetime = RLifetimeKt.intersect((Lifetime)protocol.getLifetime(), (Lifetime)browser.getLifetime());
        ((Map)CefModel_GeneratedKt.getCefModel((IProtocol)((IProtocol)protocol)).getBrowsers()).put(id, browser.toModel(lifetime, createImmediately));
        lifetime.onTermination(() -> BackendCefHost.bind$lambda$0(protocol, id));
        return TuplesKt.to((Object)id, (Object)lifetime);
    }

    private static final Unit bind$lambda$0(Protocol $protocol, int $id) {
        CefModel_GeneratedKt.getCefModel((IProtocol)((IProtocol)$protocol)).getBrowsers().remove((Object)$id);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/cef/BackendCefHost$SessionListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "appSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.platform.backend.split"})
    public static final class SessionListener
    implements RemoteClientSessionListener {
        @Override
        public void appSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            if (session.isController()) {
                CefModel_GeneratedKt.getCefModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(session)));
            }
        }
    }
}

