/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.inlays;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.EditorCodeVisionContextKt;
import com.intellij.codeInsight.codeVision.ui.model.CounterCodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.RichTextCodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.ZeroWidthCodeVisionEntry;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.CodeVisionEntryBase;
import com.jetbrains.rd.ide.model.CodeVisionHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.TextCodeVisionEntry;
import com.jetbrains.rd.ide.model.ZombieCodeVisionEntry;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.ui.util.RichText;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerModelCreator;
import com.jetbrains.rdserver.daemon.inlays.BackendCodeVisionInlayModelCreatorKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendCodeVisionInlayModelCreator;", "Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerModelCreator;", "<init>", "()V", "accept", "", "rangeMarker", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "createModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "toModel", "Lcom/jetbrains/rd/ide/model/CodeVisionEntryBase;", "entry", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "intellij.platform.backend.split"})
public final class BackendCodeVisionInlayModelCreator
implements BackendRangeMarkerModelCreator {
    @Override
    public boolean accept(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        return rangeMarker.getUserData(EditorCodeVisionContextKt.getCodeVisionEntryOnHighlighterKey()) != null;
    }

    @Override
    @NotNull
    public HighlighterModel createModel(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        Object object = rangeMarker.getUserData(EditorCodeVisionContextKt.getCodeVisionEntryOnHighlighterKey());
        Intrinsics.checkNotNull((Object)object);
        return (HighlighterModel)new CodeVisionHighlighterModel(this.toModel((CodeVisionEntry)object), 0, true, (AbstractDocumentVersion)contributor.getDocumentVersion(), rangeMarker.isGreedyToLeft(), rangeMarker.isGreedyToRight(), false, null, null, rangeMarker.getId(), BackendCodeVisionInlayModelCreatorKt.access$getProperties$p(), rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
    }

    private final CodeVisionEntryBase toModel(CodeVisionEntry entry) {
        CodeVisionEntryBase codeVisionEntryBase;
        Icon icon2 = entry.getIcon();
        IconModel icon3 = icon2 != null ? UtilKt.toModel((Icon)icon2) : null;
        String longPresentation = entry.getLongPresentation();
        String tooltip = entry.getTooltip();
        String providerId = entry.getProviderId();
        CodeVisionEntry codeVisionEntry = entry;
        if (codeVisionEntry instanceof RichTextCodeVisionEntry) {
            codeVisionEntryBase = (CodeVisionEntryBase)new com.jetbrains.rd.ide.model.RichTextCodeVisionEntry(RichText.Companion.toRichText(((RichTextCodeVisionEntry)entry).getText()).toRichTextModel(), providerId, icon3, longPresentation, tooltip, CollectionsKt.emptyList());
        } else if (codeVisionEntry instanceof CounterCodeVisionEntry) {
            codeVisionEntryBase = (CodeVisionEntryBase)new com.jetbrains.rd.ide.model.CounterCodeVisionEntry(((CounterCodeVisionEntry)entry).getCount(), ((CounterCodeVisionEntry)entry).getText(), providerId, icon3, longPresentation, tooltip, CollectionsKt.emptyList());
        } else if (codeVisionEntry instanceof com.intellij.codeInsight.codeVision.ui.model.TextCodeVisionEntry) {
            codeVisionEntryBase = (CodeVisionEntryBase)new TextCodeVisionEntry(((com.intellij.codeInsight.codeVision.ui.model.TextCodeVisionEntry)entry).getText(), providerId, icon3, longPresentation, tooltip, CollectionsKt.emptyList());
        } else if (codeVisionEntry instanceof com.intellij.codeInsight.codeVision.ui.model.ZombieCodeVisionEntry) {
            codeVisionEntryBase = (CodeVisionEntryBase)new ZombieCodeVisionEntry(((com.intellij.codeInsight.codeVision.ui.model.ZombieCodeVisionEntry)entry).getCount(), ((com.intellij.codeInsight.codeVision.ui.model.ZombieCodeVisionEntry)entry).getText(), providerId, icon3, longPresentation, tooltip, CollectionsKt.emptyList());
        } else if (codeVisionEntry instanceof ZeroWidthCodeVisionEntry) {
            codeVisionEntryBase = (CodeVisionEntryBase)new com.jetbrains.rd.ide.model.ZeroWidthCodeVisionEntry(providerId, icon3, longPresentation, tooltip, CollectionsKt.emptyList());
        } else {
            throw new IllegalStateException(("'" + entry.getClass().getName() + "' code vision entry isn't supposed to be sent to thin client.").toString());
        }
        return codeVisionEntryBase;
    }
}

