/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.diagnostics;

import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendOptionsManipulator;", "", "<init>", "()V", "Companion", "intellij.platform.backend.split"})
public final class BackendOptionsManipulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    private static final long mbCoefficient = 0x100000L;
    private static final Pattern xmxPattern;

    static {
        Logger logger = Logger.getInstance(BackendOptionsManipulator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        xmxPattern = Pattern.compile("-Xmx([0-9]+).{1,2}");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendOptionsManipulator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "mbCoefficient", "", "xmxPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "shouldEditBundledVmOptions", "", "readCurrentXmxValue", "setXmxValue", "", "newValue", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldEditBundledVmOptions() {
            return !SystemProperties.getBooleanProperty((String)"ide.native.launcher", (boolean)false);
        }

        public final long readCurrentXmxValue() {
            if (!this.shouldEditBundledVmOptions()) {
                return VMOptions.readOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (boolean)false);
            }
            long realXmx = Runtime.getRuntime().maxMemory() / 0x100000L;
            Path path = VMOptions.getPlatformOptionsFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPlatformOptionsFile(...)");
            Path platformFile = path;
            if (Files.exists(platformFile, new LinkOption[0])) {
                try {
                    long lastXmxInFile = realXmx;
                    List<String> platformOptions = Files.readAllLines(platformFile, VMOptions.getFileCharset());
                    for (String option : platformOptions) {
                        Matcher matcher = xmxPattern.matcher(option);
                        if (!matcher.matches()) continue;
                        String string = matcher.group(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                        lastXmxInFile = Long.parseLong(string);
                    }
                    return Math.max(lastXmxInFile, realXmx);
                }
                catch (IOException e) {
                    LOG.error("Can't read vm options file " + ((Object)platformFile.toAbsolutePath()).toString(), (Throwable)e);
                }
            }
            return realXmx;
        }

        public final void setXmxValue(int newValue) {
            if (!this.shouldEditBundledVmOptions()) {
                VMOptions.setOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (int)newValue);
                return;
            }
            String newOptionValue = "-Xmx" + newValue + "m";
            Path path = VMOptions.getPlatformOptionsFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPlatformOptionsFile(...)");
            Path platformFile = path;
            List<String> platformOptions = CollectionsKt.emptyList();
            if (Files.exists(platformFile, new LinkOption[0])) {
                try {
                    List<String> list = Files.readAllLines(platformFile, VMOptions.getFileCharset());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    platformOptions = list;
                }
                catch (IOException e) {
                    LOG.error("Can't read vm options file " + ((Object)platformFile.toAbsolutePath()).toString(), (Throwable)e);
                    return;
                }
                v2 = Unit.INSTANCE;
            } else {
                Path e = PathKt.createParentDirectories((Path)platformFile);
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createFile(e, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                v2 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
            }
            ArrayList<Object> updatedPlatformOptions = new ArrayList<Object>();
            boolean foundXmx = false;
            for (String string : platformOptions) {
                boolean bl;
                if (xmxPattern.matcher(string).matches()) {
                    foundXmx = true;
                    bl = updatedPlatformOptions.add(newOptionValue);
                    continue;
                }
                bl = updatedPlatformOptions.add(string);
            }
            if (!foundXmx) {
                updatedPlatformOptions.add(newOptionValue);
            }
            try {
                Path path3 = platformFile;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path3, (Iterable<? extends CharSequence>)updatedPlatformOptions, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
            }
            catch (IOException iOException) {
                LOG.error("Can't write vm options to file " + ((Object)platformFile.toAbsolutePath()).toString(), (Throwable)iOException);
                return;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

